package im.dx.system.controller;

import im.dx.common.shiro.ShiroActionProperties;
import im.dx.common.util.ResultBean;
import im.dx.system.model.Dept;
import im.dx.system.model.DeptVideo;
import im.dx.system.service.DeptService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Controller
@RequestMapping("/dept")
public class DeptController {

    @Autowired
    private DeptService deptService;

    @Autowired
    private ShiroActionProperties shiroActionProperties;

    @Value("${managername}")
    private String managername;



    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @GetMapping("/index")
    public String index() {
        return "dept/dept-list";
    }

    /***
     * 获取部门列表
     * @param parentId
     * @return
     */
    @GetMapping("/list")
    @ResponseBody
    public ResultBean getList(@RequestParam(value="parentId",required = false) Integer parentId) {
        List<Dept> deptList = deptService.selectByParentId(parentId);
        return ResultBean.success(deptList);
    }

    @GetMapping("/tree/root")
    @ResponseBody
    public ResultBean treeAndRoot() {
        return ResultBean.success(deptService.selectAllTreeAndRoot());
    }

    @GetMapping("/tree")
    @ResponseBody
    public ResultBean tree() {
        return ResultBean.success(deptService.selectAllTree());
    }





    @GetMapping
    public String add() {
        return "dept/dept-add";
    }

    /***
     * 新增部门
     * @param dept
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/add", method = RequestMethod.POST)
    public ResultBean addinfo(Dept dept) {
        if(null==dept.getDeptId() ||dept.getDeptId().equals(""))
        {
            dept.setDeptId(deptService.selectMaxOrderNum()+1);
        }
        dept.setCreateTime(sdf.format(new Date()));
        dept.setModifyTime(dept.getCreateTime());
        return ResultBean.success(deptService.insert(dept));
    }

    /***
     * 删除部门
     * @param deptId
     * @return
     */
    @DeleteMapping("/{deptId}")
    @ResponseBody
    public ResultBean delete(@PathVariable("deptId") Integer deptId) {
        deptService.deleteCascadeByID(deptId);
        return ResultBean.success();
    }

    /***
     * 修改部门
     * @param dept
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/update", method = RequestMethod.POST)
    public ResultBean update(Dept dept) {
        dept.setModifyTime(sdf.format(new Date()));
        deptService.updateByPrimaryKey(dept);
        return ResultBean.success();
    }

    @GetMapping("/{deptId}")
    public ResultBean getDeptById(@PathVariable("deptId") String deptId) {
        List<Map> dept = deptService.selectByPrimaryKey(deptId);
        return ResultBean.success(dept);
    }


    @GetMapping("/getDeptParent/{deptId}")
    @ResponseBody
    public ResultBean getDeptParent(@PathVariable("deptId") String deptId) {
        List<Map> dept = deptService.selectByPrimaryKey(deptId);

        return ResultBean.success(dept);
    }


    /***
     * 查询部门及監控
     * @param deptId
     * @param username
     * @param tdmc
     * @return
     */
    @GetMapping("/listvideo")
    @ResponseBody
    public ResultBean listvideo( @RequestParam("deptId") String  deptId,@RequestParam("username") String username,@RequestParam("tdmc")String tdmc) {
        if (null!=username && (shiroActionProperties.getSuperAdminUsername().equals(username)
                ||username.equalsIgnoreCase(managername))) {
            deptId = "0";
            username=null;
        }
        List<DeptVideo> deptlist=deptService.listvideo(deptId, username,tdmc);
       return ResultBean.success(deptlist);
    }


    /**
     * 查询所有监控
     * @param deptid
     * @return
     */
    @GetMapping("/listAllvideoIdsByDeptid")
    @ResponseBody
    public ResultBean listAllvideoIdsByDeptid(@RequestParam("deptid") String deptid) {

        List<Map> deptList = deptService.listAllvideoIdsByDeptid(deptid);
        return ResultBean.success(deptList);
    }



}
