//region 切换tab页面
let vue_tree = new Vue({
    el: '.left-nav',
    data: {
        data_tree: [
            {text: '用户管理', state: {selected: true}, icon: 'glyphicon glyphicon-home', tags: 0},
            {text: '首页默认查询监控', state: {selected: false}, icon: 'glyphicon glyphicon-home', tags: 1},
        ]
    }
});
$('#tree-ul').treeview({
    data: vue_tree.data_tree,
    levels: 5,
    color: '#aaaaaa',
    backColor: '#ffffff00',
    selectedBackColor: '#393F55',
    selectedColor: '#ffffff',
    onhoverColor: '#ffffff00',
    showBorder: false,
    onNodeSelected: function (event, node) {
        vue_ul.cur = node.tags;
        $(".content-sjfx>div").removeClass("active");
        $(".content-sjfx").children().eq(node.tags).addClass("active");
    }
});
let vue_ul = new Vue({
    el: '.nav-tabs',
    data: {
        data_ul: [
            {id: 'yhgl', text: '用户管理', tags: 0},
            {id: 'symrcxjk', text: '首页默认查询监控', tags: 1},
        ],
        cur: 0,
        first_node: 0,
        second_node: 0
    },
    methods: {
        gethref: function (id) {
            return "#" + id;
        },
    }
});
//endregion

//region 用户管理
let vue_yhgl = new Vue({
    el: '#yhgl',
    data: {
        data_table_rygl: [],
        level: '',
        data_tree: '',
        bm_id: '',
        count: '0',
    },
    methods: {
        add_ry: function () {
            $("#myModal").modal("show");
        },
        edit_ry: function () {
            $("#myModal1").modal("show");
        },
        add_bm: function () {
            if (this.level == '') {
                info_new("请选择部门");
                window.setTimeout("$('#info-warning-new').modal('hide')", 2000);
            } else if (this.level == '2') {
                info_new("大队不可新增部门");
                window.setTimeout("$('#info-warning-new').modal('hide')", 2000);
            } else {
                veu_myModal_bm_add.data_s.deptName = '';
                $("#myModal_bm_add").modal("show");
            }
        },
        edit_bm: function () {
            if (this.level == '') {
                info_new("请选择部门");
                window.setTimeout("$('#info-warning-new').modal('hide')", 2000);
            } else {
                veu_myModal_bm_edit.data_s = {
                    deptId: this.data_tree.href,
                    deptName: this.data_tree.text,
                }
                $("#myModal_bm_edit").modal("show");
            }
        },
        delete_bm: function () {
            if (this.bm_id === '') {
                info_new("请选择部门");
                window.setTimeout("$('#info-warning-new').modal('hide')", 2000);
            } else {
                if (this.level == '0') {
                    info_new("总队无法删除");
                    window.setTimeout("$('#info-warning-new').modal('hide')", 2000);
                }
                else {
                    if(!confirm("确认删除部门吗？")){
                        return;
                    }
                    $.ajax({
                        url: "/dept/" + this.bm_id,
                        dataType: "json",
                        type: "POST",
                        data: {
                            _method: "DELETE"
                        },
                        success: function (result) {
                            info_new("部门删除成功");
                            window.setTimeout("$('#info-warning-new').modal('hide')", 2000);
                            vue_yhgl.cxmb();
                        }
                    });
                }
            }

        },
        cxmb: function () {
            getByAjax("/dept/tree/root", (e)=> {
                vue_yhgl.level = '';
                vue_yhgl.bm_id = '';
                $('#tree-xzxq').treeview({
                    expandIcon: 'glyphicon glyphicon-triangle-right selected-span',
                    collapseIcon: 'glyphicon glyphicon-triangle-bottom selected-span',
                    nodeIcon: 'glyphicon glyphicon-folder-open selected-span',
                    selectedBackColor: '#ff000000',
                    selectedColor: '#368ff3',
                    onhoverColor: '#73a5ff26',
                    showBorder: false,
                    data: e,
                });
                $('#tree-xzxq').on('nodeSelected', function (event, data) {
                    vue_yhgl.level = data.level;
                    vue_yhgl.bm_id = data.href;
                    veu_myModal_bm_add.sjbmname = data.text;
                    veu_myModal_bm_add.data_s.parentId = data.href;
                    let levels = '';
                    if (data.level == '0') {
                        levels = '1';
                    } else if (data.level == '1') {
                        levels = '2';
                    }
                    veu_myModal_bm_add.data_s.level = levels;
                    vue_yhgl.data_tree = data;
                });
                $('#tree-xzxq').on('nodeUnselected', function (event, data) {
                    vue_yhgl.bm_id = '';
                    vue_yhgl.level = '';
                    vue_yhgl.data_tree = '';
                });
            });
        },
        queryRY: function (pages, items) {
            $.ajax({
                url: "/user/list/userByDeptId",
                dataType: "json",
                type: "get",
                data: {
                    page: pages,
                    pageSize: 10,
                    deptId: this.bm_id == '' ? '0' : this.bm_id,
                    userName: $("#ryxm").val(),
                },
                success: function (result) {
                    vue_yhgl.data_table_rygl = [];
                    if (result.code == 0) {
                        let a_sum = result.count;
                        vue_yhgl.count = result.count;
                        vue_yhgl.data_table_rygl = result.data;
                        if (items) {
                            $("#fy4").bootstrapPaginator({
                                bootstrapMajorVersion: 3, //版本，这里设置为3，大于2即可
                                currentPage: 1,//当前页
                                totalPages: Math.ceil(((a_sum > 0) ? a_sum : 1) / 5),//总页数
                                numberofPages: 10,//显示的页数
                                itemTexts: function (type, page, current) { //修改显示文字
                                    switch (type) {
                                        case "first":
                                            return "首页";
                                        case "prev":
                                            return "上一页";
                                        case "next":
                                            return "下一页";
                                        case "last":
                                            return "末页";
                                        case "page":
                                            return page;
                                    }
                                }, onPageClicked: function (event, originalEvent, type, page) { //异步换页
                                    //请求加载数据
                                    this.queryRY(page, false);
                                }
                            });
                        }
                    }
                }
            });
        }
    },
    mounted(){
        this.cxmb();
        this.queryRY(1, true);
    }
});
//endregion

//region 新增部门
let veu_myModal_bm_add = new Vue({
    el: '#myModal_bm_add',
    data: {
        sjbmname: '',
        data_s: {
            deptName: '',
            parentId: '',
            level: '',
        },
    },
    methods: {
        define: function () {
            if (this.data_s.deptName == '') {
                return;
            } else {
                $.ajax({
                    url: "/dept/add",
                    dataType: "json",
                    type: "POST",
                    data: this.data_s,
                    success: function (result) {
                        $("#myModal_bm_add").modal("hide");
                        info_new("新增部门成功");
                        window.setTimeout("$('#info-warning-new').modal('hide')", 2000);
                        vue_yhgl.cxmb();
                    }
                });
            }
        }
    }
});
//endregion

//region 编辑部门
let veu_myModal_bm_edit = new Vue({
    el: '#myModal_bm_edit',
    data: {
        data_s: {
            deptName: '',
            parentId: '',
            level: '',
        },
    },
    methods: {
        define: function () {
            if (this.data_s.deptName == '') {
                return;
            } else {
                $.ajax({
                    url: "/dept/update",
                    dataType: "json",
                    type: "POST",
                    data: this.data_s,
                    success: function (result) {
                        $("#myModal_bm_edit").modal("hide");
                        info_new("编辑部门成功");
                        window.setTimeout("$('#info-warning-new').modal('hide')", 2000);
                        vue_yhgl.cxmb();
                    }
                });
            }
        }
    }
});
//endregion

let vue_addYR = new Vue({
    el:'#myModal',
    data:{
        data_yr:{},
    },
    methods:{
        define: function () {
            // $.ajax({
            //     url: "/dept/add",
            //     dataType: "json",
            //     type: "POST",
            //     data: this.data_s,
            //     success: function (result) {
            //         $("#myModal_bm_add").modal("hide");
            //         info_new("新增部门成功");
            //         window.setTimeout("$('#info-warning-new').modal('hide')", 2000);
            //         vue_yhgl.cxmb();
            //     }
            // });
        }
    }
});

//region 默认首页监控
let vue_sjcx1 = new Vue({
    el: '#symrcxjk',
    data: {
        searchText: '',
        data_table_monitor: [
            {
                jkmc: '监控1',
                ssbm: '大队一',
            },
        ],
    },
    methods: {
        add_monitor: function () {
            $("#myModal2").modal("show");
        },
        fastSearch: function () {
            $("#tree-xzxq1").treeview('search', [this.searchText, {
                ignoreCase: true,      // case insensitive
                exactMatch: false,     // like or equals
                revealResults: true,   // reveal matching nodes
            }]);
        },
    },
    mounted(){
        getByAjax("/dept/tree/root", (e)=> {
            $('#tree-monitor').treeview({
                expandIcon: 'glyphicon glyphicon-triangle-right selected-span',
                collapseIcon: 'glyphicon glyphicon-triangle-bottom selected-span',
                nodeIcon: 'glyphicon glyphicon-folder-open selected-span',
                selectedBackColor: '#ff000000',
                selectedColor: '#368ff3',
                onhoverColor: '#73a5ff26',
                showBorder: false,
                data: e,
            });
            $('#tree-monitor').on('nodeSelected', function (event, data) {
                // vue_right.xz_jg = data.href;
                let a = 1;
                // alert('点击选中');
            });
            $('#tree-monitor').on('nodeUnselected', function (event, data) {
                // vue_right.xz_jg = '';
                // alert('取消选择');
            });
        });
    }
});
//endregion

let as = [{
    id: 46446,
    text: 'Languages',
    children: [{
        id: 646545,
        text: 'Java'
    }, {
        id: 5634,
        text: 'C++'
    }]
}];
$("#department1").combotree({
    data: as,//获取要显示的json数据
    valueField: 'id',
    textField: 'text',
    onLoadSuccess:function(node,data){
        $("#department1").combotree('setValue',data[0].id);;
    }
});
$("#department2").combotree({
    data: as,//获取要显示的json数据
    valueField: 'id',
    textField: 'text',
});
$("#department3").combotree({
    data: as,//获取要显示的json数据
    valueField: 'id',
    textField: 'text',
});
// var t = $('#department1').combotree('tree');
// var n = t.tree('getSelected');
// alert(n.text);
