package im.dx.system.controller;

import com.github.pagehelper.PageInfo;
import im.dx.common.annotation.OperationLog;
import im.dx.common.shiro.ShiroActionProperties;
import im.dx.common.util.PageResultBean;
import im.dx.common.util.ResultBean;
import im.dx.common.util.TreeUtil;
import im.dx.system.model.*;
import im.dx.system.service.DeptTreeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

@Controller
@RequestMapping("/depttree")
public class DeptTreeController {

    @Resource
    private DeptTreeService deptTreeService;

    @Resource
    private ShiroActionProperties shiroActionProperties;
    @Value("${file.taskurl}")
    private String taskurl;

    @Autowired
    private RestTemplate restTemplate;


    @GetMapping("/index")
    public String index() {
        return "dept/dept-list";
    }

    @OperationLog("获取部门列表")
    @GetMapping("/list")
    @ResponseBody
    public ResultBean getList(@RequestParam(required = false) String parentId) {
        List<DeptTree> deptList = deptTreeService.selectByParentId(parentId);
        return ResultBean.success(deptList);
    }

    @GetMapping("/tree/root")
    @ResponseBody
    public ResultBean treeAndRoot() {
        return ResultBean.success(deptTreeService.selectAllDeptTreeAndRoot());
    }

    @GetMapping("/tree")
    @ResponseBody
    public ResultBean tree() {
        return ResultBean.success( TreeUtil.toTree(deptTreeService.selectAllDeptTree("0"),"deptId","parentId","children",DeptTree.class,"0"));
    }
    @GetMapping("/alltree")
    @ResponseBody
    public ResultBean alltree() {
        return ResultBean.success( deptTreeService.selectAllDeptTree("0"));
    }

    @GetMapping("/videotree/{deptId}")
    @ResponseBody
    public ResultBean videotree(@PathVariable("deptId") String deptId) {
        List<DeptTree> dept= deptTreeService.selectAllVideoTree("0");
        return ResultBean.success(TreeUtil.toTree(dept,"deptId","parentId","children",DeptTree.class,"0"));
    }



    @GetMapping
    public String add() {
        return "dept/dept-add";
    }

//    @OperationLog("新增部门")
//    @PostMapping
//    @ResponseBody
//    public ResultBean add(DeptTree dept) {
//        if(null==dept.getDeptId() ||dept.getDeptId().equals(""))
//        {
//            dept.setDeptId(deptTreeService.selectMaxOrderNum()+1);
//        }
//        dept.setCreateTime(sdf.format(new Date()));
//        dept.setModifyTime(dept.getCreateTime());
//        return ResultBean.success(deptTreeService.insert(dept));
//    }

    @OperationLog("删除部门")
    @DeleteMapping("/{deptId}")
    @ResponseBody
    public ResultBean delete(@PathVariable("deptId") String deptId) {
        deptTreeService.deleteCascadeByID(deptId);
        return ResultBean.success();
    }

    @OperationLog("修改部门")
    @PutMapping
    @ResponseBody
    public ResultBean update(DeptTree dept) {
        dept.setModifyTime(dept.getCreateTime());
        deptTreeService.updateByPrimaryKey(dept);
        return ResultBean.success();
    }

    @GetMapping("/{deptId}")
    public String update(@PathVariable("deptId") String taskno, Model model) {
        DeptTree dept = deptTreeService.selectByPrimaryKey(taskno);
        model.addAttribute("dept", dept);
        return "dept/dept-add";
    }

    @OperationLog("调整部门排序")
    @PostMapping("/swap")
    @ResponseBody
    public ResultBean swapSort(Integer currentId, Integer swapId) {
        deptTreeService.swapSort(currentId, swapId);
        return ResultBean.success();
    }

    @OperationLog("获取部门列表")
    @GetMapping("/listByUsername")
    @ResponseBody
    public ResultBean listByUsername(@RequestParam(required = false) String parentId,String username) {
        if (null!=username && shiroActionProperties.getSuperAdminUsername().equals(username)) {
            parentId = "0";
        }
        List<DeptTree> deptList = deptTreeService.selectAllDeptTree(parentId);
        return ResultBean.success(deptList);
    }

    @OperationLog("获取角色所管辖事件监控")
    @GetMapping("/listeventByvideoid/{userID}")
    @ResponseBody
    public ResultBean listeventByvideoid(@PathVariable("userID") String userID) {

       String[] eventids = deptTreeService.listeventByvideoid(userID);
        return ResultBean.success(eventids);
    }

    @OperationLog("获取监控控制的事件")
    @GetMapping("/recordtype/list")
    @ResponseBody
    public PageResultBean<Map> getrecordtypeList(@RequestParam(required = false) String parentId,
                                        @RequestParam(required = false) int page,
                                        @RequestParam(required = false) int limit
                                        ) {
        List<Map> menuList =
                deptTreeService.selectVideoeRecordType(parentId, page, limit);

        PageInfo<Map> rolePageInfo = new PageInfo<>(menuList);
        return new PageResultBean<>(rolePageInfo.getTotal(), rolePageInfo.getList());
    }
    @OperationLog("删除监控控制的事件")
    @GetMapping("/delvideorecord/{taskno}/{status}")
    @ResponseBody
    public TaskResultObj delvideorecord(@PathVariable("taskno") String taskno,@PathVariable("status") String status) {
        //调用任务删除的第三方接口
        JobParam  jobParam=new JobParam();
        if(taskno.split("_").length>1)
        jobParam.setDetectType(taskno.split("_")[2]);
        jobParam.setType(status);
        jobParam.setDeviceId(taskno.split("_")[1]);
        //调用第三方接口直接删除
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity<JobParam> requestEntity = new HttpEntity<>(jobParam, headers);
        return  restTemplate.postForObject(taskurl, requestEntity, TaskResultObj.class);
    }



}
