package im.dx.system.service;

import com.github.pagehelper.PageHelper;
import im.dx.system.mapper.VideoMapper;
import im.dx.system.model.Sbtdspsr;
import im.dx.system.model.Video;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

@Service
public class VideoService {

    @Resource
    private VideoMapper videoMapper;

    /**
     * 根据父 ID 获取所有部门下的监控信息
     */
    public List<Video> selectByMutiParam(int page, int  rows,String deptId,String videoName) {
        PageHelper.startPage(page, rows);
        return videoMapper.selectByMutiParam(deptId,videoName);
    }

    @Transactional
    public Integer add(Sbtdspsr video) {
        return videoMapper.insert(video);
    }


    @Transactional
    public void delete(String  id) {
        videoMapper.delete(id);
    }


    public void update(Sbtdspsr video) {
        videoMapper.updateByPrimaryKey(video);
    }
    public void updateImgSrc(String  imgsrc,String sbbh) {
        videoMapper.updateImgSrc(imgsrc,sbbh);
    }


    public  int  taskExists(String taskno){
       return  videoMapper.taskExists(taskno);
    }
    public  int  taskAutoSnapExists(String taskno){
       return  videoMapper.taskAutoSnapExists(taskno);
    }
}