package im.dx.system.controller;

import com.github.pagehelper.PageInfo;
import im.dx.common.annotation.OperationLog;
import im.dx.common.util.DateUtils;
import im.dx.common.util.JsonUtil;
import im.dx.common.util.PageResultBean;
import im.dx.common.util.ResultBean;
import im.dx.system.model.*;
import im.dx.system.service.AlgorithmPreprocessService;
import im.dx.system.service.AutoSnapService;
import im.dx.system.service.CutpictureService;
import im.dx.system.service.VideoService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@Controller
@RequestMapping("/video")
public class VideoController {
    private static final Logger log = LoggerFactory.getLogger(VideoController.class);
    @Resource
    private VideoService videoService;
    @Autowired
    public RestTemplate restTemplate;
    @Autowired
    private AutoSnapService autoSnapService;


    @Value("${file.rtspurl}")
    private String rtspurl;
    @Value("${file.taskurl}")
    private String addtaskurl;
    @Value("${dixanxinAIurl}")
    private String dixanxinAIurl;




    @Resource
    private CutpictureService cutpictureService;
    @Resource
    AlgorithmPreprocessService  algorithmPreprocessService;

    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");


    @OperationLog("deptIdȡûб")
    @GetMapping("/list")
    @ResponseBody
    public PageResultBean<Video> getList(@RequestParam(value = "page", defaultValue = "1") int page,
                                         @RequestParam(value = "pageSize", defaultValue = "10") int pageSize,
                                         @RequestParam(value = "deptId") String deptId,
                                         @RequestParam(value = "videoName") String videoName) {

        List<Video> videos = videoService.selectByMutiParam(page, pageSize, deptId, videoName);
        PageInfo<Video> userPageInfo = new PageInfo<>(videos);
        return new PageResultBean<>(userPageInfo.getTotal(), userPageInfo.getList());

    }


    @OperationLog("")
    @PostMapping("/add")
    @ResponseBody
    public ResultBean add(Sbtdspsr video) {
        video.setCjrq(sdf.format(new Date()));
        video.setXgrq(video.getCjrq());
        return ResultBean.success(videoService.add(video));
    }

    @OperationLog("ɾ")
    @GetMapping("/delete/{Id}")
    @ResponseBody
    public ResultBean delete(@PathVariable("Id") String id) {
        videoService.delete(id);
        return ResultBean.success();
    }


    @OperationLog("֡")
    @PostMapping("/getSnapshot")
    @ResponseBody
    public ResultObj getSnapshot(@RequestBody String videoid) {
        //rtsp  ͼƬַ
        videoid = videoid.replace("\"", "");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        Map<String, Object> maps = new HashMap<>();
        maps.put("deviceCode", videoid);
        Map result = restTemplate.getForObject(rtspurl + "?deviceCode={deviceCode}", Map.class, maps);
        if (null != result) {
            if (null != result.get("ret") && String.valueOf(result.get("ret")).equals("0")
                    && result.get("desc").toString().contains("succ")) {
                //ͼƬַ
                return ResultObj.ok(result.get("url").toString());
            }

        }
        return ResultObj.error(999, "ʱ");
    }

    @OperationLog("")
    @PostMapping("/task")
    @ResponseBody
    public TaskResultObj scheduleJob(@RequestBody JobParam jobParam) {
        //type  жɾֹͣʼ
        //0 1 2ֹͣ 3ɾ
        if (jobParam.getType().equals("0")) {
            //taskno жǷ
            String taskno="fx_" + jobParam.getDeviceId() + "_" + jobParam.getDetectType();
            if(null!=jobParam.getParams().get("taskno")) {
                taskno = jobParam.getParams().get("taskno").toString();
            }
            int fxtasknum = videoService.taskExists(taskno);
            if (fxtasknum > 0) {
                return TaskResultObj.error("-2", "Ѿ");
            }
        }
        //õӿ
        List<Point> points = new ArrayList<>();
        Point point = jobParam.getArea() != null ? jobParam.getArea().size() > 0 ? jobParam.getArea().get(0) : null : null;
        if (null != point) {
            points.add(
                    new Point(point.getX(), point.getY())
            );
            points.add(
                    new Point(point.getX(), point.getY() + point.getH())
            );
            points.add(
                    new Point(point.getX() + point.getW(), point.getY())
            );
            points.add(
                    new Point(point.getX() + point.getW(), point.getY() + point.getH())
            );

        }
        jobParam.setArea(points);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity<JobParam> requestEntity = new HttpEntity<>(jobParam, headers);
        try {
            return CompletableFuture.supplyAsync(() -> restTemplate.postForObject(addtaskurl, requestEntity, TaskResultObj.class)).get(500, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException ex){
            log.error("error:{}",ex.toString());
            return TaskResultObj.error("-1","ʱ");
        } catch (InterruptedException e) {
            log.error("error:{}",e.toString());
            return TaskResultObj.error("-1","жϣ");
        } catch (ExecutionException e) {
            log.error("error:{}",e.toString());
            return TaskResultObj.error("-1","ʧܣ");
        }
    }


    @OperationLog("ʶ")
    @PostMapping("/LJTtask")
    @ResponseBody
    public TaskResultObj LJTtask(@RequestBody JobLJTParam jobParam) {
        if (jobParam.getParams() != null) {//ĸ
            if(null!=jobParam.getParams().get("region") ) {
                Map pointmap=(Map) jobParam.getParams().get("region");
                try {
                    Point point = JsonUtil.strToObj(JsonUtil.objToStr(pointmap), Point.class);
                    //õ
                    Integer[][] arrresult = {{point.getX(),
                            point.getY() + point.getH()},
                            {point.getX(), point.getY()},
                            {point.getX() + point.getW(),
                                    point.getY()}, {point.getX() + point.getW(),
                            point.getY() + point.getH()}};
                    //
                    jobParam.getParams().put("region", point.getX()+","+point.getY()+","+point.getW()+","+ point.getH()
                    );
                    //
                    //õ㷨ؽɹ
                    Map mapresult = cutpictureService.CreateTaskLJTMYJC(jobParam.getDeviceNum(), jobParam.getInterval(), arrresult);
                    log.info(JsonUtil.objToStr(mapresult));
                    if (null!=mapresult && null!= mapresult.get("errorCode")&& mapresult.get("errorCode").toString().equals("0")) {
                        //½ɹ{"errorCode":"0","errorMsg":"ɹ","data":{"taskId":"da7fa7b502014547b1bdced4ea5bc8629344"}}
                       Map result=(Map) mapresult.get("data");
                       if(null!=result.get("taskId")){
                           //ʼʱʱ
                           jobParam.getParams().put("taskId",result.get("taskId").toString());
                           algorithmPreprocessService.add(jobParam);

                       }
                    } else {
                        log.error("ʶ :error:{}", mapresult.get("errorMsg"));
                        return TaskResultObj.error("-1",mapresult.get("errorMsg").toString());
                    }
                }catch (Exception ex){

                    log.error("ʶ :error:{}", ex.toString());
                    return   TaskResultObj.error("-1","쳣");
                }

            }

        }
        return TaskResultObj.ok();
    }


    @OperationLog("ֹͣ")
    @PostMapping("/taskmange")
    @ResponseBody
    public TaskResultObj taskstop(@RequestBody JobLJTParam  jobParam) {
        //õֹͣ
        try {
            if(jobParam.getStatus()==2 && null!=jobParam.getParams().get("taskId")) {//1:½2:ͣ3:4:ɾ
               Map  result= cutpictureService.StopTask(jobParam.getDeviceNum(), jobParam.getParams().get("taskId").toString());
                if (null != result.get("errorCode") &&result.get("errorCode").toString().equals("0")) {
                    algorithmPreprocessService.update(jobParam);
                } else {
                    log.error("HTTP {}", result.get("errorCode"), result.get("errorMsg"));
                    return TaskResultObj.error("-1",result.get("errorMsg").toString());
                }
            }
            else if(jobParam.getStatus()==3 && null!=jobParam.getParams().get("taskId")) {
                Map  result=   cutpictureService.StartTask(jobParam.getDeviceNum(), jobParam.getParams().get("taskId").toString());
                if (null != result.get("errorCode") &&result.get("errorCode").toString().equals("0")) {
                    algorithmPreprocessService.update(jobParam);
                } else {
                    log.error("HTTP {}", result.get("errorCode"), result.get("errorMsg"));
                    return TaskResultObj.error("-1",result.get("errorMsg").toString());
                }
            }
            else if(jobParam.getStatus()==4 && null!=jobParam.getParams().get("taskId")) {
                Map  result=   cutpictureService.DeleteTask(jobParam.getDeviceNum(), jobParam.getParams().get("taskId").toString());
               //ɾ¼
                if (null != result.get("errorCode") &&result.get("errorCode").toString().equals("0")) {
                    algorithmPreprocessService.delete(jobParam);
                }
                else {
                    log.error("HTTP {}", result.get("errorCode"), result.get("errorMsg"));
                    return TaskResultObj.error("-1",result.get("errorMsg").toString());
                }
            }

        }catch (Exception ex){
            log.error("ʧܣ{}",ex);
            return TaskResultObj.error("-1","error");
        }
        return TaskResultObj.ok();
}

    @OperationLog("༭")
    @PostMapping("/edit")
    @ResponseBody
    public ResultBean edit(Sbtdspsr video) {
        video.setXgrq(video.getCjrq());
        try {
            videoService.update(video);
        }catch (Exception ex){
            return ResultBean.error("error");
        }
        return ResultBean.success();
    }


    @OperationLog("Զץ")
    @PostMapping("/autoSnapTask")
    @ResponseBody
    public TaskResultObj autoSnapTask(@RequestBody JobParam jobParam) {
        //0 1 2ֹͣ 3ɾ
        String taskno = jobParam.getDeviceId() + "_" + jobParam.getDetectType();
        if (jobParam.getType().equals("0")) {
            //taskno жǷ
            if (null != jobParam.getParams().get("taskno")) {
                taskno = jobParam.getParams().get("taskno").toString();
            }
            int fxtasknum = autoSnapService.taskAutoSnapExists(taskno);
            if (fxtasknum > 0) {
                return TaskResultObj.error("-2", "Ѿ");
            }
        }
        //
        Autosnaptaskinfo autosnaptaskinfo=new Autosnaptaskinfo();
        autosnaptaskinfo.setAlgorithmfrom("1");
        autosnaptaskinfo.setDevicenum(jobParam.getDeviceId());
        autosnaptaskinfo.setSendurl(jobParam.getCallBackUrl());
        autosnaptaskinfo.setStarthour(jobParam.getParams().get("starthour")==null?"0":jobParam.getParams().get("starthour").toString());
        autosnaptaskinfo.setEndhour(jobParam.getParams().get("endhour")==null?"0":jobParam.getParams().get("endhour").toString());
        autosnaptaskinfo.setObjectType(jobParam.getParams().get("objectType")==null?"0":jobParam.getParams().get("objectType").toString());
        autosnaptaskinfo.setStatus("1");
        autosnaptaskinfo.setRecordtype(jobParam.getDetectType());
        autosnaptaskinfo.setSendtype(jobParam.getParams().get("sendType")==null?"1":jobParam.getParams().get("sendType").toString());
       if(null!=jobParam.getArea() && jobParam.getArea().size()>0) {
           Point point= jobParam.getArea().get(0);
           autosnaptaskinfo.setRegionx(Integer.toString(point.getX()));
           autosnaptaskinfo.setRegiony(Integer.toString(point.getY()));
           autosnaptaskinfo.setRegionw(Integer.toString(point.getW()));
           autosnaptaskinfo.setRegionh(Integer.toString(point.getH()));
       }
        autosnaptaskinfo.setSpId(jobParam.getDeviceId());
        autosnaptaskinfo.setTaskid(taskno);
        autosnaptaskinfo.setTaskname(jobParam.getName());
        autosnaptaskinfo.setThreshold(jobParam.getParams().get("thresholdValue")==null?"0":jobParam.getParams().get("thresholdValue").toString());
        autosnaptaskinfo.setCjrq(DateUtils.getTime());
        try {
            autoSnapService.add(autosnaptaskinfo);
        }catch (Exception ex){
            log.error(ex.toString());
            return TaskResultObj.error("-2","ʧ");
        }
        return TaskResultObj.ok();

    }

    @PostMapping("/autosnaptaskmange")
    @ResponseBody
    public TaskResultObj autosnaptaskmange(@RequestBody JobParam  jobParam) {
        //type  жɾֹͣʼ
        //0 1 2ֹͣ 3ɾ
        if(null!=jobParam.getParams() && null!=jobParam.getParams().get("taskId")) {
            String taskid = jobParam.getParams().get("taskId").toString();
            try {
                if (jobParam.getType().equalsIgnoreCase("3") && null != jobParam.getParams().get("taskId")) {
                    //ɾ
                    autoSnapService.delete(taskid);
                } else {//״̬
                    autoSnapService.update(taskid, jobParam.getType());
                }
            } catch (Exception ex) {
                log.error("ʧܣ{}", ex);
                return TaskResultObj.error("-1", "error");
            }
            return TaskResultObj.ok();
        }
        return TaskResultObj.error("-1", "Ϊ");
    }

    /***
     *һ֡ͼƬؽΪ浽
     */

    @GetMapping("/getsnap/{sbbh}")
    @ResponseBody
    public TaskResultObj getsnap(@PathVariable(value = "sbbh") String  sbbh) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        Map<String, Object> maps = new HashMap<>();
        maps.put("deviceCode", sbbh);
        try {
            Map result = restTemplate.getForObject(rtspurl + "?deviceCode={deviceCode}", Map.class, maps);
            if (null != result) {
                if (null != result.get("ret") && String.valueOf(result.get("ret")).equals("0")) {
                    videoService.updateImgSrc(result.get("url") == null ? "" : result.get("url").toString(),sbbh);
                    return TaskResultObj.ok(result.get("url") == null ? "" : result.get("url").toString());
                }

            }

        }catch (Exception ex){
            log.error(ex.toString());
        }
        return TaskResultObj.ok("");
    }


}