package im.dx.system.controller;

import com.github.pagehelper.PageInfo;
import im.dx.common.annotation.OperationLog;
import im.dx.common.util.*;
import im.dx.system.model.*;
import im.dx.system.service.TrafficStatisticsService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.tomcat.util.http.fileupload.IOUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.client.RestTemplate;
import sun.net.www.protocol.ftp.FtpURLConnection;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.List;

@Slf4j
@Controller
@RequestMapping("/TrafficStatistics")
public class TrafficStatisticsController {
    @Resource
    private TrafficStatisticsService trafficStatisticsService;



    @OperationLog("查询字典表")
    @GetMapping("/listcode")
    @ResponseBody
    public ResultBean listcode(@RequestParam("codeid") String codeid,
                               @RequestParam("alarmlevel") String level
                               ) {
        List<CodeData> deptList = trafficStatisticsService.selectCodeByCodeId(codeid, level);
        return ResultBean.success(deptList);
    }

    @PostMapping("/queryTraffalarmrecordByPage/{sendOrNot}")
    @ResponseBody
    public PageResultBean<TraffpictureParam> queryTraffalarmrecordByPage(@PathVariable("sendOrNot")String  sendOrNot,@RequestBody TraffalarmrecordParams params) {

        String[] arry = {};
        Map parammap = new HashMap();
        parammap.put("videoids", Arrays.asList("".equals(params.getVideoids())|| "null".equals(params.getVideoids()) ? arry : params.getVideoids().split(",")));
        parammap.put("starttime", params.getStarttime());
        parammap.put("endtime", params.getEndtime());
        parammap.put("recordtype", Arrays.asList(params.getRecordtype()== "" ? arry : params.getRecordtype().split(",")) );
        parammap.put("checkstatus", params.getCheckstatus());
        parammap.put("deptid", params.getDeptid());
        parammap.put("construction", params.getConstruction());
        parammap.put("objlables", Arrays.asList(params.getObjlabel() == "" ? arry : params.getObjlabel().split(",")));
        parammap.put("processstatus", Arrays.asList(params.getProcessstatus() == "" ? arry : params.getProcessstatus().split(",")));
        parammap.put("rectificationtype",params.getRectificationtype());
        parammap.put("userId",params.getUserid());
        parammap.put("pushstatus",sendOrNot);
        parammap.put("sfpf",params.getSfpf());

        List<TraffpictureParam> traffalarmrecordResults =
                trafficStatisticsService.queryTraffalarmrecordByPage(parammap, params.getPage()
                        , params.getLimit());

        PageInfo<TraffpictureParam> rolePageInfo = new PageInfo<>(traffalarmrecordResults);
        return new PageResultBean<TraffpictureParam>(rolePageInfo.getTotal(), rolePageInfo.getList());
    }

    //更新告警状态
    @PostMapping("/updateTraffalarmrecordById")
    @ResponseBody
    public ResultBean updateTraffalarmrecordById(@RequestBody List<TraffpictureParam> recrdlist) {
      //支持对某一点位某一事件类型标注正检后，该事件类型之前的MANUALCHECKTIME 重复事件类型自动标注为正检.
        int result = trafficStatisticsService.updateTraffalarmrecordById(recrdlist);
        //记录该次正检的时间
//        int result2 = trafficStatisticsService.updateVideochecktime(recrdlist);
    return ResultBean.success();
    }



    @OperationLog("查询事件本月及各分类数量")
    @GetMapping("/list/todaytraffRecords")
    @ResponseBody
    public ResultBean todaytraffRecords(@RequestParam("videoId") String videoId,
                                        @RequestParam("starttime") String starttime,
                                        @RequestParam("endtime") String endtime) {
        Map map = new HashMap();
        map.put("starttime", starttime);
        map.put("endtime", endtime);
        map.put("videoId", videoId);
        List<RecordResult> carList = trafficStatisticsService.todaytraffRecords(map);

        Date entdate = DateUtils.parseDate(endtime);
        Date startdate = DateUtils.parseDate(starttime);
        map.put("starttime", DateUtils.getlastMonthTime(startdate, -1));
        map.put("endtime", DateUtils.getlastMonthTime(startdate, -1));

        List<Map> tblist = trafficStatisticsService.todaythbtraffRecords(map);

        //上周
        map.put("starttime", DateUtils.getlastDayTime(startdate, -7));
        map.put("endtime", DateUtils.getlastDayTime(entdate, -7));
        List<Map> hblist = trafficStatisticsService.todaythbtraffRecords(map);


        for (RecordResult item : carList) {
            for (Map mp : tblist) {
                if (null != mp.get("total"))
                    item.setTbtotal(String.valueOf(mp.get("total")));
            }

            for (Map mp : hblist) {
                if (null != mp.get("total"))
                    item.setHbtotal(String.valueOf(mp.get("total")));
            }

        }


        return ResultBean.success(carList);
    }


    @OperationLog("查询历史一个月事件及各分类数量")
    @GetMapping("/list/historytraffRecords")
    @ResponseBody
    public ResultBean selecthistorytraffRecords(@RequestParam("videoId") String videoId,
                                                @RequestParam("starttime") String starttime,
                                                @RequestParam("endtime") String endtime) {
        Map map = new HashMap();
        map.put("starttime", starttime);
        map.put("videoId", videoId);
        map.put("endtime", endtime);
        List<VehiclesStatisticResult> carList = trafficStatisticsService.selecthistorytraffRecords(map);
        return ResultBean.success(carList);
    }


    @OperationLog("查询历史一个月流量及各分类数量")
    @GetMapping("/list/historyvehicles")
    @ResponseBody
    public ResultBean selecthistoryvehicles(@RequestParam("videoId") String videoId,
                                            @RequestParam("starttime") String starttime,
                                            @RequestParam("endtime") String endtime) {
        Map map = new HashMap();
        map.put("starttime", starttime);
        map.put("videoId", videoId);
        map.put("endtime", endtime);
        List<VehiclesStatisticResult> carList = trafficStatisticsService.selecthistoryvehicles(map);
        return ResultBean.success(carList);
    }


    @OperationLog("查询推送第三方的记录")
    @PostMapping("/list/pushrecordsBypage")
    @ResponseBody
    public PageResultBean<Traffalarmrecord> selectPushRecordsBypage(@RequestBody Map map) {
        List<Traffalarmrecord> carList = trafficStatisticsService.selectPushRecordsBypage(map, Integer.parseInt(map.get("page").toString()),Integer.parseInt(map.get("limit").toString()));
        PageInfo<Traffalarmrecord> rolePageInfo = new PageInfo<>(carList);
        return new PageResultBean<>(rolePageInfo.getTotal(), rolePageInfo.getList());

    }

    @OperationLog("统计事件推送结果")
    @PostMapping("/list/eventresultBypage")
    @ResponseBody
    public PageResultBean<Traffalarmrecordstate> selecteventresultBypage(@RequestBody TraffalarmrecordstatParams traffalarmrecordstatParams) {

        List<Traffalarmrecordstate> carList = trafficStatisticsService.selecteventresultBypage(traffalarmrecordstatParams);
        PageInfo<Traffalarmrecordstate> rolePageInfo = new PageInfo<>(carList);
        return new PageResultBean<>(rolePageInfo.getTotal(), rolePageInfo.getList());

    }


    @OperationLog("导出事件推送结果")
    @RequestMapping("/expTraffalarmrecordstat")
    @ResponseBody
    public void expTraffalarmrecordstat(HttpServletResponse response, TraffalarmrecordstatParams traffalarmrecordstatParams) {
        String eventname = traffalarmrecordstatParams.getEventtype();
        List<Traffalarmrecordstate> traffalarmrecordstats = trafficStatisticsService.selecteventresultBypage(traffalarmrecordstatParams);
        List<HashMap> lists = new ArrayList<>();
        for (Traffalarmrecordstate m : traffalarmrecordstats) {
            HashMap<String, Object> listMap = new HashMap<>();
            listMap.put("countdate", m.getCountdate());
            listMap.put("eventname", StringUtils.isBlank(eventname) ? "全部" : m.getEventtypename());
            listMap.put("areaname", m.getAreaname());
            listMap.put("totalcount", m.getTotalcount());
            lists.add(listMap);
        }

        ExcelCol[] cells = new ExcelCol[8];
        cells[0] = new ExcelCol();
        cells[0].setColKey("countdate");
        cells[0].setColName("日期");
        cells[1] = new ExcelCol();
        cells[1].setColKey("eventname");
        cells[1].setColName("事件类型");
        cells[2] = new ExcelCol();
        cells[2].setColKey("areaname");
        cells[2].setColName("支队名称");
        cells[3] = new ExcelCol();
        cells[3].setColKey("totalcount");
        cells[3].setColName("事件数量");
        cells[4] = new ExcelCol();
        cells[4].setColKey("checkstatusms");
        cells[4].setColName("免审");

        Map<String, Object> params = new HashMap<>(4);
        SimpleDateFormat formart = new SimpleDateFormat("yyyy-MM-dd");
        String dateTime = formart.format(new Date());
        params.put("fileName", "推送统计-" + dateTime);
        params.put("sheetName", "推送统计");
        params.put("header", "推送统计");
        new ExportEngine().exportCommData(params, cells, lists, response);

    }

    //删除某一事件
    @OperationLog("取消推送事件信息")
    @GetMapping("/deleteTraffalarmrecordById/{recordid}")
    @ResponseBody
    public ResultBean deleteTraffalarmrecordById(@PathVariable("recordid") String recordid) {
        return ResultBean.success(trafficStatisticsService.deleteTraffalarmrecordById(recordid));
    }


    @OperationLog("查询事件详情")
    @GetMapping("/queryTraffDetail/{id}/{recordtype}")
    @ResponseBody
    public ResultBean queryTraffDetail(@PathVariable("id") String id,@PathVariable("recordtype") String recordtype) {
        if("1".equals(recordtype)){
          List<Pedestrian>  results= trafficStatisticsService.queryTraffPedeDetail(id);
            return ResultBean.success(results);
        }
       else  if("2".equals(recordtype)){//车辆
            List<Traffic>  results= trafficStatisticsService.queryTrafficDetail(id);
            return ResultBean.success(results);
        }
        else  if("3".equals(recordtype)){//人脸
            List<Face>  results= trafficStatisticsService.queryTraffFaceDetail(id);
            return ResultBean.success(results);
        }
        else  if("4".equals(recordtype)){//人骑车
            List<PeopleRideBicyc>  results= trafficStatisticsService.queryTraffPeopleRideBicycDetail(id);
            return ResultBean.success(results);
        }
        return ResultBean.success();

    }
    @PostMapping("/delTraffalarmrecordByIds")
    @ResponseBody
    public ResultBean delTraffalarmrecordByIds(@RequestBody List<TraffpictureParam> recrdlist) {
        try {
            trafficStatisticsService.deltaskinfoByIds(recrdlist);
            //删除告警信息
            int result = trafficStatisticsService.delTraffalarmrecordByIds(recrdlist);
        }catch (Exception ex) {
            return ResultBean.error("-1");
        }

       return ResultBean.success();
    }
    @PostMapping("/deltaskinfoByIds")
    @ResponseBody
    public ResultBean deltaskinfoByIds(@RequestBody List<TraffpictureParam> recrdlist) {
        //支持对某一点位某一事件类型标注正检后，该事件类型之前的MANUALCHECKTIME 重复事件类型自动标注为正检.
        int result = trafficStatisticsService.deltaskinfoByIds(recrdlist);
        return ResultBean.success();
    }


    @PostMapping("/queryTaskInfoByPage")
    @ResponseBody
    public PageResultBean<TraffpictureParam> queryTaskInfoByPage(@RequestBody TraffalarmrecordParams params) {

        String[] arry = {};
        Map parammap = new HashMap();
        parammap.put("videoids", Arrays.asList("".equals(params.getVideoids())|| "null".equals(params.getVideoids()) ? arry : params.getVideoids().split(",")));
        parammap.put("starttime", params.getStarttime());
        parammap.put("endtime", params.getEndtime());
        parammap.put("recordtype", Arrays.asList(params.getRecordtype()== "" ? arry : params.getRecordtype().split(",")) );
        parammap.put("checkstatus", params.getCheckstatus());
        parammap.put("deptid", params.getDeptid());
        parammap.put("construction", params.getConstruction());
        parammap.put("objlables", Arrays.asList(params.getObjlabel() == "" ? arry : params.getObjlabel().split(",")));
        parammap.put("processstatus", Arrays.asList(params.getProcessstatus() == "" ? arry : params.getProcessstatus().split(",")));
        parammap.put("rectificationtype",params.getRectificationtype());
        parammap.put("userId",params.getUserid());
        parammap.put("sfpf",params.getSfpf());
        List<TraffpictureParam> traffalarmrecordResults =
                trafficStatisticsService.queryTaskInfoByPage(parammap, params.getPage()
                        , params.getLimit());

        PageInfo<TraffpictureParam> rolePageInfo = new PageInfo<>(traffalarmrecordResults);
        return new PageResultBean<TraffpictureParam>(rolePageInfo.getTotal(), rolePageInfo.getList());
    }





}
