package im.dx.common.config;

import im.dx.system.model.JobLJTParam;
import im.dx.system.service.AlgorithmPreprocessService;
import im.dx.system.service.CutpictureService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.Map;


@Configuration
@EnableScheduling
public class ScheduleTaskConfig {
    private static final Logger log = LoggerFactory.getLogger(ScheduleTaskConfig.class);
    @Autowired
    private AlgorithmPreprocessService algorithmpreProcessService;

    @Resource
    private CutpictureService cutpictureService;
    /***
     * 从三点开始每小时执行一遍，查看表里是否有需要启动或者停止的任务
     * 该功能只针对调用垃圾桶溢出等算法任务
     */
    @Scheduled(cron = "0 0 * * * ?")
    private void startOrStopAlgorithmTask() {
        //查询表中需要开启的数据
        List<JobLJTParam> jobLJTResultList= algorithmpreProcessService.querytask(5,1);
        //停止任务
        for(JobLJTParam jobParam:jobLJTResultList)
        {
            //调用开启任务的服务
            Map  result=cutpictureService.StartTask(jobParam.getDeviceNum(), jobParam.getParams().get("taskId").toString());
            if (null != result.get("errorCode") &&result.get("errorCode").toString().equals("0")) {
                jobParam.setStatus(3);
                algorithmpreProcessService.update(jobParam);
            } else {
                log.error("StartTask error {}", result.get("errorCode"), result.get("errorMsg"));
            }
        }
        //查询表中需要停止的数据
        List<JobLJTParam> jobLJTStopResultList= algorithmpreProcessService.querytask(new Date().getHours(),0);

        for(JobLJTParam jobParam:jobLJTStopResultList) {
            //停止任务
            Map result = cutpictureService.StopTask(jobParam.getDeviceNum(), jobParam.getParams().get("taskId").toString());
            if (null != result.get("errorCode") && result.get("errorCode").toString().equals("0")) {
                jobParam.setStatus(2);
                algorithmpreProcessService.update(jobParam);
            } else {
                log.error("StopTask error {}", result.get("errorCode"), result.get("errorMsg"));
            }
        }

    }

}
