package im.dx.system.mapper;

import im.dx.system.model.*;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

@Mapper
public interface TrafficStatisticsMapper {

    Role selectByPrimaryKey(@Param("roleId") Integer roleId);

    int updateByPrimaryKey(Role role);

    List<Role> selectAll();


    int count();

    List<CodeData> selectCodeByCodeid(@Param("codeid") String codeid, @Param("level") String level);


    List<TraffpictureParam> queryTraffalarmrecordByPage(Map map);

    int updateTraffalarmrecordById(@Param(value = "list") List<TraffpictureParam> recordlist);



    List<RecordResult> todaytraffRecords(Map map);

    public List<Map> todaythbtraffRecords(Map map);

    List<VehiclesStatisticResult> selecthistorytraffRecords(Map map);

    List<VehiclesStatisticResult> selecthistoryvehicles(Map map);

    List<Traffalarmrecord> selectPushRecordsBypage(Map map);

    List<Traffalarmrecordstate> selecteventresultBypage(TraffalarmrecordstatParams params);


    int  deleteTraffalarmrecordById(String recordid);

    int  updateTraffalarmrecordPushStatusById(String recordid);

    List<Pedestrian> queryTraffPedeDetail(String id);

    List<Traffic> queryTrafficDetail(String id);

    List<Face> queryTraffFaceDetail(String id);

    List<PeopleRideBicyc> queryTraffPeopleRideBicycDetail(String id);

    int delTraffalarmrecordByIds(@Param(value = "list") List<TraffpictureParam> recordlist);
    int deltaskinfoByIds(@Param(value = "list") List<TraffpictureParam> recordlist);
}