//region 默认首页监控
let vue_sjcx1 = new Vue({
    el: '#symrcxjk',
    data: {
        searchText: '',
        data_table_monitor: [],
        deptId: '',
        bmmc: '',
    },
    methods: {
        query: function () {
            $.ajax({
                url: "/dept/getDeptParent/" + vue_sjcx1.deptId,
                dataType: "json",
                type: "GET",
                data: {},
                success: function (result) {
                    if (result.code == 0) {
                        let deptId = result.data[0].deptId;
                        let parIds = result.data[0].parentId;
                        let username = '';
                        if (deptId == '-1') {
                            username = 'admin';
                        } else {
                            username = '';
                        }
                        $.ajax({
                            url: "/dept/listvideo",
                            dataType: "json",
                            type: "GET",
                            data: {
                                deptId: deptId,
                                username: username,
                                tdmc:'',
                            },
                            success: function (result) {
                                let defaultData = [];
                                if (result.code == 0) {
                                    let monitor = result.data;
                                    $.ajax({
                                        url: "/dept/queryDefaultVideoId",
                                        dataType: "json",
                                        type: "GET",
                                        data: {
                                            deptId: vue_sjcx1.deptId,
                                        },
                                        success: function (result) {
                                            vue_sjcx1.data_table_monitor = [];
                                            if (result.code == 0) {
                                                if (result.data.length > 0) {
                                                    vue_sjcx1.data_table_monitor = result.data;
                                                }
                                            }
                                        }
                                    });

                                }
                            }
                        });
                    }
                }
            });
        },
        del: function (item) {
            if (!confirm("确认删除此部门默认监控吗？")) {
                return;
            }
            $.ajax({
                url: "/dept/updateDefaultVideo",
                dataType: "json",
                type: "POST",
                data: {
                    deptId: vue_sjcx1.deptId,
                    videoId: item.videoid,
                },
                success: function (result) {
                    if (result.code == 0) {
                        info_new("首页默认监控删除成功");
                        window.setTimeout("$('#info-warning-new').modal('hide')", 2000);
                        vue_sjcx1.query();
                    }
                }
            });
        },
        add_monitor: function () {
            if (vue_sjcx1.deptId == "") {
                info_new("未选择部门,左侧请选择部门");
                window.setTimeout("$('#info-warning-new').modal('hide')", 2000);
                $("#myModal").css('overflow', 'auto');
            } else {
                vue_jk.monitor_data = {};
                vue_jk.bmmc = vue_sjcx1.bmmc;
                vue_jk.query_monitor(vue_sjcx1.deptId);
                $("#myModal2").modal("show");
            }
        },
        fastSearch: function () {
            $("#tree-monitor").treeview('search', [this.searchText, {
                ignoreCase: true,      // case insensitive
                exactMatch: false,     // like or equals
                revealResults: true,   // reveal matching nodes
            }]);
        },
    },
    mounted(){
        $.ajax({
            url: "/dept/listvideo",
            dataType: "json",
            type: "GET",
            data: {
                deptId: '-1',
                username: 'admin',
                tdmc:'',
            },
            success: function (result) {
                let defaultData = [];
                if (result.code == 0) {
                    defaultData = toTree1(result.data, 0 + '');
                    $('#tree-monitor').treeview({
                        expandIcon: 'glyphicon glyphicon-triangle-right selected-span',
                        collapseIcon: 'glyphicon glyphicon-triangle-bottom selected-span',
                        nodeIcon: 'glyphicon glyphicon-folder-open selected-span',
                        selectedBackColor: '#ff000000',
                        selectedColor: '#368ff3',
                        onhoverColor: '#73a5ff26',
                        showBorder: false,
                        data: defaultData,
                    });
                    $('#tree-monitor').on('nodeSelected', function (event, data) {
                        vue_sjcx1.deptId = data.href;
                        vue_sjcx1.bmmc = data.text;
                        vue_sjcx1.query();
                        // alert('点击选中');
                    });
                    $('#tree-monitor').on('nodeUnselected', function (event, data) {
                        vue_sjcx1.deptId = '';
                        vue_sjcx1.bmmc = '';
                        // alert('取消选择');
                    });
                }
            }
        });
    }
});
//endregion
let vue_jk = new Vue({
    el: '#myModal2',
    data: {
        monitor_data: {},
        searchText: '',
        bmmc: '',
    },
    methods: {
        fastSearch: function () {
            $("#tree-xzxq").treeview('search', [this.searchText, {
                ignoreCase: true,      // case insensitive
                exactMatch: false,     // like or equals
                revealResults: true,   // reveal matching nodes
            }]);
        },
        define: function () {
            let nodes = $('#tree-xzxq').treeview('getChecked').filter(n=>n.level == null).map(n=> {
                return n.href
            });
            if (nodes.length == 0) {
                info_new("未选择监控");
                window.setTimeout("$('#info-warning-new').modal('hide')", 2000);
                $("#myModal").css('overflow', 'auto');
            } else {
                $.ajax({
                    url: "/dept/insertDefaultVideo",
                    dataType: "json",
                    type: "POST",
                    data: {
                        deptId: vue_sjcx1.deptId,
                        videoId: nodes,
                    },
                    success: function (result) {
                        if (result.code == 0) {
                            info_new("首页默认监控添加成功");
                            window.setTimeout("$('#info-warning-new').modal('hide')", 2000);
                            $("#myModal2").modal("hide");
                        }
                    }
                });
            }
        },
        query_monitor: function (deptIDs) {
            $.ajax({
                url: "/dept/getDeptParent/" + deptIDs,
                dataType: "json",
                type: "GET",
                data: {},
                success: function (result) {
                    if (result.code == 0) {
                        let deptId = result.data[0].deptId;
                        let parIds = result.data[0].parentId;
                        let username = '';
                        if (deptId == '-1') {
                            username = 'admin';
                        } else {
                            username = '';
                        }
                        $.ajax({
                            url: "/dept/listvideo",
                            dataType: "json",
                            type: "GET",
                            data: {
                                deptId: deptId,
                                username: username,
                                tdmc:'',
                            },
                            success: function (result) {
                                let defaultData = [];
                                if (result.code == 0) {
                                    let monitor = result.data;
                                    $.ajax({
                                        url: "/dept/queryDefaultVideoId",
                                        dataType: "json",
                                        type: "GET",
                                        data: {
                                            deptId: deptIDs,
                                        },
                                        success: function (result) {
                                            let nodes_id = [];
                                            if (result.code == 0) {
                                                if (result.data.length > 0) {
                                                    nodes_id = result.data;
                                                } else {
                                                    nodes_id = [{videoid: ''}];
                                                }
                                            }
                                            defaultData = toTree(monitor, deptId + '', nodes_id);
                                            $('#tree-xzxq').treeview({
                                                expandIcon: 'glyphicon glyphicon-triangle-right selected-span',
                                                collapseIcon: 'glyphicon glyphicon-triangle-bottom selected-span',
                                                nodeIcon: 'glyphicon glyphicon-folder-open selected-span',
                                                selectedBackColor: '#ff000000',
                                                selectedColor: '#368ff3',
                                                onhoverColor: '#73a5ff26',
                                                showBorder: false,
                                                data: defaultData,
                                                multiSelect: false,
                                                level: 2,
                                                showCheckbox: 1,//复选框设置，也可以是true
                                                onNodeChecked: function (event, node) { //选中节点
                                                    let selectNodes = getChildNodeIdArr(node); //获取所有子节点
                                                    if (selectNodes) { //子节点不为空，则选中所有子节点
                                                        $(this).treeview('checkNode', [selectNodes, {silent: true}]);
                                                    }
                                                    //如果当前节点的子节点都被选中了。则父节点也应该要选中
                                                    setParentNodeCheck(node);
                                                }, onNodeUnchecked: function (event, node) { //取消选中节点
                                                    let selectNodes = getChildNodeIdArr(node); //获取所有子节点
                                                    if (selectNodes) { //子节点不为空，则取消选中所有子节点
                                                        $(this).treeview('uncheckNode', [selectNodes, {silent: true}]);
                                                    }
                                                }, onNodeExpanded: function (event, data) {

                                                }, onNodeSelected: function (event, node) {

                                                }
                                            });
                                        }
                                    });

                                }
                            }
                        });
                    }
                }
            });
        }
    },
    mounted(){
    }
});

function toTree(list, parId, nodes_id) {
    let len = list.length;

    function loop(parId) {
        let res = [];
        for (let i = 0; i < len; i++) {
            let item = list[i];
            if (item.parentId === parId) {
                item.nodes = loop(item.href);
                let arr = {
                    href: item.href,
                    text: item.text,
                    level: item.level,
                    parentId: item.parentId,
                }
                if (item.level == 0 || item.level == 1 || item.level == 2) {
                    arr.selectable = false;
                    arr.state = {expanded: true};
                } else {
                    arr.icon = 'glyphicon glyphicon-facetime-video zx';
                    let is_true = false;
                    nodes_id.forEach((items, index)=> {
                        if (items.videoid == item.href) {
                            is_true = true;
                        }
                    });
                    if (is_true) {
                        arr.state = {
                            // expanded: false,
                            checked: true,
                            disabled: true,
                        };
                    } else {
                        arr.state = {
                            // expanded: false,
                            // checked: true,
                        };
                    }
                    arr.selectable = true;
                }
                if (item.nodes.length > 0) {
                    arr.nodes = item.nodes;
                }
                res.push(arr);
            }
        }
        return res
    }

    return loop(parId)
}

function toTree1(list, parId) {
    let len = list.length;

    function loop1(parId) {
        let res = [];
        for (let i = 0; i < len; i++) {
            let item = list[i];
            if (item.parentId === parId) {
                if (item.level != null) {
                    item.nodes = loop1(item.href);
                    let arr = {
                        href: item.href,
                        text: item.text,
                        level: item.level,
                        parentId: item.parentId,
                    }
                    if (item.level == 0 || item.level == 1) {
                        if (item.nodes.length > 0) {
                            arr.nodes = item.nodes;
                            arr.state = {expanded: true};
                        }
                    } else {

                        arr.selectable = true;
                    }
                    res.push(arr);
                }
            }
        }
        return res
    }

    return loop1(parId)
}

//获取选中的id
function getChildNodeIdArr(node) {
    let ts = [];
    if (node.nodes) {
        for (let x in node.nodes) {
            ts.push(node.nodes[x].nodeId);
            if (node.nodes[x].nodes) {
                let getNodeDieDai = getChildNodeIdArr(node.nodes[x]);
                for (let j in getNodeDieDai) {
                    ts.push(getNodeDieDai[j]);
                }
            }
        }
    } else {
        ts.push(node.nodeId);
    }
    return ts;
}

//设置父节点
function setParentNodeCheck(node) {
    let parentNode = $("#tree-xzxq").treeview("getNode", node.parentId);
    if (parentNode.nodes) {
        let checkedCount = 0;
        for (let x in parentNode.nodes) {
            if (parentNode.nodes[x].state.checked) {
                checkedCount++;
            } else {
                break;
            }
        }
        if (checkedCount === parentNode.nodes.length) {
            $("#tree-xzxq").treeview("checkNode", parentNode.nodeId);
            setParentNodeCheck(parentNode);
        }
    }
};