let sjtj_Chart, gysjtj_Chart,myChart,gdf_Chart,gwph_Chart;

var right_vue=new Vue({
    el:"#rightid",
    data:{

    },methods:{

    },mounted(){
        setInterval(function () {
            let myDate = new Date;
            let year = myDate.getFullYear(); //获取当前年
            let mon = myDate.getMonth() + 1; //获取当前月
            let date = myDate.getDate(); //获取当前日
            let h = myDate.getHours();//获取当前小时数(0-23)
            let m = myDate.getMinutes();//获取当前分钟数(0-59)
            let s = myDate.getSeconds();//获取当前秒
            let week = myDate.getDay();
            let weeks = ["星期日", "星期一", "星期二", "星期三", "星期四", "星期五", "星期六"];
            $("#time").html(year + "年" + mon + "月" + date + "日" +h+"："+m+":"+s+ weeks[week]);
        },1000);
        sjtj_Chart = echarts.init(document.getElementById('sjtjid'));
        option_sjtj = {
            tooltip: {
                trigger: 'axis',
                axisPointer: {            // 坐标轴指示器，坐标轴触发有效
                    type: 'shadow'        // 默认为直线，可选为：'line' | 'shadow'
                }
            },
            legend:{
                show:false
            },
            grid: {
                left: '3%',
                right: '4%',
                bottom: '3%',
                top:'0%',
                containLabel: true
            },
            xAxis: {
                type: 'value',
                show:false,
                inverse: true,
            },
            yAxis: {
                type: 'category',
                data: ["上城区", "下城区", "江干区", "拱墅区", "西湖区", "滨江区", "萧山区"],
                axisLabel: {
                    textStyle: {
                        color: '#ffffff',//字体颜色
                        fontSize: 12 //字体大小
                    }
                },
                position:'right',
                axisLine:{
                    show:false,
                },
                axisTick:{
                    show:false
                }
            },
            color: ['#67C23A', '#E6A23C'],
            series: [
                {
                    name: '直接访问',
                    type: 'bar',
                    stack: '总量',
                    barCategoryGap : '50%',
                    itemStyle:{

                    },
                    label: {
                        show: true,
                        position: 'insideRight'
                    },
                    data: [320, 302, 301, 334, 390, 330, 320]
                },
                {
                    name: '邮件营销',
                    type: 'bar',
                    stack: '总量',
                    barCategoryGap : '50%',
                    label: {
                        show: true,
                        position: 'insideRight'
                    },
                    data: [120, 132, 101, 134, 90, 230, 210]
                }
            ]
        };
        sjtj_Chart.setOption(option_sjtj);
        let lastIndex = 0;
        let currentIndex = 0;
        setInterval(() => {
            sjtj_Chart.dispatchAction({
                type: 'showTip',
                seriesIndex: 0,
                dataIndex: currentIndex,
            });
            lastIndex = currentIndex;
            ++currentIndex;
            if (currentIndex > 6) {
                currentIndex = 0;
            }
        }, 3000);
        gysjtj_Chart = echarts.init(document.getElementById('gyfsjid'));
        option_gysjtj = {
            tooltip: {
                trigger: 'axis',
                axisPointer: {            // 坐标轴指示器，坐标轴触发有效
                    type: 'shadow'        // 默认为直线，可选为：'line' | 'shadow'
                }
            },
            legend: {
                data: ['正常', '异常'],
                left:'10%',
                textStyle:{
                    color:'#ffffff',
                    fontSize:12
                },
            },
            grid: {
                left: '3%',
                right: '4%',
                bottom: '3%',
                containLabel: true
            },
            xAxis: [
                {
                    type: 'category',
                    data: ['1月', '2月', '3月', '4月', '5月', '6月', '7月'],
                    axisLabel: {
                        textStyle: {
                            color: '#ffffff',//字体颜色
                            fontSize: 12 //字体大小
                        }
                    }
                }
            ],
            yAxis: [
                {
                    type: 'value',
                    position:'right',
                    axisLabel: {
                        textStyle: {
                            color: '#ffffff',//字体颜色
                            fontSize: 12 //字体大小
                        }
                    }
                }
            ],
            color: ['#67C23A', '#E6A23C'],
            series: [
                {
                    name: '正常',
                    type: 'bar',
                    data: [150, 232, 201, 154, 190, 330, 410]
                },
                {
                    name: '异常',
                    type: 'bar',
                    data: [862, 1018, 964, 1026, 1679, 1600, 1570],
                }
            ]
        };
        gysjtj_Chart.setOption(option_gysjtj);
        let lastIndex1 = 0;
        let currentIndex1 = 0;
        setInterval(() => {
            gysjtj_Chart.dispatchAction({
                type: 'showTip',
                seriesIndex: 0,
                dataIndex: currentIndex1,
            });
            lastIndex1 = currentIndex1;
            ++currentIndex1;
            if (currentIndex1 > 6) {
                currentIndex1 = 0;
            }
        }, 3000);
    }
});

var left_vue=new Vue({
    el:"#leftid",
    data:{
        tpzsl:6800,
    },methods:{

    },mounted() {
        myChart = echarts.init(document.getElementById('tpslid'));
        option = {
            tooltip: {
                trigger: 'item',
                formatter: '{a} <br/>{b}: {c} ({d}%)'
            },
            legend: {
                orient: 'horizontal',
                right: '10%',
                top: '15%',
                textStyle: {
                    color: '#FFFFFF',
                },
                data: ['正常', '异常']
            },
            color: ['#67C23A', '#E6A23C'],
            series: [
                {
                    name: '访问来源',
                    type: 'pie',
                    center: ['25%', '50%'],
                    radius: ['50%', '70%'],
                    avoidLabelOverlap: false,
                    label: {
                        show: false,
                        position: 'center'
                    },
                    emphasis: {
                        label: {
                            show: true,
                            fontSize: '30',
                            fontWeight: 'bold'
                        }
                    },
                    labelLine: {
                        show: false
                    },
                    data: [
                        {value: 335, name: '正常'},
                        {value: 100, name: '异常'}
                    ]
                }
            ]
        };
        myChart.setOption(option);
        let lastIndex = 0;
        let currentIndex = 0;
        setInterval(() => {
            myChart.dispatchAction({
                type: 'showTip',
                seriesIndex: 0,
                dataIndex: currentIndex,
            });
            lastIndex = currentIndex;
            ++currentIndex;
            if (currentIndex > 1) {
                currentIndex = 0;
            }
        }, 3000);
        gwph_Chart = echarts.init(document.getElementById('gwphid'));
        var option_gwph = {
            legend: {
                show: true,
                top: '0',
                right: '1%',
                data: ['近一周', '近一月'],
                icon: 'circle',
                textStyle: {
                    color: "#65ABE7",
                    fontSize: 12
                }
            },

            grid: {
                top: "15%",
                bottom: "15%",
                right: "5%",
                left: "12%"
            },
            tooltip: {
                trigger: 'axis',
                axisPointer: {
                    type: 'cross',
                    label: {
                        backgroundColor: '#6a7985'
                    }
                }
            },
            xAxis: {
                data: ["上城区", "下城区", "江干区", "拱墅区", "西湖区", "滨江区", "萧山区"],
                axisLine: {show: false},
                axisTick: {
                    show: false
                },
                axisLabel: { //X轴标签
                    show: true,
                    textStyle: {
                        color: '#65ABE7',//字体颜色
                        fontSize: 12 //字体大小
                    }
                }
            },
            yAxis: [
                {
                    type: 'value',
                    name: '(排行率%)',
                    nameTextStyle: {
                        color: "#65ABE7",
                        fontSize: 12,
                    },
                    min: 0,
                    max: 100,
                    interval: 20,
                    lineStyle: {
                        color: '#65ABE7',
                    },
                    axisLabel: {
                        textStyle: {
                            color: '#65ABE7',//字体颜色
                            fontSize: 12 //字体大小
                        }
                    },
                    axisTick: {show: false},
                    axisLine: {
                        show: true,
                        lineStyle: {
                            color: '#657CA8',
                        }
                    },
                    splitLine: { //Y轴分隔符
                        show: true,
                        lineStyle: {
                            color: '#65ABE7',
                        }
                    }
                },
            ],
            series: [
                {
                    smooth: true,
                    areaStyle: {
                        normal: {
                            color: new echarts.graphic.LinearGradient(0, 0, 0, 1, [{
                                offset: 0,
                                color: '#5d98eb'
                            },
                                {
                                    offset: 1,
                                    color: 'rgba(126,171,233,0)'
                                }
                            ], false),
                            shadowColor: 'rgba(44,118,222, 0.8)',
                            shadowBlur: 20
                        }
                    },
                    name: '近一周',
                    type: 'line',
                    data: [45, 78, 24, 53, 38, 88, 57],
                    itemStyle: {
                        normal: {
                            color: '#1476e8',
                            label: {
                                show: false, //开启显示
                                position: 'bottom', //在下方显示
                                textStyle: { //数值样式
                                    color: '#65ABE7',
                                    fontSize: 16
                                }
                            }
                        }
                    }
                },
                {
                    smooth: true,
                    name: '近一月',
                    type: 'line',
                    data: [60, 27, 38, 21, 77, 28, 39],
                    itemStyle: {
                        normal: {
                            color: '#ec534c',
                            lineStyle: {
                                width: 2,
                                type: 'dashed' //'dotted'点型虚线 'solid'实线 'dashed'线性虚线
                            }
                        }
                    },
                }
            ]
        };
        gwph_Chart.setOption(option_gwph);
        let lastIndex1 = 0;
        let currentIndex1 = 0;
        setInterval(() => {
            gwph_Chart.dispatchAction({
                type: 'showTip',
                seriesIndex: 0,
                dataIndex: currentIndex1,
            });
            lastIndex1 = currentIndex1;
            ++currentIndex1;
            if (currentIndex1 > 6) {
                currentIndex1 = 0;
            }
        }, 3000);
    }
});

var center_vue=new Vue({
    el:'#centerid',
    data:{

    },mounted(){
        gdf_Chart = echarts.init(document.getElementById('glkid'));
        option = {
            tooltip: {
                trigger: 'item',
                formatter: '{a} <br/>{b}: {c} ({d}%)'
            },
            legend: {
                orient: 'vertical',
                left: '20%',
                top:'25%',
                data: ['广场', '路口', '河道', '踩踏'],
                textStyle:{
                    color:'#ffffff'
                }
            },
            color:["#00FFFF","#FFDC35","#FF2D2D","#FF8000"],
            series: [
                {
                    name: '访问来源',
                    type: 'pie',
                    radius: ['50%', '70%'],
                    center: ['70%', '50%'],
                    avoidLabelOverlap: false,
                    label: {
                        show: false,
                        position: 'center'
                    },
                    emphasis: {
                        label: {
                            show: true,
                            fontSize: '30',
                            fontWeight: 'bold'
                        }
                    },
                    labelLine: {
                        show: false
                    },
                    data: [
                        {value: 335, name: '广场'},
                        {value: 310, name: '路口'},
                        {value: 234, name: '河道'},
                        {value: 135, name: '踩踏'}
                    ]
                }
            ]
        };
        gdf_Chart.setOption(option);
        let lastIndex = 0;
        let currentIndex = 0;
        setInterval(() => {
            gdf_Chart.dispatchAction({
                type: 'showTip',
                seriesIndex: 0,
                dataIndex: currentIndex,
            });
            lastIndex = currentIndex;
            ++currentIndex;
            if (currentIndex > 4) {
                currentIndex = 0;
            }
        }, 3000);
    }
});

setTimeout(function () {
    window.onresize = function () {
        sjtj_Chart.resize();
        gysjtj_Chart.resize();
        gdf_Chart.resize();
        myChart.resize();
        gwph_Chart.resize();
    }
}, 300);