package im.zhaojun.system.service;

import im.zhaojun.system.mapper.DeptMapper;
import im.zhaojun.system.model.Dept;
import im.zhaojun.system.model.DeptVideo;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Service
public class DeptService {

    @Resource
    private DeptMapper deptMapper;

    public Dept insert(Dept dept) {
        int maxOrderNum = deptMapper.selectMaxOrderNum();
        dept.setOrderNum(maxOrderNum + 1);
        deptMapper.insert(dept);
        return dept;
    }


    public int deleteByPrimaryKey(Integer deptId) {
        return deptMapper.deleteByPrimaryKey(deptId);
    }

    public Dept updateByPrimaryKey(Dept dept) {
        deptMapper.updateByPrimaryKey(dept);
        return dept;
    }
    public List<Map> selectByPrimaryKey(String deptId) {
        return deptMapper.selectByPrimaryKey(deptId);
    }
    /**
     * 删除当前部门及子部门.
     */
    public void deleteCascadeByID(Integer deptId) {

        List<Integer> childIDList = deptMapper.selectChildrenIDByPrimaryKey(deptId);
        for (Integer childId : childIDList) {
            deleteCascadeByID(childId);
        }

        deleteByPrimaryKey(deptId);
    }

    /**
     * 根据父 ID 查询部门
     */
    public List<Dept> selectByParentId(Integer parentId) {
        return deptMapper.selectByParentId(parentId);
    }



    /**
     * 查找所有的部门的树形结构
     */
    public List<Dept> selectAllTree() {
        return deptMapper.selectAllTree();
    }

    /**
     * 获取所有菜单并添加一个根节点 (树形结构)
     */
    public List<Dept> selectAllTreeAndRoot() {
        return  selectAllTree();
    }



    public void swapSort(Integer currentId, Integer swapId) {
        deptMapper.swapSort(currentId, swapId);
    }
    public int selectMaxOrderNum() {
       return deptMapper.selectMaxOrderNum();
    }

   /**
     * 查找所有的部门及监控树形结构
     */
    public List<DeptVideo> listvideo(String deptId, String username,String tdmc) {
        return deptMapper.listvideo(deptId,username,tdmc);
    }


    /**
     * 查找部门及其子節點
     */
    public List<Dept> selectDeptChildren(Integer deptId, String username) {
        return deptMapper.selectDeptChildren(deptId,username);
    }

    /**
     * 更新默認監控
     */
    public Integer updateDefaultVideoByDeptId(String deptId, String videoId) {
        return deptMapper.updateDefaultVideoByDeptId(deptId,videoId);
    }

    /**
     * 查詢默認監控
     */
    public List<Map> selectDefaultVideoByDeptId(String deptId) {
        return deptMapper.selectDefaultVideoByDeptId(deptId);
    }


    /**
     * 查詢默認監控
     */
    public List<Map> selectAllDefaultVideo(String deptId) {
        return deptMapper.selectAllDefaultVideo(deptId);
    }

    /**
     * 查詢默認監控是否存在
     */
    public int selectExistsDefaultVideo(String deptId,String videoid) {
        return deptMapper.selectExistsDefaultVideo(deptId,videoid);
    }


    /**
     * 新增默認監控是否存在
     */
    public int insertDefaultVideo(String deptId,String videoid) {
        return deptMapper.insertDefaultVideo(deptId,videoid);
    }

    public List<Map> listAllvideoIdsByDeptid(String deptid){
        return deptMapper.listAllvideoIdsByDeptid(deptid);
    }

}
