package im.zhaojun.common.util;

import java.util.concurrent.*;
import java.util.concurrent.ThreadPoolExecutor.CallerRunsPolicy;

public class ThreadPoolUtil {
	
	private static BlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>(5000); 
	private static final ExecutorService pool =new  ThreadPoolExecutor(10, 30, 2L, TimeUnit.MINUTES,
			queue , Executors.defaultThreadFactory(),  new CallerRunsPolicy());
	
	private static final ScheduledExecutorService schedulepool = Executors.newScheduledThreadPool(2);
	 
	public static ScheduledExecutorService getSchedulePool() {
		return schedulepool;
	}
 
	public static ExecutorService getPool() {
		return pool;
	}
	public static  int getQueueSize(){
		return queue.size();
	}
	
	public static void executeSchedule(Runnable thread){
		getSchedulePool().execute(thread);
	}
	 
	public static void execute(Runnable thread){
		getPool().execute(thread);
	}
} 
