package im.dx.system.controller;

import com.github.pagehelper.PageInfo;
import im.dx.common.shiro.ShiroActionProperties;
import im.dx.common.util.DateUtils;
import im.dx.common.util.JsonUtil;
import im.dx.common.util.PageResultBean;
import im.dx.common.util.ResultBean;
import im.dx.system.model.*;
import im.dx.system.service.AlgorithmPreprocessService;
import im.dx.system.service.AutoSnapService;
import im.dx.system.service.CutpictureService;
import im.dx.system.service.VideoService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

@Controller
@RequestMapping("/video")
public class VideoController {
    private static final Logger log = LoggerFactory.getLogger(VideoController.class);
    @Resource
    private VideoService videoService;
    @Autowired
    public RestTemplate restTemplate;
    @Autowired
    private AutoSnapService autoSnapService;


    @Value("${file.rtspurl}")
    private String rtspurl;
    @Value("${file.taskurl}")
    private String addtaskurl;
    @Resource
    private ShiroActionProperties shiroActionProperties;



    @Resource
    private CutpictureService cutpictureService;
    @Resource
    AlgorithmPreprocessService  algorithmPreprocessService;

    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    /***
     * 根据deptId获取用户列表
     * @param page
     * @param pageSize
     * @param deptId
     * @param userId
     * @param username
     * @param videoName
     * @return
     */
    @GetMapping("/list")
    @ResponseBody
    public PageResultBean<Video> getList(@RequestParam(value = "page", defaultValue = "1") int page,
                                         @RequestParam(value = "pageSize", defaultValue = "10") int pageSize,
                                         @RequestParam(value = "deptId") String deptId,
                                         @RequestParam(value = "userId") String userId,
                                         @RequestParam(value = "username") String username,
                                         @RequestParam(value = "videoName") String videoName) {
        if (null!=username && shiroActionProperties.getSuperAdminUsername().equals(username)) {
            userId =null;
        }
        List<Video> videos = videoService.selectByMutiParam(page, pageSize, deptId,userId, videoName);
        PageInfo<Video> userPageInfo = new PageInfo<>(videos);
        return new PageResultBean<>(userPageInfo.getTotal(), userPageInfo.getList());

    }

    /***
     * 新增监控
     * @param video
     * @return
     */

    @PostMapping("/add")
    @ResponseBody
    public ResultBean add(Sbtdspsr video) {
        video.setCjrq(sdf.format(new Date()));
        video.setXgrq(video.getCjrq());
        return ResultBean.success(videoService.add(video));
    }

    /***
     * 删除监控
     * @param id
     * @return
     */
    @GetMapping("/delete/{Id}")
    @ResponseBody
    public ResultBean delete(@PathVariable("Id") String id) {
        videoService.delete(id);
        return ResultBean.success();
    }

    /***
     * 抽帧
     * @param videoid
     * @return
     */
    @PostMapping("/getSnapshot")
    @ResponseBody
    public ResultObj getSnapshot(@RequestBody String videoid) {
        //根据rtsp 获得 图片地址
        videoid = videoid.replace("\"", "");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        Map<String, Object> maps = new HashMap<>();
        maps.put("deviceCode", videoid);
        Map result = restTemplate.getForObject(rtspurl + "?deviceCode={deviceCode}", Map.class, maps);
        if (null != result) {
            if (null != result.get("ret") && String.valueOf(result.get("ret")).equals("0")
                    && result.get("desc").toString().contains("succ")) {
                //获得图片地址
                return ResultObj.ok(result.get("url").toString());
            }

        }
        return ResultObj.error(999, "超时");
    }

    /***
     * 添加任务
     * @param jobParam
     * @return
     */
    @PostMapping("/task")
    @ResponseBody
    public TaskResultObj scheduleJob(@RequestBody JobParam jobParam) {
        //根据type  判断是新增、删除、停止、开始
        //0新增 1开启 2停止 3删除
        //根据taskno 判断是否存在
        String objstr="0";
        if(null!=jobParam.getParams().get("objectType")){
            objstr=jobParam.getParams().get("objectType").toString();
        }
        String taskno="fx_" + jobParam.getDeviceId() + "_" + jobParam.getDetectType()+"_"+objstr;
        if(null!=jobParam.getParams().get("taskno")) {
            taskno = jobParam.getParams().get("taskno").toString();
        }
        if (null!=jobParam.getType() && jobParam.getType().equals("0")) {
            int fxtasknum = videoService.taskExists(taskno);
            if (fxtasknum > 0) {
                return TaskResultObj.error("-2", "");
            }
        }
        //调用第三方接口
        List<Point> points = new ArrayList<>();
        Point point = jobParam.getArea() != null ? jobParam.getArea().size() > 0 ? jobParam.getArea().get(0) : null : null;
        if (null != point) {
            points.add(
                    new Point(point.getX(), point.getY())
            );
            points.add(
                    new Point(point.getX(), point.getY() + point.getH())
            );
            points.add(
                    new Point(point.getX() + point.getW(), point.getY())
            );
            points.add(
                    new Point(point.getX() + point.getW(), point.getY() + point.getH())
            );

        }
        jobParam.setArea(points);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity<JobParam> requestEntity = new HttpEntity<>(jobParam, headers);
        try {
            return CompletableFuture.supplyAsync(() -> restTemplate.postForObject(addtaskurl, requestEntity, TaskResultObj.class)).get(500, TimeUnit.MILLISECONDS);
        }
        catch (Exception ex){
            log.error("添加任务error:{}",ex.toString());
            return TaskResultObj.error("-1","！");
        }
    }

    /***
     * 添加垃圾溢出识别任务
     * @param jobParam
     * @return
     */

    @PostMapping("/LJTtask")
    @ResponseBody
    public TaskResultObj LJTtask(@RequestBody JobLJTParam jobParam) {
        log.info("添加垃圾溢出识别任务");
        if (jobParam.getParams() != null) {//获得四个点的坐标
            if(null!=jobParam.getParams().get("region") ) {
                Map pointmap=(Map) jobParam.getParams().get("region");
                try {
                    Point point = JsonUtil.strToObj(JsonUtil.objToStr(pointmap), Point.class);
                    //调用第三方
                    Integer[][] arrresult = {{point.getX(),
                            point.getY() + point.getH()},
                            {point.getX(), point.getY()},
                            {point.getX() + point.getW(),
                                    point.getY()}, {point.getX() + point.getW(),
                            point.getY() + point.getH()}};
                    //入表数据
                    jobParam.getParams().put("region", point.getX()+","+point.getY()+","+point.getW()+","+ point.getH()
                    );
                    //新增任务
                    //调用电信算法，返回结果成功后入表
                    Map mapresult = cutpictureService.CreateTaskLJTMYJC(jobParam.getDeviceNum(), jobParam.getInterval(), arrresult);

                    log.info(JsonUtil.objToStr(mapresult));
                    if (null!=mapresult && null!= mapresult.get("errorCode")&& mapresult.get("errorCode").toString().equals("0")) {
                        //任务新建成功，数据入表{"errorCode":"0","errorMsg":"成功","data":{"taskId":"da7fa7b502014547b1bdced4ea5bc8629344"}}
                       Map result=(Map) mapresult.get("data");
                       if(null!=result.get("taskId")){
                           //表，将开始时间结束时间放入表中
                           jobParam.getParams().put("taskId",result.get("taskId").toString());
                           algorithmPreprocessService.add(jobParam);

                       }
                    } else {
                        log.error("添加垃圾溢出识别任务 :error:{}", mapresult.get("errorMsg"));
                        return TaskResultObj.error("-1",mapresult.get("errorMsg").toString());
                    }
                }catch (Exception ex){

                    log.error("添加垃圾溢出识别任务 :error:{}", ex.toString());
                    return   TaskResultObj.error("-1","异常");
                }

            }

        }
        return TaskResultObj.ok();
    }

    /***
     * 开启或者停止任务
     * @param jobParam
     * @return
     */
    @PostMapping("/taskmange")
    @ResponseBody
    public TaskResultObj taskstop(@RequestBody JobLJTParam  jobParam) {
        //调用第三方的停止任务
        try {
            if(jobParam.getStatus()==2 && null!=jobParam.getParams().get("taskId")) {//1:新建，2:暂停，3:重启，4:删除
               Map  result= cutpictureService.StopTask(jobParam.getDeviceNum(), jobParam.getParams().get("taskId").toString());
                if (null != result.get("errorCode") &&result.get("errorCode").toString().equals("0")) {
                    algorithmPreprocessService.update(jobParam);
                } else {
                    log.error("HTTP {}", result.get("errorCode"), result.get("errorMsg"));
                    return TaskResultObj.error("-1",result.get("errorMsg").toString());
                }
            }
            else if(jobParam.getStatus()==3 && null!=jobParam.getParams().get("taskId")) {
                Map  result=   cutpictureService.StartTask(jobParam.getDeviceNum(), jobParam.getParams().get("taskId").toString());
                if (null != result.get("errorCode") &&result.get("errorCode").toString().equals("0")) {
                    algorithmPreprocessService.update(jobParam);
                } else {
                    log.error("HTTP {}", result.get("errorCode"), result.get("errorMsg"));
                    return TaskResultObj.error("-1",result.get("errorMsg").toString());
                }
            }
            else if(jobParam.getStatus()==4 && null!=jobParam.getParams().get("taskId")) {
                Map  result=   cutpictureService.DeleteTask(jobParam.getDeviceNum(), jobParam.getParams().get("taskId").toString());
               //删除记录
                if (null != result.get("errorCode") &&result.get("errorCode").toString().equals("0")) {
                    algorithmPreprocessService.delete(jobParam);
                }
                else {
                    log.error("HTTP {}", result.get("errorCode"), result.get("errorMsg"));
                    return TaskResultObj.error("-1",result.get("errorMsg").toString());
                }
            }

        }catch (Exception ex){
            log.error("任务管理失败：{}",ex);
            return TaskResultObj.error("-1","error");
        }
        return TaskResultObj.ok();
}

    /**
     * 编辑监控
     * @param video
     * @return
     */
    @PostMapping("/edit")
    @ResponseBody
    public ResultBean edit(Sbtdspsr video) {
        video.setXgrq(video.getCjrq());
        try {
            videoService.update(video);
        }catch (Exception ex){
            return ResultBean.error("error");
        }
        return ResultBean.success();
    }

    /**
     * 添加相机自动抓拍任务
     * @param jobParam
     * @return
     */
    @PostMapping("/autoSnapTask")
    @ResponseBody
    public TaskResultObj autoSnapTask(@RequestBody JobParam jobParam) {
        //0新增 1开启 2停止 3删除
        String taskno = jobParam.getDeviceId() + "_" + jobParam.getDetectType();
        if (jobParam.getType().equals("0")) {
            //根据taskno 判断是否存在
            if (null != jobParam.getParams().get("taskno")) {
                taskno = jobParam.getParams().get("taskno").toString();
            }
            int fxtasknum = autoSnapService.taskAutoSnapExists(taskno);
            if (fxtasknum > 0) {
                return TaskResultObj.error("-2", "任务已经存在");
            }
        }
        //新增到表中
        Autosnaptaskinfo autosnaptaskinfo=new Autosnaptaskinfo();
        autosnaptaskinfo.setAlgorithmfrom("1");
        autosnaptaskinfo.setDevicenum(jobParam.getDeviceId());
        autosnaptaskinfo.setSendurl(jobParam.getCallBackUrl());
        autosnaptaskinfo.setStarthour(jobParam.getParams().get("starthour")==null?"0":jobParam.getParams().get("starthour").toString());
        autosnaptaskinfo.setEndhour(jobParam.getParams().get("endhour")==null?"0":jobParam.getParams().get("endhour").toString());
        autosnaptaskinfo.setObjectType(jobParam.getParams().get("objectType")==null?"0":jobParam.getParams().get("objectType").toString());
        autosnaptaskinfo.setStatus("1");
        autosnaptaskinfo.setRecordtype(jobParam.getDetectType());
        autosnaptaskinfo.setSendtype(jobParam.getParams().get("sendType")==null?"1":jobParam.getParams().get("sendType").toString());
       if(null!=jobParam.getArea() && jobParam.getArea().size()>0) {
           Point point= jobParam.getArea().get(0);
           autosnaptaskinfo.setRegionx(Integer.toString(point.getX()));
           autosnaptaskinfo.setRegiony(Integer.toString(point.getY()));
           autosnaptaskinfo.setRegionw(Integer.toString(point.getW()));
           autosnaptaskinfo.setRegionh(Integer.toString(point.getH()));
       }
        autosnaptaskinfo.setSpId(jobParam.getDeviceId());
        autosnaptaskinfo.setTaskid(taskno);
        autosnaptaskinfo.setTaskname(jobParam.getName());
        autosnaptaskinfo.setThreshold(jobParam.getParams().get("thresholdValue")==null?"0":jobParam.getParams().get("thresholdValue").toString());
        autosnaptaskinfo.setCjrq(DateUtils.getTime());
        try {
            autoSnapService.add(autosnaptaskinfo);
        }catch (Exception ex){
            log.error(ex.toString());
            return TaskResultObj.error("-2","新增失败");
        }
        return TaskResultObj.ok();

    }

    @PostMapping("/autosnaptaskmange")
    @ResponseBody
    public TaskResultObj autosnaptaskmange(@RequestBody JobParam  jobParam) {
        //根据type  判断是新增、删除、停止、开始
        //0新增 1开启 2停止 3删除
        if(null!=jobParam.getParams() && null!=jobParam.getParams().get("taskId")) {
            String taskid = jobParam.getParams().get("taskId").toString();
            try {
                if (jobParam.getType().equalsIgnoreCase("3") && null != jobParam.getParams().get("taskId")) {
                    //删除
                    autoSnapService.delete(taskid);
                } else {//更新任务状态
                    autoSnapService.update(taskid, jobParam.getType());
                }
            } catch (Exception ex) {
                log.error("任务管理失败：{}", ex);
                return TaskResultObj.error("-1", "error");
            }
            return TaskResultObj.ok();
        }
        return TaskResultObj.error("-1", "参数为空");
    }

    /***
     *随机抽一帧图片，返回结果为存到表里吧
     */

    @GetMapping("/getsnap/{sbbh}")
    @ResponseBody
    public TaskResultObj getsnap(@PathVariable(value = "sbbh") String  sbbh) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        Map<String, Object> maps = new HashMap<>();
        maps.put("deviceCode", sbbh);
        try {
            Map result = restTemplate.getForObject(rtspurl + "?deviceCode={deviceCode}", Map.class, maps);
            if (null != result) {
                if (null != result.get("ret") && String.valueOf(result.get("ret")).equals("0")) {
                    if(result.get("url").equals("")){
                        return  TaskResultObj.error("-1","图片地址获取失败");
                    }
                    videoService.updateImgSrc(result.get("url") == null ? "" : result.get("url").toString(),sbbh);
                    return TaskResultObj.ok(result.get("url") == null ? "" : result.get("url").toString());
                }

            }

        }catch (Exception ex){
            log.error(ex.toString());
        }
        return TaskResultObj.ok("");
    }


}