package im.dx.system.controller;

import im.dx.common.util.PageResultBean;
import im.dx.common.util.ResultBean;
import im.dx.common.util.ThreadPoolUtil;
import im.dx.system.model.UserOnline;
import im.dx.system.service.UserOnlineService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.util.List;
import java.util.concurrent.*;

@Controller
@RequestMapping("/online")
@Slf4j
public class UserOnlineController {



    @Resource
    private UserOnlineService userOnlineService;


    @GetMapping("/list")
    @ResponseBody
    public PageResultBean<UserOnline> online() {
        List<UserOnline> list = userOnlineService.list();
        return new PageResultBean<>(list.size(), list);
    }



}
