package im.dx.system.controller;

import im.dx.common.shiro.ShiroActionProperties;
import im.dx.common.util.DateUtils;
import im.dx.common.util.ResultBean;
import im.dx.system.model.ResultObj;
import im.dx.system.model.User;
import im.dx.system.service.UserService;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.client.RestTemplate;
import org.thymeleaf.TemplateEngine;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;

@Controller
public class LoginController {

    @Resource
    private UserService userService;


    @Resource
    private TemplateEngine templateEngine;

    @Resource
    private ShiroActionProperties shiroActionProperties;


    @Autowired
    private RestTemplate restTemplate;


    @GetMapping(value = { "/","/login"})
    public String login(Model model) {
        model.addAttribute("loginVerify", shiroActionProperties.getLoginVerify());
        return "login";
    }

    @GetMapping("/register")
    public String register() {
        return "register";
    }

    @PostMapping("/login")
    @ResponseBody
    public ResultBean login(User user, @RequestParam(value = "captcha", required = false) String captcha,HttpServletResponse response) {
        Subject subject = SecurityUtils.getSubject();
        UsernamePasswordToken token = new UsernamePasswordToken(user.getUsername(), user.getPassword());
        subject.login(token);
        userService.updateLastLoginTimeByUsername(user.getUsername(), DateUtils.dateTimeNow("YYYY/MM/dd HH:mm:ss"));
        //查询用户操作权限一级菜单
        User cuser= userService.selectOneByUserName(user.getUsername());
        return ResultBean.success(cuser);
    }

    /***
     * 注销
     * @return
     */
    @GetMapping("/logout")
    public String logout() {
        SecurityUtils.getSubject().logout();
        return "redirect:login";
    }

    /***
     * 用户账号查询权限
     * @param username
     * @return
     */
    @PostMapping("/firstmenu")
    @ResponseBody
    public ResultBean firstmenu(String username) {
        if (null!=username && shiroActionProperties.getSuperAdminUsername().equals(username)) {
            username = null;
            return ResultBean.success(userService.selectUserFirstMenu(username));
        }
        else if(null!=username) {
            return ResultBean.success(userService.selectUserFirstMenu(username));
        }
        return ResultBean.success();
    }

    /***
     * 用户账号查询权限
     * @param menuid
     * @param username
     * @return
     */
    @PostMapping("/secondmenu")
    @ResponseBody
    public ResultBean firstmenu(Integer menuid,String username) {
        if (null!=username && shiroActionProperties.getSuperAdminUsername().equals(username)) {
            username = null;
            return ResultBean.success(userService.selectUserSecondMenu(menuid,username));
        }
        else if(null!=username) {
            return ResultBean.success(userService.selectUserSecondMenu(menuid,username));
        }

        return ResultBean.success();
    }


    /**
     * 事件推送测试模拟接口
     *
     * @return 推送结果
     */
    @RequestMapping("/test")
    public ResultObj test() {
        String message = "{\n" +
                "    \"type\": \"TRAFFIC_INCIDENT_ALARM\",\n" +
                "    \"id\": \"d9a2b0f0-f0cf-49b9-9b64-3da86a122afa\",\n" +
                "    \"video_id\": \"20200305112027144_0\",\n" +
                "    \"ts\": \"1609310601820\",\n" +
                "    \"incident_type\": \"no_motor_ban\",\n" +
                "    \"img_urls\": [\n" +
                "      \"http://33.57.1.22:8001/api/alg/files/1605126187-20200619143331241059_0-627?location=\",\n" +
                "      \"http://33.57.1.22:8001/api/alg/files/1605126187-20200619143331241059_0-627?location=\",\n" +
                "      \"http://33.57.1.22:8001/api/alg/files/1605126187-20200619143331241059_0-627?location=\",\n" +
                "      \"http://33.57.1.22:8001/api/alg/files/1605126187-20200619143331241059_0-627?location=\",\n" +
                "      \"http://33.57.1.22:8001/api/alg/files/1605126187-20200619143331241059_0-627?location=\"\n" +
                "    ],\n" +
                "    \"video_record_url\": \"http://33.57.1.22:8001/api/alg/files/1605126187-20200619143331241059_0-627?location=\",\n" +
                "    \"obj_location\": {\n" +
                "        \"x\": 0.1,\n" +
                "        \"y\": 0.2,\n" +
                "        \"width\": 0.4,\n" +
                "        \"height\": 0.7\n" +
                "    },\n" +
                "    \"img_base64\": [\"d0xEMHcFAESwdwaUjWDqB6/1Qw4LapAiSICVTOFWsGT0sgt\"]\n" +
                "}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity<String> requestEntity = new HttpEntity<>(message, headers);
        return restTemplate.postForObject("http://localhost:" + 8089 + "/alarmevent", requestEntity, ResultObj.class);
    }



}
