package im.dx.system.service;

import com.github.pagehelper.PageHelper;
import im.dx.common.util.DateUtils;
import im.dx.system.mapper.TraffdevicewriteresultMapper;
import im.dx.system.model.*;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;
import tk.mybatis.mapper.entity.Condition;
import tk.mybatis.mapper.entity.Example;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@Service
@Slf4j
public class TraffdevicewriteresultService {

    @Autowired
    private RestTemplate restTemplate;


    @Autowired
    private TraffdevicewriteresultMapper traffdevicewriteresultMapper;


    /**
     * ��ѯ��ҳ
     */
    public List<SbtdspsrResult> querySbtdspsrResultByPage(SbtdspsrParams sbtdspsr) {
        PageHelper.startPage(sbtdspsr.getPage(), sbtdspsr.getLimit());
        return traffdevicewriteresultMapper.querySbtdspsrResultByPage(sbtdspsr);
    }
    /**
     * ��ѯ��ҳ
     */
    public List<Traffdevicewriteresult> queryTraffdevicewriteresultByPage(TraffdevicewriteresultParams traffdevicewriteresult) {
        PageHelper.startPage(traffdevicewriteresult.getPage(), traffdevicewriteresult.getLimit());
        Condition condition = new Condition(Traffdevicewriteresult.class);
        Example.Criteria criteria = condition.createCriteria();
        if (traffdevicewriteresult.getCreatetime() != null) {
            criteria.andEqualTo("createtime", traffdevicewriteresult.getCreatetime());
        }
        if (traffdevicewriteresult.getPushdesc() != null) {
            criteria.andEqualTo("pushdesc", traffdevicewriteresult.getPushdesc());
        }
        if (traffdevicewriteresult.getPushstatus() != null) {
            criteria.andEqualTo("pushstatus", traffdevicewriteresult.getPushstatus());
        }
        if (StringUtils.isNotBlank(traffdevicewriteresult.getSbbh())) {
            criteria.andLike("sbbh", "%" + traffdevicewriteresult.getSbbh()+"%" );
        }
        if (traffdevicewriteresult.getTdbh() != null) {
            criteria.andEqualTo("tdbh", traffdevicewriteresult.getTdbh());
        }
        if (traffdevicewriteresult.getLikePushdesc() != null) {
            criteria.andLike("pushdesc", "%" + traffdevicewriteresult.getLikePushdesc() + "%");
        }
        if (traffdevicewriteresult.getLikePushstatus() != null) {
            criteria.andLike("pushstatus", "%" + traffdevicewriteresult.getLikePushstatus() + "%");
        }
        if (StringUtils.isNotBlank(traffdevicewriteresult.getLikeSbbh())) {
            criteria.andLike("sbbh", "%" + traffdevicewriteresult.getLikeSbbh() + "%");
        }
        if (traffdevicewriteresult.getLikeTdbh() != null) {
            criteria.andLike("tdbh", "%" + traffdevicewriteresult.getLikeTdbh() + "%");
        }
        if (StringUtils.isNotBlank(traffdevicewriteresult.getCreatetimeBegin())) {
            criteria.andGreaterThanOrEqualTo("createtime", DateUtils.parseDate(traffdevicewriteresult.getCreatetimeBegin()));
        }
        if (StringUtils.isNotBlank(traffdevicewriteresult.getCreatetimeEnd())) {
            criteria.andLessThanOrEqualTo("createtime", DateUtils.parseDate(traffdevicewriteresult.getCreatetimeEnd()));
        }
        return  traffdevicewriteresultMapper.selectByCondition(condition);
    }

    /**
     * ���
     */
    public ResultObj saveTraffdevicewriteresult(Traffdevicewriteresult traffdevicewriteresult) {
        traffdevicewriteresultMapper.insertSelective(traffdevicewriteresult);
        return ResultObj.ok();
    }

    /**
     * �������
     */
    public void saveTraffdevicewriteresultList(List<Traffdevicewriteresult> traffdevicewriteresultList) {
        traffdevicewriteresultMapper.insertList(traffdevicewriteresultList);
    }

    /**
     * ����
     */
    public void updateTraffdevicewriteresult(Traffdevicewriteresult traffdevicewriteresult) {
        traffdevicewriteresultMapper.updateByPrimaryKeySelective(traffdevicewriteresult);
    }

    /**
     * ɾ��
     */
    public void deleteTraffdevicewriteresult(Traffdevicewriteresult traffdevicewriteresult) {
        traffdevicewriteresultMapper.deleteByPrimaryKey(traffdevicewriteresult);
    }

    /**
     * ����ɾ��
     */
    public void deleteTraffdevicewriteresultList(List<Traffdevicewriteresult> traffdevicewriteresultList) {
        for (Traffdevicewriteresult traffdevicewriteresult : traffdevicewriteresultList) {
            traffdevicewriteresultMapper.deleteByPrimaryKey(traffdevicewriteresult);
        }
    }

}