package im.dx.system.service;

import im.dx.common.util.DateUtils;
import im.dx.common.util.JsonUtil;
import im.dx.system.model.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.DigestUtils;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service
public class CutpictureService {
    private static final Logger log = LoggerFactory.getLogger(CutpictureService.class);
    @Value("${dixanxinAIurl}")
    String dixanxinAIurl;

    @Value("${dixanxinTokenurl}")
    String dixanxinTokenurl;

    @Value("${appSecret}")
    String appSecret;

    @Value("${appId}")
    String appId;

    @Value("${dianxin.baseurl}")
    String baseUrl;
    @Value("${dianxin.spId}")
    String spId;


    /***
     * 新建垃圾桶检测任务
     */
    @Resource
    RestTemplate restTemplate;

    public boolean cutpicturestart(String deviceNum, Integer status, String taskId) {
        Map map = new HashMap<>();
        map.put("deviceNum", deviceNum);
        map.put("status", status);
        map.put("taskId", taskId);
        Map result = ctaiRequest(dixanxinAIurl, "capacity.algorithm.preprocess.create", JsonUtil.objToStr(map), "1.0.0");
        if (null != result.get("errorCode") &&result.get("errorCode").toString().equals("0")) {
            return true;
        } else {
            return false;
        }

    }


    public boolean cutpicturestop(String deviceNum, Integer status, String taskId) {
        Map map = new HashMap<>();
        map.put("deviceNum", deviceNum);
        map.put("status", status);
        map.put("taskId", taskId);
        Map result = ctaiRequest(dixanxinAIurl, "capacity.algorithm.preprocess.suspend", JsonUtil.objToStr(map), "1.0.0");
        if (null != result.get("errorCode") &&result.get("errorCode").toString().equals("0")) {
            return true;
        } else {
            return false;
        }
    }

    public String getAccessToken() {
        Map map = restTemplate.getForObject(
                String.format("https://apicapacity.51iwifi.com/oauth/token?grantType=client_credential&appId=%s&appSecret=%s",appId,appSecret), Map.class);

            if (null != map.get("errorCode") && map.get("errorCode").toString().equals("0")) {
                if (null != map.get("data")) {
                    Map mapresult = (Map) map.get("data");
                    return mapresult.get("accessToken") == null ? null : mapresult.get("accessToken").toString();
                }
            }
        return null;
    }

    public String getSign(String accessToken, String method, String timestamp, String params, String signContent, String version) {
        if (null == accessToken || "".equals(accessToken)) {
            return "";
        }
        String s;
        if (null == params || "".equals(params)) {
            s = MessageFormat.format("{0}accessToken{1}appId{2}bodyContent{3}method{4}timestamp{5}v{6}{0}",appSecret, accessToken, appId,
                    signContent, method, timestamp,
                    version, appSecret);
        } else {
            s = MessageFormat.format("{0}accessToken{1}appId{2}method{3}params{4}timestamp{5}v{6}{0}", appSecret, accessToken, appId, signContent,
                    method, signContent, timestamp,
                    version, appSecret);
        }
        try {
            return DigestUtils.md5DigestAsHex(s.getBytes("utf-8")).toUpperCase();
        }catch (Exception ex){
            return null;
        }
    }

    public Map ctaiRequest(String url, String method, String requestContent, String version) {
        String accessToken = getAccessToken();
        String timestamp = DateUtils.getTime();
        String sign = getSign(accessToken, method, timestamp, null, requestContent, version);
        String requesturl = String.format("%s?accessToken=%s&method=%s&v=%s&appId=%s&timestamp=%s&sign=%s",
                url, accessToken, method, version, appId, URLDecoder.decode(timestamp).replace("%20", "+"), sign);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity<String> requestEntity = new HttpEntity<>(requestContent, headers);
        Map httpRequest = restTemplate.postForObject(requesturl, requestEntity, Map.class);
        //{"errorCode":"0","errorMsg":"成功","data":{"taskId":"da7fa7b502014547b1bdced4ea5bc8629344"}}
        return httpRequest;
    }

    /**
     * 创建越线检测任务
     * @param deviceNum
     * @param interval
     * @param areaPointList
     * @param direct
     * @param angle
     * @return
     */
    public Map CreateYXJCTask(String deviceNum, Integer interval, Integer[][] areaPointList, String direct, Integer angle) {
        String url = "/algorithm/router";
        String method = "capacity.algorithm.preprocess.create";
        Map map = new HashMap();
        map.put("deviceNum", deviceNum);
        map.put("spId", spId);
        map.put("interfaceCode", "NEW_YXJC_001");
        map.put("interval", interval);
        map.put("status", 1);
        Map paramsMap = new HashMap();
        paramsMap.put("direct", direct);
        map.put("angle", angle);
        map.put("area", areaPointList);
        map.put("params", paramsMap);
        String version = "1.0.0";
        return ctaiRequest(baseUrl, method, JsonUtil.objToStr(map), version);
    }

    /**
     * 创建徘徊检测任务
     * @param deviceNum
     * @param interval
     * @param areaPointList
     * @param pushDuration
     * @return
     */
    public Map CreatePHJCTask(String deviceNum, Integer interval,Integer[][]  areaPointList, String pushDuration) {
        String url = "/algorithm/router";
        String method = "capacity.algorithm.preprocess.create";
        Map map = new HashMap();
        map.put("deviceNum", deviceNum);
        map.put("spId", spId);
        map.put("interfaceCode", "NEW_PHJC_001");
        map.put("interval", interval);
        map.put("status", 1);
        Map paramsMap = new HashMap();
        paramsMap.put("duration", pushDuration);
        map.put("region", areaPointList);
        map.put("params", paramsMap);
        return ctaiRequest(baseUrl, method, JsonUtil.objToStr(map), "1.0.0");
    }

    /***
     * 创建周界入侵任务
     * @param deviceNum
     * @param interval
     * @param areaPoint
     * @return
     */
    public Map CreateZJRQTask(String deviceNum, Integer interval,List<Point>  areaPoint) {
        String  url ="/algorithm/router";
        String method ="capacity.algorithm.preprocess.create";
        Map map = new HashMap();
        map.put("deviceNum", deviceNum);
        map.put("spId",spId);
        map.put("interfaceCode", "NEW_ZJRQ_001");
        map.put("interval", interval);
        map.put("status", 1);
        Map paramsMap = new HashMap();
        paramsMap.put("area", areaPoint.toArray() );
        map.put("params", paramsMap);
        return ctaiRequest(baseUrl, method, JsonUtil.objToStr(map), "1.0.0");
    }

    /***
     * 4.创建垃圾满溢检测任务
     * @param deviceNum
     * @param interval
     * @param areaPointList
     * @return
     */
// areaPointList = [ [0,0], [0,1080], [1920,0], [1920,1080] ]
    public Map  CreateTaskLJTMYJC(String deviceNum,Integer  interval, Integer[][] areaPointList) {
        String url = "/algorithm/router";
        String method = "capacity.algorithm.preprocess.create";
        Map map = new HashMap();
        map.put("deviceNum", deviceNum);
        map.put("spId",spId);
        map.put("interfaceCode", "NEW_LJTMYJC_001");
        map.put("interval", interval);
        map.put("status", 1);
        Map paramsMap = new HashMap();
        paramsMap.put("region", areaPointList);
        map.put("params", paramsMap);
        return ctaiRequest(baseUrl, method, JsonUtil.objToStr(map), "1.0.0");
    }
    public Map  StopTask(String  deviceNum, String taskId) {
        String  url = "/preprocess/node/route/other";
        String method ="capacity.preprocess.cutpicture.suspend";
        Map  map=new HashMap();
        map.put("deviceNum", deviceNum);
        map.put("status", 2);
        map.put("taskId", taskId);
        return ctaiRequest(baseUrl, method, JsonUtil.objToStr(map), "2.0.0");
    }
    public Map  StartTask(String deviceNum, String taskId) {
        String url = "/preprocess/node/route/other";
        String  method = "capacity.preprocess.cutpicture.start";
        Map  map=new HashMap();
        map.put("deviceNum", deviceNum);
        map.put("status", 3);
        map.put("taskId", taskId);
        return ctaiRequest(baseUrl, method, JsonUtil.objToStr(map), "2.0.0");
    }
    public Map  DeleteTask(String deviceNum, String taskId) {
        String  url = "/preprocess/node/route/other";
        String  method = "capacity.preprocess.cutpicture.delete";
        Map  map=new HashMap();
        map.put("deviceNum", deviceNum);
        map.put("status", 4);
        map.put("taskId", taskId);
        return ctaiRequest(baseUrl, method, JsonUtil.objToStr(map), "2.0.0");
    }

    /**
     * 订阅
     * @param algCode: YXJC_001 越线检测 , PHJC_001 徘徊检测, RQJC_001 周界 , LJTJC_001 垃圾桶
     * @param pushUrl
     * @return
     */

    public Map SubscribeAdd(String algCode, String pushUrl) {
        String url = "/analysis/app/subscription/add";
        String  method ="capacity.ai.add";
        return ctaiRequest(baseUrl, method,"{\"spId\":\"33\",\"algCode\":"+algCode+", \"pushUrl\":"+pushUrl+"}", "1.0.0");
    }

    /**
     * 修改订阅
     * @param algCode
     * @param pushUrl
     * @return
     */

    public Map SubscribeUpdate(String algCode, String pushUrl) {
        String url = "/analysis/app/subscription/update";
        String method = "capacity.ai.update";
        String requestdata = "{'spId':'33', 'algCode':"+algCode+", 'pushUrl':"+pushUrl+"}";
        return ctaiRequest(baseUrl, method, requestdata, "1.0.0");

    }

    /**
     * 查询订阅
     * @param algCode
     * @return
     */
    public Map  SubscribeGet(String algCode) {
        String url = "/analysis/app/subscription/get";
        String method = "capacity.ai.get";
        String requestdata = "{'spId':'33', 'algCode':"+algCode+"}";
        return ctaiRequest(baseUrl, method, requestdata, "1.0.0");
    }


    /**
     * 删除订阅
     * @param algCode
     * @return
     */
    public Map  SubscribeDelete(String algCode) {
        String  url = "/analysis/app/subscription/delete";
        String  method ="capacity.ai.delete";
        String  requestdata = "{'spId':'33', 'algCode':"+algCode+"}";
        return ctaiRequest(baseUrl, method, requestdata, "1.0.0");
    }

}