package im.dx.system.service;

import com.github.pagehelper.PageHelper;
import im.dx.system.mapper.AutoSnapMapper;
import im.dx.system.mapper.VideoMapper;
import im.dx.system.model.Autosnaptaskinfo;
import im.dx.system.model.JobParam;
import im.dx.system.model.Sbtdspsr;
import im.dx.system.model.Video;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

@Service
public class AutoSnapService {

    @Resource
    private AutoSnapMapper autoSnapMapper;

    public List<Autosnaptaskinfo> selectByMutiParam(int page, int  rows, String deptId, String videoName) {
        PageHelper.startPage(page, rows);
        return autoSnapMapper.selectByMutiParam(deptId,videoName);
    }

    @Transactional
    public Integer add(Autosnaptaskinfo autosnaptaskinfo) {
        return autoSnapMapper.insert(autosnaptaskinfo);
    }


    @Transactional
    public void delete(String  id) {
        autoSnapMapper.deleteAutosnaptaskinfo(id);
    }


    public void update(String taskid,String type) {
        autoSnapMapper.updateAutosnaptaskinfo(taskid,type);
    }


    public  int  taskAutoSnapExists(String taskno){
       return  autoSnapMapper.taskAutoSnapExists(taskno);
    }
}