package im.dx.system.controller;

import com.github.pagehelper.PageInfo;
import im.dx.common.shiro.ShiroActionProperties;
import im.dx.common.util.*;
import im.dx.system.model.*;

import im.dx.system.service.DeptService;
import im.dx.system.service.TrafficStatisticsService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.List;
import java.util.stream.Collectors;

@Slf4j
@Controller
@RequestMapping("/TrafficStatistics")
public class TrafficStatisticsController {
    @Resource
    private TrafficStatisticsService trafficStatisticsService;

    @Resource
    private ShiroActionProperties shiroActionProperties;

    @Resource
    DeptService deptService;

    /***
     * 查询字典表
     * @param codeid
     * @param level
     * @return
     */
    @GetMapping("/listcode")
    @ResponseBody
    public ResultBean listcode(@RequestParam("codeid") String codeid,
                               @RequestParam("alarmlevel") String level
    ) {
        List<CodeData> deptList = trafficStatisticsService.selectCodeByCodeId(codeid, level);
        return ResultBean.success(deptList);
    }

    @PostMapping("/queryTraffalarmrecordByPage/{sendOrNot}")
    @ResponseBody
    public PageResultBean<TraffpictureParam> queryTraffalarmrecordByPage(@PathVariable("sendOrNot") String sendOrNot, @RequestBody TraffalarmrecordParams params) {

        String[] arry = {};
        Map parammap = new HashMap();
        parammap.put("videoids", Arrays.asList("".equals(params.getVideoids()) || "null".equals(params.getVideoids()) ? arry : params.getVideoids().split(",")));
        parammap.put("starttime", params.getStarttime());
        parammap.put("endtime", params.getEndtime());
        parammap.put("recordtype", Arrays.asList(params.getRecordtype() == "" ? arry : params.getRecordtype().split(",")));
        parammap.put("checkstatus", params.getCheckstatus());
        parammap.put("deptid", params.getDeptid());
        parammap.put("construction", params.getConstruction());
        parammap.put("objlables", Arrays.asList(params.getObjlabel() == "" ? arry : params.getObjlabel().split(",")));
        parammap.put("processstatus", Arrays.asList(params.getProcessstatus() == "" ? arry : params.getProcessstatus().split(",")));
        parammap.put("rectificationtype", params.getRectificationtype());

        parammap.put("pushstatus", sendOrNot);
        parammap.put("sfpf", params.getSfpf());

        List<TraffpictureParam> traffalarmrecordResults =
                trafficStatisticsService.queryTraffalarmrecordByPage(parammap, params.getPage()
                        , params.getLimit());

        PageInfo<TraffpictureParam> rolePageInfo = new PageInfo<>(traffalarmrecordResults);
        return new PageResultBean<TraffpictureParam>(rolePageInfo.getTotal(), rolePageInfo.getList());
    }

    //更新告警状态
    @PostMapping("/updateTraffalarmrecordById")
    @ResponseBody
    public ResultBean updateTraffalarmrecordById(@RequestBody List<TraffpictureParam> recrdlist) {
        //支持对某一点位某一事件类型标注正检后，该事件类型之前的MANUALCHECKTIME 重复事件类型自动标注为正检.
        int result = trafficStatisticsService.updateTraffalarmrecordById(recrdlist);
        //更新任务表处理状态
        int result2 = trafficStatisticsService.updateDisputesInfo(recrdlist);
        return ResultBean.success();
    }

    /***
     * 查询推送第三方的记录
     * @param map
     * @return
     */

    @PostMapping("/list/pushrecordsBypage")
    @ResponseBody
    public PageResultBean<Traffalarmrecord> selectPushRecordsBypage(@RequestBody Map map) {
        List<Traffalarmrecord> carList = trafficStatisticsService.selectPushRecordsBypage(map, Integer.parseInt(map.get("page").toString()), Integer.parseInt(map.get("limit").toString()));
        PageInfo<Traffalarmrecord> rolePageInfo = new PageInfo<>(carList);
        return new PageResultBean<>(rolePageInfo.getTotal(), rolePageInfo.getList());

    }

    /**
     * 统计事件推送结果
     * @param traffalarmrecordstatParams
     * @return
     */
    @PostMapping("/list/eventresultBypage")
    @ResponseBody
    public PageResultBean<Traffalarmrecordstate> selecteventresultBypage(@RequestBody TraffalarmrecordstatParams traffalarmrecordstatParams) {

        List<Traffalarmrecordstate> carList = trafficStatisticsService.selecteventresultBypage(traffalarmrecordstatParams);
        PageInfo<Traffalarmrecordstate> rolePageInfo = new PageInfo<>(carList);
        return new PageResultBean<>(rolePageInfo.getTotal(), rolePageInfo.getList());

    }

    /***
     * 导出事件推送结果
     * @param response
     * @param traffalarmrecordstatParams
     */

    @RequestMapping("/expTraffalarmrecordstat")
    @ResponseBody
    public void expTraffalarmrecordstat(HttpServletResponse response, TraffalarmrecordstatParams traffalarmrecordstatParams) {
        String eventname = traffalarmrecordstatParams.getEventtype();
        List<Traffalarmrecordstate> traffalarmrecordstats = trafficStatisticsService.selecteventresultBypage(traffalarmrecordstatParams);
        List<HashMap> lists = new ArrayList<>();
        for (Traffalarmrecordstate m : traffalarmrecordstats) {
            HashMap<String, Object> listMap = new HashMap<>();
            listMap.put("countdate", m.getCountdate());
            listMap.put("eventname", StringUtils.isBlank(eventname) ? "全部" : m.getEventtypename());
            listMap.put("areaname", m.getAreaname());
            listMap.put("totalcount", m.getTotalcount());
            lists.add(listMap);
        }

        ExcelCol[] cells = new ExcelCol[8];
        cells[0] = new ExcelCol();
        cells[0].setColKey("countdate");
        cells[0].setColName("日期");
        cells[1] = new ExcelCol();
        cells[1].setColKey("eventname");
        cells[1].setColName("事件类型");
        cells[2] = new ExcelCol();
        cells[2].setColKey("areaname");
        cells[2].setColName("支队名称");
        cells[3] = new ExcelCol();
        cells[3].setColKey("totalcount");
        cells[3].setColName("事件数量");
        cells[4] = new ExcelCol();
        cells[4].setColKey("checkstatusms");
        cells[4].setColName("免审");

        Map<String, Object> params = new HashMap<>(4);
        SimpleDateFormat formart = new SimpleDateFormat("yyyy-MM-dd");
        String dateTime = formart.format(new Date());
        params.put("fileName", "推送统计-" + dateTime);
        params.put("sheetName", "推送统计");
        params.put("header", "推送统计");
        new ExportEngine().exportCommData(params, cells, lists, response);

    }

    /***
     * 取消推送事件信息
     * @param recordid
     * @return
     */
    //删除某一事件
    @GetMapping("/deleteTraffalarmrecordById/{recordid}")
    @ResponseBody
    public ResultBean deleteTraffalarmrecordById(@PathVariable("recordid") String recordid) {
        return ResultBean.success(trafficStatisticsService.deleteTraffalarmrecordById(recordid));
    }

    /**
     * 查询事件详情
     * @param id
     * @param recordtype
     * @return
     */
    @GetMapping("/queryTraffDetail/{id}/{recordtype}")
    @ResponseBody
    public ResultBean queryTraffDetail(@PathVariable("id") String id, @PathVariable("recordtype") String recordtype) {
        if ("1".equals(recordtype)) {
            List<Pedestrian> results = trafficStatisticsService.queryTraffPedeDetail(id);
            return ResultBean.success(results);
        } else if ("2".equals(recordtype)) {//车辆
            List<Traffic> results = trafficStatisticsService.queryTrafficDetail(id);
            return ResultBean.success(results);
        } else if ("3".equals(recordtype)) {//人脸
            List<Face> results = trafficStatisticsService.queryTraffFaceDetail(id);
            return ResultBean.success(results);
        } else if ("4".equals(recordtype)) {//人骑车
            List<PeopleRideBicyc> results = trafficStatisticsService.queryTraffPeopleRideBicycDetail(id);
            return ResultBean.success(results);
        }
        return ResultBean.success();

    }

    /***
     * 删除告警信息
     * @param recrdlist
     * @return
     */

    @PostMapping("/delTraffalarmrecordByIds")
    @ResponseBody
    public ResultBean delTraffalarmrecordByIds(@RequestBody List<TraffpictureParam> recrdlist) {
        try {
            trafficStatisticsService.deltaskinfoByIds(recrdlist);
            //删除告警信息
            int result = trafficStatisticsService.delTraffalarmrecordByIds(recrdlist);
        } catch (Exception ex) {
            return ResultBean.error("-1");
        }

        return ResultBean.success();
    }

    @PostMapping("/deltaskinfoByIds")
    @ResponseBody
    public ResultBean deltaskinfoByIds(@RequestBody List<TraffpictureParam> recrdlist) {
        int result = trafficStatisticsService.deltaskinfoByIds(recrdlist);
        return ResultBean.success();
    }

    /**
     * 分页查询告警信息
     * @param params
     * @return
     */

    @PostMapping("/queryTaskInfoByPage")
    @ResponseBody
    public PageResultBean<TraffpictureParam> queryTaskInfoByPage(@RequestBody TraffalarmrecordParams params) {

        String[] arry = {};
        Map parammap = new HashMap();
        parammap.put("videoids", Arrays.asList("".equals(params.getVideoids()) || "null".equals(params.getVideoids()) ? arry : params.getVideoids().split(",")));
        parammap.put("starttime", params.getStarttime());
        parammap.put("endtime", params.getEndtime());
        parammap.put("recordtype", Arrays.asList(params.getRecordtype() == "" ? arry : params.getRecordtype().split(",")));
        parammap.put("checkstatus", params.getCheckstatus());
        parammap.put("deptid", params.getDeptid());
        parammap.put("construction", params.getConstruction());
        parammap.put("objlables", Arrays.asList(params.getObjlabel() == "" ? arry : params.getObjlabel().split(",")));
        parammap.put("processstatus", Arrays.asList(params.getProcessstatus() == "" ? arry : params.getProcessstatus().split(",")));
        parammap.put("rectificationtype", params.getRectificationtype());
        parammap.put("userId", params.getUserid());
        parammap.put("sfpf", params.getSfpf());
        List<TraffpictureParam> traffalarmrecordResults =
                trafficStatisticsService.queryTaskInfoByPage(parammap, params.getPage()
                        , params.getLimit());

        PageInfo<TraffpictureParam> rolePageInfo = new PageInfo<>(traffalarmrecordResults);
        return new PageResultBean<TraffpictureParam>(rolePageInfo.getTotal(), rolePageInfo.getList());
    }

    /***
     * 撤回任务
     * @param recrdlist
     * @return
     */
    @PostMapping("/delDisputesInfo")
    @ResponseBody
    public ResultBean delDisputesInfo(@RequestBody List<TraffpictureParam> recrdlist) {
        try {
            trafficStatisticsService.delDisputesInfo(recrdlist);
        } catch (Exception ex) {
            return ResultBean.error("-1");
        }

        return ResultBean.success();
    }


    /***
     * 事件统计
     */
    @PostMapping("/eventStatistics")
    @ResponseBody
    public ResultBean delDisputesInfo(@RequestBody StatisticsParam statisticsParam) {
        try {
            //统计所有事件类型，事件数量，部门名称、部门编号
            List<StatisticsData> statisticsDataList = trafficStatisticsService.eventStatistics(statisticsParam);
            List<String> xlist = new ArrayList<>();
            List<Integer> ylist = new ArrayList<>();
            for (StatisticsData item : statisticsDataList) {
                xlist.add(item.getName() == null ? "未知" : item.getName());
                ylist.add(item.getNum());
            }
            Map map = new HashMap();
            map.put("x", xlist);
            map.put("y", ylist);
            return ResultBean.success(map);
        } catch (Exception ex) {
            return ResultBean.error("-1");
        }
    }

    @PostMapping("/deviceStatistics")
    @ResponseBody
    public ResultBean deviceStatistics(@RequestBody StatisticsParam statisticsParam) {
        try {
            //查询所有部门下的设备
            List<Dept> deptlist= deptService.selectAllTree();
            //统计所有事件类型，事件数量，部门名称、部门编号
            List<StatisticsData> statisticsDataList = trafficStatisticsService.deviceStatistics(statisticsParam);
            List<StatisticsData> resultList=new ArrayList<>();
            //遍历每个部门，统计所有部门的数量
            for( Dept item :  deptlist) {
                List<StatisticsData> filterdata = statisticsDataList.stream().
                        filter(st ->  st.getId().contains(","+item.getDeptId()+",")
                        ).collect(Collectors.toList());

                List<Integer> collect = filterdata.stream().map(dto -> Integer.valueOf(dto.getNum())).collect(Collectors.toList());
                Integer num = collect.stream().reduce(Integer::sum).orElse(0);
                StatisticsData data=new StatisticsData();
                data.setId(item.getDeptId().toString());
                data.setName(item.getDeptName());
                data.setNum(num);
                resultList.add(data);
            }

            List<String> xlist = new ArrayList<>();
            List<Integer> ylist = new ArrayList<>();
            for (StatisticsData item : resultList) {
                xlist.add(item.getName() == null ? "未知" : item.getName());
                ylist.add(item.getNum());
            }
            Map map = new HashMap();
            map.put("x", xlist);
            map.put("y", ylist);
            return ResultBean.success(map);
        } catch (Exception ex) {
            return ResultBean.error("-1");
        }
    }

    /***
     * 推送统计
     */
    @PostMapping("/sendInfoStatistics")
    @ResponseBody
    public ResultBean sendInfoStatistics(@RequestBody StatisticsParam statisticsParam) {
        try {
            //统计所有事件推送情况
            List<Map> statisticsDataList = trafficStatisticsService.sendInfoStatistics(statisticsParam);
            return ResultBean.success(statisticsDataList);
        } catch (Exception ex) {
            return ResultBean.error("-1");
        }
    }

    /***
     * 部门事件统计
     */
    @PostMapping("/departmentEventStatistics")
    @ResponseBody
    public ResultBean departmentEventStatistics(@RequestBody StatisticsParam statisticsParam) {
        try {
            //查询所有部门包括监控
            List<DeptVideo> deptlist = deptService.listvideo("0", null, null);
            //查询所有告警信息

            List<CodeData> codelist = trafficStatisticsService.selectCodeByCodeId("2", null);

            //统计所有事件推送情况
            List<StatisticsData> statisticsDataList = trafficStatisticsService.departmentEventStatistics(statisticsParam);
            //统计所有监控事件
            List<String> deptdatalist  = deptlist.stream().map(dto ->dto.getDeptName()).collect(Collectors.toList());
            List<Series> seriesList = new ArrayList<>();

            List<Integer> intlist = new ArrayList<>();

            for (CodeData code : codelist) {
                intlist.clear();
                for (DeptVideo item : deptlist) {
                    //遍历每个部门，统计所有部门的数量
                    item.setIdsets("," + item.getIdsets() + ",");
                    List<StatisticsData> filterdata = statisticsDataList.stream().
                            filter(st -> code.getKey().equalsIgnoreCase(st.getId()) &&
                                    ( st.getPid().contains(("," + item.getDeptId() + ","))
                                            || st.getXid().equalsIgnoreCase( item.getDeptId())
                                    )
                            ).collect(Collectors.toList());

                    List<Integer> collect = filterdata.stream().map(dto -> Integer.valueOf(dto.getNum())).collect(Collectors.toList());
                    Integer num = collect.stream().reduce(Integer::sum).orElse(0);
                    intlist.add(num);
                }
                Series se = new Series();
                se.setName(code.getName());
                se.setData(intlist.toArray());
                se.setStack("Ad");
                se.setType("bar");
                se.setEmphasis((Map) new HashMap().put("focus", "series"));
                seriesList.add(se);
            }
            Map mapresult = new HashMap();
            mapresult.put("x", deptdatalist);
            mapresult.put("y", seriesList);
            return ResultBean.success(mapresult);
        } catch (Exception ex) {
            return ResultBean.error("-1");
        }
    }


}
