package im.dx.system.controller;

import im.dx.system.model.Menu;
import im.dx.system.service.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Controller
@Slf4j
public class IndexController {

    @Resource
    private MenuService menuService;

    @Resource
    private LoginLogService loginLogService;

    @Resource
    private UserService userService;

    @Resource
    private RoleService roleService;

    @Resource
    private UserOnlineService userOnlineService;

    @Autowired
    private RestTemplate restTemplate;


    @GetMapping(value = {"/main"})
    public String index(Model model) {
        List<Menu> menuTreeVOS = menuService.selectCurrentUserMenuTree();
        model.addAttribute("menus", menuTreeVOS);
        return "main";
    }

    @GetMapping(value = {"/qxindex"})
    public String qxindex(Model model) {
        List<Menu> menuTreeVOS = menuService.selectCurrentUserMenuTree();
        model.addAttribute("menus", menuTreeVOS);
        return "index";
    }

    @GetMapping(value = {"/pub_index"})
    public String pagepub_index(Model model) {
        List<Menu> menuTreeVOS = menuService.selectCurrentUserMenuTree();
        model.addAttribute("menus", menuTreeVOS);
        return "page/pub_index";
    }

    @GetMapping(value = {"/sjcx"})
    public String pagesjcx(Model model) {
        List<Menu> menuTreeVOS = menuService.selectCurrentUserMenuTree();
        model.addAttribute("menus", menuTreeVOS);
        return "page/sjcx";
    }


    @GetMapping(value = {"/jkgl"})
    public String pagejkgl(Model model) {
        List<Menu> menuTreeVOS = menuService.selectCurrentUserMenuTree();
        model.addAttribute("menus", menuTreeVOS);
        return "page/jkgl";
    }

    @GetMapping(value = {"/sjfx"})
    public String pagesjfx(Model model) {
        List<Menu> menuTreeVOS = menuService.selectCurrentUserMenuTree();
        model.addAttribute("menus", menuTreeVOS);
        return "page/sjfx";
    }

    @GetMapping(value = {"/jgsbgl"})
    public String pagejgsbgl(Model model) {
        List<Menu> menuTreeVOS = menuService.selectCurrentUserMenuTree();
        model.addAttribute("menus", menuTreeVOS);
        return "page/jgsbgl";
    }

    @GetMapping(value = {"/tsgl"})
    public String pagetsgl(Model model) {
        List<Menu> menuTreeVOS = menuService.selectCurrentUserMenuTree();
        model.addAttribute("menus", menuTreeVOS);
        return "page/tsgl";
    }

    @GetMapping(value = {"/xtgl"})
    public String pagextgl(Model model) {
        List<Menu> menuTreeVOS = menuService.selectCurrentUserMenuTree();
        model.addAttribute("menus", menuTreeVOS);
        return "page/xtgl";
    }

    @GetMapping(value = {"/index"})
    public String pageindex(Model model) {
        List<Menu> menuTreeVOS = menuService.selectCurrentUserMenuTree();
        model.addAttribute("menus", menuTreeVOS);
        return "page/index";
    }

    @GetMapping(value = {"/gcjl"})
    public String pagegcjl(Model model) {
        List<Menu> menuTreeVOS = menuService.selectCurrentUserMenuTree();
        model.addAttribute("menus", menuTreeVOS);
        return "page/gcjl";
    }

    @GetMapping(value = {"/test"})
    public String test(Model model) {
//        List<Menu> menuTreeVOS = menuService.selectCurrentUserMenuTree();
//        model.addAttribute("menus", menuTreeVOS);
        return "page/test";
    }

    @GetMapping(value = {"/manualscreen"})
    public String manualscreen(Model model) {
        List<Menu> menuTreeVOS = menuService.selectCurrentUserMenuTree();
        model.addAttribute("menus", menuTreeVOS);
        return "page/manualscreen";
    }
    @GetMapping(value = {"/xxtj"})
    public String xxtj(Model model) {
        List<Menu> menuTreeVOS = menuService.selectCurrentUserMenuTree();
        model.addAttribute("menus", menuTreeVOS);
        return "page/xxtj";
    }


    @GetMapping(value = {"/symrjk"})
    public String pagesymrjk(Model model) {
        List<Menu> menuTreeVOS = menuService.selectCurrentUserMenuTree();
        model.addAttribute("menus", menuTreeVOS);
        return "page/symrjk";
    }

    @GetMapping(value = {"/sjdj"})
    public String pagesjdj(Model model) {
        List<Menu> menuTreeVOS = menuService.selectCurrentUserMenuTree();
        model.addAttribute("menus", menuTreeVOS);
        return "page/sjdj";
    }

    @GetMapping(value = {"/sjts"})
    public String pagesjts(Model model) {
        List<Menu> menuTreeVOS = menuService.selectCurrentUserMenuTree();
        model.addAttribute("menus", menuTreeVOS);
        return "page/sjts";
    }

    @GetMapping(value = {"/sbts"})
    public String pagesbts(Model model) {
        List<Menu> menuTreeVOS = menuService.selectCurrentUserMenuTree();
        model.addAttribute("menus", menuTreeVOS);
        return "page/sbts";
    }


    @GetMapping(value = {"/sjzdbz"})
    public String pagesjzdbz(Model model) {
        List<Menu> menuTreeVOS = menuService.selectCurrentUserMenuTree();
        model.addAttribute("menus", menuTreeVOS);
        return "page/sjzdbz";
    }

    @GetMapping(value = {"/jksj"})
    public String jksj(Model model) {
        List<Menu> menuTreeVOS = menuService.selectCurrentUserMenuTree();
        model.addAttribute("menus", menuTreeVOS);
        return "page/jksj";
    }

    @GetMapping(value = {"/ksh"})
    public String pageksh(Model model) {
        List<Menu> menuTreeVOS = menuService.selectCurrentUserMenuTree();
        model.addAttribute("menus", menuTreeVOS);
        return "page/ksh";
    }

    @GetMapping(value = {"/rgjy"})
    public String rgjy(Model model) {
        List<Menu> menuTreeVOS = menuService.selectCurrentUserMenuTree();
        model.addAttribute("menus", menuTreeVOS);
        return "page/rgjy";
    }

    @GetMapping(value = {"/rwpfhistory"})
    public String rwpfhistory(Model model) {
        List<Menu> menuTreeVOS = menuService.selectCurrentUserMenuTree();
        model.addAttribute("menus", menuTreeVOS);
        return "page/rwpfhistory";
    }


    public static String getMatcher(String regex, String source) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(source);
        List<String> list = new ArrayList<>();
        while (matcher.find()) {
            list.add(matcher.group(1));
        }
        if (list.size() > 1) {
            return list.get(list.size() - 2);
        }
        return null;
    }


}