package im.dx.system.controller;

import im.dx.common.shiro.ShiroActionProperties;
import im.dx.common.util.ResultBean;
import im.dx.common.util.TreeUtil;
import im.dx.system.model.Dept;
import im.dx.system.model.DeptVideo;
import im.dx.system.service.DeptService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Controller
@RequestMapping("/dept")
public class DeptController {

    @Resource
    private DeptService deptService;

    @Resource
    private ShiroActionProperties shiroActionProperties;

    @Value("${managername}")
    private String managername;



    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @GetMapping("/index")
    public String index() {
        return "dept/dept-list";
    }

    /***
     * 获取部门列表
     * @param parentId
     * @return
     */
    @GetMapping("/list")
    @ResponseBody
    public ResultBean getList(@RequestParam(value="parentId",required = false) Integer parentId) {
        List<Dept> deptList = deptService.selectByParentId(parentId);
        return ResultBean.success(deptList);
    }

    @GetMapping("/tree/root")
    @ResponseBody
    public ResultBean treeAndRoot() {
        return ResultBean.success(deptService.selectAllTreeAndRoot());
    }

    @GetMapping("/tree")
    @ResponseBody
    public ResultBean tree() {
        return ResultBean.success(deptService.selectAllTree());
    }





    @GetMapping
    public String add() {
        return "dept/dept-add";
    }

    /***
     * 新增部门
     * @param dept
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/add", method = RequestMethod.POST)
    public ResultBean add(Dept dept) {
        if(null==dept.getDeptId() ||dept.getDeptId().equals(""))
        {
            dept.setDeptId(deptService.selectMaxOrderNum()+1);
        }
        dept.setCreateTime(sdf.format(new Date()));
        dept.setModifyTime(dept.getCreateTime());
        return ResultBean.success(deptService.insert(dept));
    }

    /***
     * 删除部门
     * @param deptId
     * @return
     */
    @DeleteMapping("/{deptId}")
    @ResponseBody
    public ResultBean delete(@PathVariable("deptId") Integer deptId) {
        deptService.deleteCascadeByID(deptId);
        return ResultBean.success();
    }

    /***
     * 修改部门
     * @param dept
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/update", method = RequestMethod.POST)
    public ResultBean update(Dept dept) {
        dept.setModifyTime(sdf.format(new Date()));
        deptService.updateByPrimaryKey(dept);
        return ResultBean.success();
    }

    @GetMapping("/{deptId}")
    public ResultBean update(@PathVariable("deptId") String deptId) {
        List<Map> dept = deptService.selectByPrimaryKey(deptId);
        return ResultBean.success(dept);
    }


    @GetMapping("/getDeptParent/{deptId}")
    @ResponseBody
    public ResultBean getDeptParent(@PathVariable("deptId") String deptId) {
        List<Map> dept = deptService.selectByPrimaryKey(deptId);

        return ResultBean.success(dept);
    }

    /***
     * 调整部门排序
     * @param currentId
     * @param swapId
     * @return
     */

    @PostMapping("/swap")
    @ResponseBody
    public ResultBean swapSort(Integer currentId, Integer swapId) {
        deptService.swapSort(currentId, swapId);
        return ResultBean.success();
    }

    /***
     * 查询部门及監控
     * @param deptId
     * @param username
     * @param tdmc
     * @return
     */
    @GetMapping("/listvideo")
    @ResponseBody
    public ResultBean listvideo( @RequestParam("deptId") String  deptId,@RequestParam("username") String username,@RequestParam("tdmc")String tdmc) {
        if (null!=username && (shiroActionProperties.getSuperAdminUsername().equals(username)
                ||username.equalsIgnoreCase(managername))) {
            deptId = "0";
            username=null;
        }
        List<DeptVideo> deptlist=deptService.listvideo(deptId, username,tdmc);
       return ResultBean.success(deptlist);
    }

    /***
     * 查询部门及監控
     * @param deptId
     * @param username
     * @param tdmc
     * @return
     */
    @GetMapping("/listvideotree")
    @ResponseBody
    public ResultBean listvideotree( @RequestParam("deptId") String  deptId,@RequestParam("username") String username,@RequestParam("tdmc")String tdmc) {
        if (null!=username && (shiroActionProperties.getSuperAdminUsername().equals(username)
                ||username.equalsIgnoreCase(managername))) {
            deptId = "0";
            username=null;
        }
        List<DeptVideo> deptlist=deptService.listvideo(deptId, username,tdmc);
        List<DeptVideo> list= TreeUtil.toTree(deptlist,"deptId","parentId","nodes",DeptVideo.class,deptId);
        return ResultBean.success(list);
    }

    /***
     * 查询部门及其子节点
     * @param deptId
     * @param username
     * @return
     */
    @GetMapping("/listChildDept")
    @ResponseBody
    public ResultBean listChildDept( @RequestParam("deptId") Integer  deptId,@RequestParam("username") String username) {
        if (null!=username && (shiroActionProperties.getSuperAdminUsername().equals(username)
        ||username.equalsIgnoreCase(managername))) {
            deptId =0;
            username=null;
        }
        List<Dept> deptlist=deptService.selectDeptChildren(deptId, username);
      return ResultBean.success(deptlist);
    }

    /***
     * 更新部门默认监控
     * @param deptId
     * @param videoId
     * @return
     */
    @PostMapping("/updateDefaultVideo")
    @ResponseBody
    public ResultBean updateDefaultVideo( @RequestParam("deptId") String  deptId,@RequestParam("videoId") String videoId) {
        int result=deptService.updateDefaultVideoByDeptId(deptId, videoId);
        if(result>0) {
            return ResultBean.success();
        }else {
            return ResultBean.error("更新失敗");
        }
    }

    /***
     * 查询所有部门默认监控
     * @param deptId
     * @return
     */

    @GetMapping("/queryAllDefaultVideo")
    @ResponseBody
    public ResultBean queryAllDefaultVideo( @RequestParam("deptId") String  deptId) {
        return ResultBean.success(deptService.selectAllDefaultVideo(deptId));

    }


    /**
     * 查询所有监控
     * @param deptid
     * @return
     */
    @GetMapping("/listAllvideoIdsByDeptid")
    @ResponseBody
    public ResultBean listAllvideoIdsByDeptid(@RequestParam("deptid") String deptid) {

        List<Map> deptList = deptService.listAllvideoIdsByDeptid(deptid);
        return ResultBean.success(deptList);
    }



}
