package im.dx.system.controller;

import com.github.pagehelper.PageInfo;
import im.dx.common.util.PageResultBean;
import im.dx.common.util.ResultBean;
import im.dx.system.model.Code;
import im.dx.system.model.VideoeRecordType;
import im.dx.system.service.CodeService;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

@RestController
@RequestMapping("/code")
public class CodeController {


    @Resource
    private CodeService codeService;

    /***
     * 获取code列表
     * @param page
     * @param limit
     * @return
     */
    @GetMapping("/list")
    @ResponseBody
    public PageResultBean<Code> getList(@RequestParam(value = "page", defaultValue = "1") int page,
                                        @RequestParam(value = "limit", defaultValue = "10") int limit) {
        List<Code> codes = codeService.selectAllWithKey(page, limit);
        PageInfo<Code> userPageInfo = new PageInfo<>(codes);
        return new PageResultBean<>(userPageInfo.getTotal(), userPageInfo.getList());
    }

    /***
     * 获取指定type的code列表
     * @param typeid
     * @return
     */
    @GetMapping("/list/{typeid}")
    @ResponseBody
    public ResultBean getList(@PathVariable("typeid") String typeid) {
        List<Code> codes = codeService.selectAllWithType(typeid);
        return ResultBean.success(codes);
    }

    /**
     * 更新code
     * @param codelist
     * @return
     */
    @PostMapping("/update")
    public ResultBean update(@RequestBody List<Code> codelist) {

        int result = codeService.updatecode(codelist);
        return ResultBean.success();
    }

    /***
     * 新增
     * @param codelist
     * @return
     */
    @PostMapping("/add")
    public ResultBean add(@RequestBody List<Code> codelist) {

        int result = codeService.addcode(codelist);
        return ResultBean.success();
    }

    /***
     * 新增videoalarm
     * @param videoeRecordType
     * @return
     */
    @PostMapping("/addvideoeRecordType")
    public ResultBean VideoeRecordType(@RequestBody VideoeRecordType videoeRecordType) {
//判断存不存在
        int resultexixsts= codeService.selectvideoeRecordType(videoeRecordType);
        if(resultexixsts>0){
            return ResultBean.success("1");
        }
        int result = codeService.addvideoeRecordType(videoeRecordType);
        return ResultBean.success();
    }

    /***
     * 更新用户列表
     */
    public void test() {
        List<Code> codes = codeService.selectAllWithKey(1, 10);

    }

    /**
     * 更新code time
     * @param codelist
     * @return
     */
    @PostMapping("/updatetime")
    public ResultBean updatetime(@RequestBody List<Code> codelist) {

        int result = codeService.updatetime(codelist);
        return ResultBean.success();
    }

    /***
     * 禁用账号
     * @param codeId
     * @return
     */
    @PostMapping("/{codeId}/disable")
    @ResponseBody
    public ResultBean disable(@PathVariable("codeId") String codeId) {
        return ResultBean.success(codeService.disableCodeByCodeID(codeId));
    }

    /***
     * 激活账号
     * @param codeId
     * @return
     */
    @PostMapping("/{codeId}/enable")
    @ResponseBody
    public ResultBean enable(@PathVariable("codeId") String codeId) {
        return ResultBean.success(codeService.enableCodeByCodeID(codeId));
    }

    @GetMapping("/update/{name}/{alarmlevel}")
    public ResultBean update(@PathVariable("name") String name, @PathVariable("alarmlevel") String alarmlevel) {
      //更新手动状态
       return ResultBean.success(codeService.updatemanualcode(name,alarmlevel));
    }
}