package im.dx.system.service;

import com.github.pagehelper.PageHelper;
import im.dx.system.mapper.TrafficStatisticsMapper;
import im.dx.system.model.*;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;

/**
 * 通流量统计 Service
 */
@Service
public class TrafficStatisticsService {

    @Resource
    private TrafficStatisticsMapper trafficStatisticsMapper;


    public List<TraffpictureParam>  queryTraffalarmrecordByPage( Map map,int page, int limit) {
        PageHelper.startPage(page,limit);
        List<TraffpictureParam> traffalarmrecordResults=trafficStatisticsMapper.queryTraffalarmrecordByPage(map);

        return traffalarmrecordResults;
    }
    public List<TraffpictureParam>  queryTaskInfoByPage( Map map,int page, int limit) {
        PageHelper.startPage(page,limit);
        List<TraffpictureParam> traffalarmrecordResults=trafficStatisticsMapper.queryTaskInfoByPage(map);
        return traffalarmrecordResults;
    }

   public  int  updateTraffalarmrecordById(List<TraffpictureParam> recordlist ){

        return trafficStatisticsMapper.updateTraffalarmrecordById(recordlist);
   }
    public  int  updateDisputesInfo(List<TraffpictureParam> recordlist ){
        return trafficStatisticsMapper.updateDisputesInfo(recordlist);
    }


    public List<RecordResult>  todaytraffRecords(Map  map) {
        return trafficStatisticsMapper.todaytraffRecords(map);
    }

    public List<Map>  todaythbtraffRecords(Map  map) {
        return trafficStatisticsMapper.todaythbtraffRecords(map);
    }

    public List<VehiclesStatisticResult>  selecthistorytraffRecords(Map  map) {
        return trafficStatisticsMapper.selecthistorytraffRecords(map);
    }
    public List<VehiclesStatisticResult>  selecthistoryvehicles(Map  map) {
        return trafficStatisticsMapper.selecthistoryvehicles(map);
    }

    public List<Traffalarmrecord>  selectPushRecordsBypage(Map  map,int page, int limit) {
        PageHelper.startPage(page,limit);
        return trafficStatisticsMapper.selectPushRecordsBypage(map);
    }

    public List<Traffalarmrecordstate>  selecteventresultBypage(TraffalarmrecordstatParams params) {
        PageHelper.startPage(params.getPage(),params.getLimit());
        return trafficStatisticsMapper.selecteventresultBypage(params);
    }

    public  int  deleteTraffalarmrecordById(String  recordid ){
        return trafficStatisticsMapper.deleteTraffalarmrecordById(recordid);
    }
    public  int  updateTraffalarmrecordPushStatusById(String  recordid ){
        return trafficStatisticsMapper.updateTraffalarmrecordPushStatusById(recordid);
    }

    public  List<Pedestrian>  queryTraffPedeDetail(String id ){
        return trafficStatisticsMapper.queryTraffPedeDetail(id);
    }

    public  List<Traffic>  queryTrafficDetail(String id ){
        return trafficStatisticsMapper.queryTrafficDetail(id);
    }
    public  List<Face>  queryTraffFaceDetail(String id ){
        return trafficStatisticsMapper.queryTraffFaceDetail(id);
    }
    public  List<PeopleRideBicyc>  queryTraffPeopleRideBicycDetail(String id ){
        return trafficStatisticsMapper.queryTraffPeopleRideBicycDetail(id);
    }
    public  int  delTraffalarmrecordByIds(List<TraffpictureParam> recordlist){
        return trafficStatisticsMapper.delTraffalarmrecordByIds(recordlist);
    }


    public  int  deltaskinfoByIds(List<TraffpictureParam> recordlist){
        return trafficStatisticsMapper.deltaskinfoByIds(recordlist);
    }

    public   List<CodeData> selectCodeByCodeId(String codeid, String level){
        return trafficStatisticsMapper.selectCodeByCodeid(codeid,level);
    }

    public  int  delDisputesInfo(List<TraffpictureParam> recordlist){
        return trafficStatisticsMapper.delDisputesInfo(recordlist);
    }

    public  List<StatisticsData>   eventStatistics(StatisticsParam statisticsParam){
        return trafficStatisticsMapper.eventStatistics(statisticsParam);
    }
    public  List<StatisticsData>   deviceStatistics(StatisticsParam statisticsParam){
        return trafficStatisticsMapper.deviceStatistics(statisticsParam);
    }
    public  List<Map>   sendInfoStatistics(StatisticsParam statisticsParam){
        return trafficStatisticsMapper.sendInfoStatistics(statisticsParam);
    }
    public  List<StatisticsData>   departmentEventStatistics(StatisticsParam statisticsParam){
        return trafficStatisticsMapper.departmentEventStatistics(statisticsParam);
    }



}