package im.dx.common.config;


import cn.hutool.json.JSONUtil;
import im.dx.system.mapper.AlarmMapper;
import im.dx.system.model.Alarm;
import lombok.extern.slf4j.Slf4j;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft_6455;
import org.java_websocket.handshake.ServerHandshake;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.net.URI;

@Slf4j
@Component
public class WebSocketConfig {

    @Resource
    private AlarmMapper alarmMapper;
    @Bean
    public WebSocketClient webSocketClient() {
        try {
            WebSocketClient webSocketClient = new WebSocketClient(
                    new URI("ws://33.55.1.91:8001/api/message/sub/traffic-incident/alarm"), new Draft_6455()) {
                @Override
                public void onOpen(ServerHandshake handshakedata) {
                }

                @Override
                public void onMessage(String message) {
                    try {
                        Alarm alarm = JSONUtil.toBean(message, Alarm.class);
                        if(alarm.getType().equalsIgnoreCase("TRAFFIC_INCIDENT_ALARM")) {
                            alarmMapper.insert(alarm);
                        }
                    } catch (Exception ex) {


                    }

                }

                @Override
                public void onClose(int code, String reason, boolean remote) {
                }

                @Override
                public void onError(Exception ex) {
                }
            };
            webSocketClient.connect();
            return webSocketClient;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
    @Bean
    public WebSocketClient webSocketClient2() {
        try {
            WebSocketClient webSocketClient = new WebSocketClient(
                    new URI("ws://localhost:8080/websocket"), new Draft_6455()) {
                @Override
                public void onOpen(ServerHandshake handshakedata) {
                }

                @Override
                public void onMessage(String message) {
                    try {
                        Alarm alarm = JSONUtil.toBean(message, Alarm.class);
                        alarmMapper.insert(alarm);
                        if(alarm.getType().equalsIgnoreCase("TRAFFIC_INCIDENT_ALARM")) {
                            alarmMapper.insert(alarm);
                        }
                    } catch (Exception ex) {


                    }

                }

                @Override
                public void onClose(int code, String reason, boolean remote) {
                }

                @Override
                public void onError(Exception ex) {
                }
            };
            webSocketClient.connect();
            return webSocketClient;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

}
