package com.cx.cn.cxquartz.config;

import com.cx.cn.cxquartz.service.quartz.TaskService;
import com.cx.cn.cxquartz.vo.TraffrecordData;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.web.client.RestTemplate;

import java.util.List;
import java.util.Map;


@Configuration
@EnableScheduling
public class ScheduleTaskConfig {
    private static final Logger logger = LoggerFactory.getLogger(ScheduleTaskConfig.class);

    @Autowired
    private TaskService taskService;

    @Autowired
    private RestTemplate restTemplate;

    @Scheduled(cron = "*/5 * * * * ?")//每隔5s统计1个小时前到目前为止的数据推送
    private void sendAlarm() {
        try {
        //查询待推送告警信息
        List<TraffrecordData> list=taskService.list();
        if(list.size()>0){
        Map map=restTemplate.getForObject("http://countryside.51iwifi.com/gw/getAccessToken?appid=05744e80b2c211ebe32a8e271066b19e&appsecret=a55a8870b2e911ebe32a8e271066b19e",Map.class);
        if(null!=map.get("code") && map.get("code").toString().equals("0")) {
            Map mapobj = (Map) map.get("obj");
            String accessToken = mapobj.get("accessToken").toString();
            HttpHeaders headers = new HttpHeaders();
            headers.add("accessToken", accessToken);
            headers.setContentType(MediaType.APPLICATION_JSON_UTF8);

            for (TraffrecordData traff : list) {
                if(traff.getFdid().contains("3YSCA450426N3XP")){
                    traff.setTdmc("红菱村河道监控测试点");
                    traff.setXzmc("红菱村");
                    traff.setRecordname("河道监控");
                }
                if(traff.getRecordtype().equals("20")){
                    traff.setRecordtype("1");
                }
                traff.setImagedata("http://zjh189.ncpoi.cc:7180" + traff.getImagedata());
                logger.info(" result:{}", new ObjectMapper().writeValueAsString(traff));
                HttpEntity<TraffrecordData> requestEntity = new HttpEntity<>(traff, headers);

                    Map result = restTemplate.postForObject("http://countryside.51iwifi.com/gw/hesc-mq/hesc/mq/receive/cameraalarm", requestEntity, Map.class);
                      logger.info(" result:{}", new ObjectMapper().writeValueAsString(result));
                    if (null != result.get("code") && result.get("code").toString().equals("0")) {
                        taskService.update(traff.getAlarmnum());
                        logger.info(" send to countryside success");

                    } else {
                        logger.error(" send to countryside error");
                    }
                }
            }
        }
        }  catch (Exception ex){

            logger.error(" send to countryside error:{}",ex);
        }
    }

}
