// All material copyright ESRI, All Rights Reserved, unless otherwise specified.
// See http://js.arcgis.com/3.23/esri/copyright.txt for details.
//>>built
define("esri/layers/Raster","require dojo/_base/declare dojo/_base/lang dojo/_base/Deferred dojo/_base/array dojo/_base/config dojo/json dojo/sniff ../kernel ../Evented ../request ../geometry/Extent ../SpatialReference ../deferredUtils ./PixelBlock ./rasterFormats/LercCodec ./rasterFormats/Lerc2Codec".split(" "),function(D,r,q,u,A,M,E,v,F,G,H,I,J,B,l,K,L){var w,x,t,C,y,m;r=r(G,{declaredClass:"esri.layers.Raster",imageServiceUrl:null,validPixelTypes:"U1 U2 U4 U8 U16 U32 S8 S16 S32 F32".split(" "),
validFormats:"lerc jpeg jpg jpgpng png png8 png24 png32 bip bsq tiff".split(" "),_eventMap:{"raster-read-complete":["pixelData","params"]},constructor:function(a){this.imageServiceUrl=a;this.registerConnectEvents();this._loadRasterFormatModules()},read:function(a,b,c){var e=this,d=new u(B._dfdCanceller);if(10>v("ie"))throw"This browser is not supported.";if(!a.imageServiceParameters)throw"Insufficient parameters to read data";var f=q.clone(a.imageServiceParameters),g=a.pixelType;A.some(this.validPixelTypes,
function(a){return a===g})||(f.pixelType="F32");A.some(this.validFormats,function(a){return a.toLowerCase()===f.format.toLowerCase()})||(f.format="lerc");var h=a.decodeFunc,k;this._prepareGetImageParameters(f);var l=f.width,m=f.height,p=f.extent;delete f.width;delete f.height;delete f.extent;d._pendingDfd=H({url:this.imageServiceUrl+"/exportImage",handleAs:"arraybuffer",content:q.mixin(f,{f:"image"}),load:function(a){e.decode(a,{width:l,height:m,planes:null,pixelType:g,noDataValue:f.noData,format:f.format,
decodeFunc:h}).then(function(a){k={pixelBlock:a,extent:p};e._resolve([k,f],"onRasterReadComplete",b,d)},function(a){e._resolve([a],null,c,d,!0)})},error:function(a){e._resolve([a],null,c,d,!0)}});return d.promise},decode:function(a,b){if(void 0===b||null===b)throw"missing decode options";var c,e;b.format&&(c=b.format.toUpperCase());"BSQ"!==c&&"BIP"!==c&&(c=this._getFormat(a));e=b.decodeFunc;if(void 0===e||null===e)e=this._getFormatDecoderDfd(c);return e(a,b)},onRasterReadComplete:function(){},_prepareGetImageParameters:function(a){if(a.size&&
a.bbox){var b=a.size.split(",");a.width=parseFloat(b[0]);a.height=parseFloat(b[1]);a.extent||(b=a.bbox.split(","),a.extent=new I(parseFloat(b[0]),parseFloat(b[1]),parseFloat(b[2]),parseFloat(b[3]),new J(a.bboxSR)))}else{if(!a.width||Math.floor(a.width)!==a.width||!a.height||Math.floor(a.height)!==a.height)throw"Incorrect Image Dimensions";if(!a.extent||"esri.geometry.Extent"!==a.extent.declaredClass)throw"Incorrect extent";var b=a.extent,c=b.spatialReference.wkid||E.toJson(b.spatialReference.toJson());
delete a._ts;q.mixin(a,{bbox:b.xmin+","+b.ymin+","+b.xmax+","+b.ymax,imageSR:c,bboxSR:c,size:a.width+","+a.height},a.disableClientCaching?{_ts:(new Date).getTime()}:{})}},_adjustExtent:function(a,b,c){var e=a.ymax-a.ymin,d=a.xmax-a.xmin;c>=b?a.ymax=a.ymin+d*b/c:a.xmax=a.xmin+e*c/b;return a},_resolve:function(a,b,c,e,d){b&&this[b].apply(this,a);c&&c.apply(null,a);e&&B._resDfd(e,a,d)},_getFormatDecoderDfd:function(a){var b=null;switch(a){case "LERC":b=this._decodeLerc;break;case "LERC2":b=this._decodeLerc2;
break;case "JPEG":b=this._decodeJpeg;break;case "PNG":b=this._decodePng;break;case "BSQ":b=this._decodeBsq;break;case "BIP":b=this._decodeBip;break;case "TIFF":b=this._decodeTiff;break;default:b=function(a,b){throw"The raster format is not supported";}}b=q.hitch(this,b);return function(c,e){var d=new u;try{var f;"LERC"===a||!0===y?(f=b(c,e),d.resolve(f)):m.then(function(){f=b(c,e);d.resolve(f)})}catch(g){d.reject(g)}return d}},_getFormat:function(a){a=new Uint8Array(a,0,10);var b="";if(255===a[0]&&
216===a[1])b="JPEG";else if(137===a[0]&&80===a[1]&&78===a[2]&&71===a[3])b="PNG";else if(67===a[0]&&110===a[1]&&116===a[2]&&90===a[3]&&73===a[4]&&109===a[5]&&97===a[6]&&103===a[7]&&101===a[8]&&32===a[9])b="LERC";else if(76===a[0]&&101===a[1]&&114===a[2]&&99===a[3]&&50===a[4]&&32===a[5])b="LERC2";else if(-1<String.fromCharCode.apply(null,a).toLowerCase().indexOf("error"))b="ERROR";else if(73===a[0]&&73===a[1]&&42===a[2]&&0===a[3]||77===a[0]&&77===a[1]&&0===a[2]&&42===a[3])b="TIFF";return b},_validateDecodeParams:function(a){if(!a.height||
Math.floor(a.height)!==a.height)throw"Height not provided.";if(!a.width||Math.floor(a.width)!==a.width)throw"Width not provided.";},_decodeJpeg:function(a,b){if(!w)throw"The jpeg decoder module is not loaded.";this._validateDecodeParams(b);var c=(new w).decode(a);if(!z(c,b))throw"The decoded image dimensions are incorrect.";var e=[],d,f;for(d=0;d<c.pixels.length;d++)f=c.pixels[d],e.push(this._calculateBandStatistics(f));return new l({width:c.width,height:c.height,pixels:c.pixels,pixelType:"U8",mask:c.mask,
statistics:e})},_decodePng:function(a,b){if(!x)throw"The png decoder module is not loaded.";this._validateDecodeParams(b);var c=new Uint8Array(a),e=new x(c),c=new Uint8Array(b.width*b.height*4);e.copyToImageData(c,e.decodePixels());for(var d=e=0,f,d=new Uint8Array(b.width*b.height),e=0;e<b.width*b.height;e++)d[e]=c[4*e+3];for(var g=new l({width:b.width,height:b.height,pixels:[],pixelType:"U8",mask:d,statistics:[]}),e=0;3>e;e++){f=new Uint8Array(b.width*b.height);for(d=0;d<b.width*b.height;d++)f[d]=
c[4*d+e];g.addData({pixels:f,statistics:this._calculateBandStatistics(f)})}return g},_decodeBsq:function(a,b){if(!t)throw"The bsq decoder module is not loaded.";this._validateDecodeParams(b);h=b.noDataValue;b.pixelType=p(b.pixelType);var c=t.decodeBSQ(a,{bandCount:b.planes,width:b.width,height:b.height,pixelType:k,noDataValue:h}),e=[],d,f=null;for(d=0;d<c.pixels.length;d++)f=c.pixels[d],e.push(this._calculateBandStatistics(f));return new l({width:b.width,height:b.height,pixels:c.pixels,pixelType:b.pixelType,
mask:c.maskData,statistics:e})},_decodeBip:function(a,b){this._validateDecodeParams(b);h=b.noDataValue;b.pixelType=p(b.pixelType);var c=t.decodeBIP(a,{bandCount:b.planes,width:b.width,height:b.height,pixelType:k,noDataValue:h}),e=[],d,f=null;for(d=0;d<c.pixels.length;d++)f=c.pixels[d],e.push(this._calculateBandStatistics(f));return new l({width:b.width,height:b.height,pixels:c.pixels,pixelType:b.pixelType,mask:c.maskData,statistics:e})},_decodeTiff:function(a,b){this._validateDecodeParams(b);h=b.noDataValue;
b.pixelType=p(b.pixelType);var c=C.decode(a),e=[],d,f=null;for(d=0;d<c.pixels.length;d++)f=c.pixels[d],e.push(this._calculateBandStatistics(f,c.maskData));return new l({width:c.width,height:c.height,pixels:c.pixels,pixelType:c.pixelType,mask:c.maskData,statistics:e})},_decodeLerc:function(a,b){this._validateDecodeParams(b);h=b.noDataValue;b.pixelType=p(b.pixelType);for(var c=0,e,d=0,f,g=a.byteLength-10;d<g;){var n=K.decode(a,{inputOffset:d,encodedMaskData:e,returnMask:0===c?!0:!1,returnEncodedMask:0===
c?!0:!1,returnFileInfo:!0,pixelType:k,noDataValue:h}),d=n.fileInfo.eofOffset;0===c&&(e=n.encodedMaskData,f=new l({width:b.width,height:b.height,pixels:[],pixelType:b.pixelType,mask:n.maskData,statistics:[]}));c++;if(!z(n,b))throw"The decoded image dimensions are incorrect";f.addData({pixels:n.pixelData,statistics:{minValue:n.minValue,maxValue:n.maxValue,noDataValue:n.noDataValue}})}return f},_decodeLerc2:function(a,b){this._validateDecodeParams(b);h=b.noDataValue;b.pixelType=p(b.pixelType);for(var c=
0,e,d,f=0,g,k=a.byteLength-10;f<k;){d=L.decode(a,{inputOffset:f,maskData:e,returnFileInfo:!0});f=d.fileInfo.eofOffset;0===c&&(e=d.maskData,g=new l({width:b.width,height:b.height,pixels:[],pixelType:d.fileInfo.pixelType,mask:d.maskData,statistics:[]}));c++;if(!z(d,b))throw"The decoded image dimensions are incorrect";g.addData({pixels:d.pixelData,statistics:{minValue:d.minValue,maxValue:d.maxValue,noDataValue:d.noDataValue}})}return g},_calculateBandStatistics:function(a,b){var c=Infinity,e=-Infinity,
d=a.length,f,g=0;if(b)for(f=0;f<d;f++)b[f]&&(g=a[f],c=g<c?g:c,e=g>e?g:e);else for(f=0;f<d;f++)g=a[f],c=g<c?g:c,e=g>e?g:e;return{minValue:c,maxValue:e}},_loadRasterFormatModules:function(){y||(m||(m=new u),10>v("ie")?m.isRejected()||m.reject("unsupported browser version"):D(["./rasterFormats/JpgPlus","./rasterFormats/Png","./rasterFormats/Raw","./rasterFormats/TiffDecoder","./rasterFormats/Zlib"],function(a,b,c,e){w=a;x=b;t=c;C=e;y=!0;m.isResolved()||m.resolve(!0)}))}});var k=null,h=null,p=function(a){if("U1"===
a||"U2"===a||"U4"===a||"U8"===a)return h=Math.pow(2,8)-1,k=Uint8Array,"U8";"U16"===a?(h=h||Math.pow(2,16)-1,k=Uint16Array):"U32"===a?(h=h||Math.pow(2,32)-1,k=Uint32Array):"S8"===a?(h=h||0-Math.pow(2,7),k=Int8Array):"S16"===a?(h=h||0-Math.pow(2,15),k=Int16Array):"S32"===a?(h=h||0-Math.pow(2,31),k=Int32Array):k=Float32Array;return a},z=function(a,b){return a.height!==b.height||a.width!==b.width?!1:!0};v("extend-esri")&&q.setObject("layers.Raster",r,F);return r});