// All material copyright ESRI, All Rights Reserved, unless otherwise specified.
// See http://js.arcgis.com/3.23/esri/copyright.txt for details.
//>>built
define("esri/geometry/Polygon","dojo/_base/declare dojo/_base/array dojo/_base/lang dojo/has ../kernel ../lang ../SpatialReference ./Geometry ./Point ./Extent ./mathUtils ../srUtils".split(" "),function(A,q,n,B,r,C,F,D,t,x,u,E){var y={type:"polygon",rings:null},m=A(D,{declaredClass:"esri.geometry.Polygon",constructor:function(a){n.mixin(this,y);this.rings=[];this._ring=0;a&&(n.isArray(a)?this.rings=n.isArray(a[0][0])?a:[a]:a.rings?n.mixin(this,a):this.spatialReference=a,this.spatialReference&&(this.spatialReference=
E.createSpatialReference(this.spatialReference)));this.verifySR()},addRing:function(a){this.clearCache();this._ring=this.rings.length;this.rings[this._ring]=[];n.isArray(a[0])?q.forEach(a,this._addPointArr,this):q.forEach(a,this._addPoint,this);return this},_addPointArr:function(a){this.rings[this._ring].push(a)},_addPoint:function(a){this.rings[this._ring].push([a.x,a.y])},_insertPoints:function(a,b){this.clearCache();this._ring=b;this.rings[this._ring]||(this.rings[this._ring]=[]);q.forEach(a,this._addPoint,
this)},_validateInputs:function(a,b){return null!==a&&void 0!==a&&(0>a||a>=this.rings.length)||null!==b&&void 0!==a&&(0>b||b>=this.rings[a].length)?!1:!0},getPoint:function(a,b){if(this._validateInputs(a,b))return new t(this.rings[a][b],this.spatialReference)},setPoint:function(a,b,c){if(this._validateInputs(a,b))return this.clearCache(),this.rings[a][b]=[c.x,c.y],this},insertPoint:function(a,b,c){if(this._validateInputs(a)&&C.isDefined(b)&&0<=b&&b<=this.rings[a].length)return this.clearCache(),this.rings[a].splice(b,
0,[c.x,c.y]),this},removeRing:function(a){if(this._validateInputs(a,null)){this.clearCache();a=this.rings.splice(a,1)[0];var b,c=a.length,e=this.spatialReference;for(b=0;b<c;b++)a[b]=new t(a[b],e);return a}},removePoint:function(a,b){if(this._validateInputs(a,b))return this.clearCache(),new t(this.rings[a].splice(b,1)[0],this.spatialReference)},getExtent:function(){var a;a=this.getCacheValue("_extent");var b=this.getCacheValue("_partwise");if(a)return a=new x(a),a._partwise=b,a;a=this.rings;var c=
a.length;if(c&&a[0].length){var e,f,d,h,g,k,l,m,p=h=a[0][0][0],z=g=a[0][0][1],v=Math.min,n=Math.max,q=this.spatialReference,b=[],r,t,u,w;for(k=0;k<c;k++){e=a[k];r=t=e[0]&&e[0][0];u=w=e[0]&&e[0][1];m=e.length;for(l=0;l<m;l++)f=e[l],d=f[0],f=f[1],p=v(p,d),z=v(z,f),h=n(h,d),g=n(g,f),r=v(r,d),u=v(u,f),t=n(t,d),w=n(w,f);b.push(new x({xmin:r,ymin:u,xmax:t,ymax:w,spatialReference:q?q.toJson():null}))}a={xmin:p,ymin:z,xmax:h,ymax:g,spatialReference:q?q.toJson():null};b=1<b.length?b:null;this.setCacheValue("_extent",
a);this.setCacheValue("_partwise",b);a=new x(a);a._partwise=b;return a}},contains:function(a){var b=this.rings,c,e=!1,f,d,h,g,k,l,m=b.length;c=this.spatialReference;f=a.spatialReference;var p=a.x;a=a.y;c&&f&&!c.equals(f)&&c._canProject(f)&&(a=c.isWebMercator()?t.lngLatToXY(p,a):t.xyToLngLat(p,a,!0),p=a[0],a=a[1]);for(l=0;l<m;l++)for(c=b[l],h=c.length,k=g=0;k<h;k++)g++,g===h&&(g=0),f=c[k],d=c[g],(f[1]<a&&d[1]>=a||d[1]<a&&f[1]>=a)&&f[0]+(a-f[1])/(d[1]-f[1])*(d[0]-f[0])<p&&(e=!e);return e},getCentroid:function(){var a=
this.getCacheValue("_centroid");if(void 0!==a)return a;var a=this.rings,b,c,e,f,d=[],h,g,k=Infinity,l=-Infinity,m=Infinity,p=-Infinity;q.forEach(a,function(a){b=c=e=0;q.forEach(a,function(d,f){f<a.length-1&&(h=a[f+1],g=d[0]*h[1]-h[0]*d[1],b+=(d[0]+h[0])*g,c+=(d[1]+h[1])*g,e+=g,d[0]<k&&(k=d[0]),d[0]>l&&(l=d[0]),d[1]<m&&(m=d[1]),d[1]>p&&(p=d[1]))});0<e&&(e*=-1);e&&d.push([b,c,e/2])});d.sort(function(a,b){return a[2]-b[2]});b=c=void 0;d[0]&&(f=6*d[0][2],b=d[0][0]/f,c=d[0][1]/f,b<k||b>l||c<m||c>p)&&(b=
c=void 0);if(void 0===b||void 0===c)if(a=a[0]&&a[0].length?this._getLineCentroid(a[0]):null)b=a.x,c=a.y;a=isNaN(b)||isNaN(c)?null:new t(b,c,this.spatialReference);this.setCacheValue("_centroid",a);return a},_getLineCentroid:function(a){var b,c=0,e=0,f=0,d,h,g={x:0,y:0},k={x:0,y:0},l,m=a.length,p;for(l=0;l<m-1;l++)d=a[l],h=a[l+1],d&&h&&(g.x=d[0],g.y=d[1],k.x=h[0],k.y=h[1],b=u.getLength(g,k),0<b&&(c+=b,d=u.getMidpoint(d,h),e+=b*d[0],f+=b*d[1]));0<c?p={x:e/c,y:f/c}:a[0]&&(p={x:a[0][0],y:a[0][1]});return p},
isClockwise:function(a){var b=0,c,e=a.length,f=n.isArray(a[0])?function(a,b){return a[0]*b[1]-b[0]*a[1]}:function(a,b){return a.x*b.y-b.x*a.y};for(c=0;c<e;c++)b+=f(a[c],a[(c+1)%e]);return 0>=b/2},isSelfIntersecting:function(a){a=a||this;var b,c,e,f,d,h,g,k=a.rings.length,l;for(e=0;e<k;e++){for(b=0;b<a.rings[e].length-1;b++)for(d=[[a.rings[e][b][0],a.rings[e][b][1]],[a.rings[e][b+1][0],a.rings[e][b+1][1]]],c=e+1;c<k;c++)for(f=0;f<a.rings[c].length-1;f++)if(h=[[a.rings[c][f][0],a.rings[c][f][1]],[a.rings[c][f+
1][0],a.rings[c][f+1][1]]],(g=u._getLineIntersection2(d,h))&&!(g[0]===d[0][0]&&g[1]===d[0][1]||g[0]===h[0][0]&&g[1]===h[0][1]||g[0]===d[1][0]&&g[1]===d[1][1]||g[0]===h[1][0]&&g[1]===h[1][1]))return!0;f=a.rings[e].length;if(!(4>=f))for(b=0;b<f-3;b++)for(l=f-1,0===b&&(l=f-2),d=[[a.rings[e][b][0],a.rings[e][b][1]],[a.rings[e][b+1][0],a.rings[e][b+1][1]]],c=b+2;c<l;c++)if(h=[[a.rings[e][c][0],a.rings[e][c][1]],[a.rings[e][c+1][0],a.rings[e][c+1][1]]],(g=u._getLineIntersection2(d,h))&&!(g[0]===d[0][0]&&
g[1]===d[0][1]||g[0]===h[0][0]&&g[1]===h[0][1]||g[0]===d[1][0]&&g[1]===d[1][1]||g[0]===h[1][0]&&g[1]===h[1][1]))return!0}return!1},toJson:function(){var a={rings:n.clone(this.rings)},b=this.spatialReference;b&&(a.spatialReference=b.toJson());return a}});m.defaultProps=y;m.createEllipse=function(a){var b=a.center.x,c=a.center.y,e=a.longAxis,f=a.shortAxis,d=a.numberOfPoints,h=a.map,g,k,l;a=[];var n=2*Math.PI/d;for(k=0;k<d;k++)g=Math.cos(k*n),l=Math.sin(k*n),g=h.toMap({x:e*g+b,y:f*l+c}),a.push(g);a.push(a[0]);
b=new m(h.spatialReference);b.addRing(a);return b};m.createCircle=function(a){return m.createEllipse({center:a.center,longAxis:a.r,shortAxis:a.r,numberOfPoints:a.numberOfPoints,map:a.map})};m.fromExtent=function(a){var b=a.normalize();a=a.spatialReference;return new m({rings:q.map(b,function(a){return[[a.xmin,a.ymin],[a.xmin,a.ymax],[a.xmax,a.ymax],[a.xmax,a.ymin],[a.xmin,a.ymin]]}),spatialReference:a?a.toJson():null})};B("extend-esri")&&(n.setObject("geometry.Polygon",m,r),r.geometry.defaultPolygon=
y,r.geometry.createEllipse=m.createEllipse,r.geometry.createCircle=m.createCircle,r.geometry.isClockwise=m.prototype.isClockwise,r.geometry.polygonSelfIntersecting=m.prototype.isSelfIntersecting);return m});