package com.hzjt.domain;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * �Զ�����Ӧ�ṹ
 * @author  cp
 */
public class ResultObj {

    // ����jackson����
    private static final ObjectMapper MAPPER = new ObjectMapper();

    /**
     * ��Ӧҵ��״̬
     * 200	�ɹ�
     * 201	����
     * 400	��������
     */
    private Integer status;

    /**
     * ��Ӧ��Ϣ
     */
    private String msg;

    /**
     * ��Ӧ�е�����
     */
    private Object data;

    public static ResultObj error(Integer status, String msg, Object data) {
        return new ResultObj(status, msg, data);
    }

    public static ResultObj ok(Object data) {
        return new ResultObj(data);
    }

    public static ResultObj ok() {
        return ok(null);
    }

    private ResultObj() {

    }

    public static ResultObj error(Integer status, String msg) {
        return new ResultObj(status, msg, null);
    }

    private ResultObj(Integer status, String msg, Object data) {
        this.status = status;
        this.msg = msg;
        this.data = data;
    }

    private ResultObj(Object data) {
        this.status = 200;
        this.msg = "OK";
        this.data = data;
    }


    /**
     * ��json�����ת��ΪSysResult����
     *
     * @param jsonData json����
     * @param clazz SysResult�е�object����
     * @return SysResult����
     */
    public static ResultObj formatToPojo(String jsonData, Class<?> clazz) {
        try {
            if (clazz == null) {
                return MAPPER.readValue(jsonData, ResultObj.class);
            }
            JsonNode jsonNode = MAPPER.readTree(jsonData);
            JsonNode data = jsonNode.get("data");
            Object obj = null;
            if (data.isObject()) {
                obj = MAPPER.readValue(data.traverse(), clazz);
            } else if (data.isTextual()) {
                obj = MAPPER.readValue(data.asText(), clazz);
            }
            return error(jsonNode.get("status").intValue(), jsonNode.get("msg").asText(), obj);
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * û��object�����ת��
     *
     * @param json �ַ���
     * @return SysResult����
     */
    public static ResultObj format(String json) {
        try {
            return MAPPER.readValue(json, ResultObj.class);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * Object�Ǽ���ת��
     *
     * @param jsonData json����
     * @param clazz �����е�����
     * @return SysResult����
     */
    public static ResultObj formatToList(String jsonData, Class<?> clazz) {
        try {
            JsonNode jsonNode = MAPPER.readTree(jsonData);
            JsonNode data = jsonNode.get("data");
            Object obj = null;
            if (data.isArray() && data.size() > 0) {
                obj = MAPPER.readValue(data.traverse(),
                        MAPPER.getTypeFactory().constructCollectionType(List.class, clazz));
            }
            return error(jsonNode.get("status").intValue(), jsonNode.get("msg").asText(), obj);
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String toString() {
        return "ResultObj{" +
                "status=" + status +
                ", msg='" + msg + '\'' +
                ", data=" + data +
                '}';
    }

    public static ObjectMapper getMAPPER() {
        return MAPPER;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public Object getData() {
        return data;
    }

    public void setData(Object data) {
        this.data = data;
    }
}