package com.hzjt.controller;

import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

/**
 * 路由接口控制器
 *
 * @author tycoding
 * @date 2019-06-13
 */
@Slf4j
@Controller
public class RouterController {
    private static final Logger log = LoggerFactory.getLogger(TraffController.class);
    @Autowired
    private StringRedisTemplate redisTemplate;


    /**
     * 登陆页面
     *
     * @return
     */
    @GetMapping("/")
    public String index() {
        return "login";
    }


    /**
     * 首页入口
     *
     * @return
     */
    @GetMapping("/{id}/chat")
    public String index(@PathVariable("id") String id) {
        return "index";
    }



}
