package com.hzjt.controller;

import com.hzjt.domain.ResultObj;
import com.hzjt.domain.Traffalarmrecord;
import com.hzjt.domain.WriteResultObj;
import com.hzjt.service.EventWriteService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

@RestController
public class EventWriteController {
    @Autowired
    private EventWriteService eventWriteService;


    @PostMapping("/sendEvent")
    public ResultObj sendEvent(Long recordid){
        return eventWriteService.sendEvent(recordid);
    }

    @PostMapping("/sendEvents")
    public List<WriteResultObj> sendEvents(@RequestParam("recordid") String recordid){
        List<Long> longrecorid=new ArrayList<>();
        for(String id:recordid.split(","))
        {
            longrecorid.add(Long.valueOf(id));
        }
        return eventWriteService.sendEvents(longrecorid);
    }

    @GetMapping("/sendEventsByids")
    public List<WriteResultObj> sendEventsByids(){
        List<Long> recordid=new ArrayList<>();
        recordid.add(Long.valueOf(93228));
        recordid.add(Long.valueOf(93834));
        return eventWriteService.sendEvents(recordid);
    }
}
