package com.hzjt.service.impl;

import com.hzjt.domain.Alarm;
import com.hzjt.redis.RedisDao;
import com.hzjt.service.ImportService;
import com.hzjt.util.Constant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import java.util.ArrayList;
import java.util.List;

@Service
public class ImportServiceImpl implements ImportService {
    @Autowired
    RedisDao redisDao;



    @Override
    @Transactional
    public void cleanCache() {
        List<String> keyList = new ArrayList<>(10);
        keyList.add(Constant.failToDBKey);
        keyList.add(Constant.succSizeTempKey);
        keyList.add(Constant.failListKey);
        keyList.add(Constant.failSizeKey);
        keyList.add(Constant.succSizeKey);
        redisDao.cleanCache(keyList);
    }

    /**
     * @Description: 将参数result中的部分数据存入redis中，并把格式校验成功的数据发布至对应频道中
     * @Param: [result]
     * @Retrun: void
     */
    @Override
    @Transactional
    public void cacheAndPublish(String  result) {

        redisDao.setStringKey(Constant.succSizeKey, 1);
        // succSizeTempKey 用于判断消息队列中未消费数据的大小
        redisDao.setStringKey(Constant.succSizeTempKey, 1);
//        redisDao.setStringKey(Constant.successListKey,successList);
        // 发布消息
        redisDao.publish(Constant.receiveSingle, result);
//
//        // 通过校验的数据
//        List<Alarm> successList = result.getList();
//        // 未通过校验的数据
//        List<Alarm> failList = result.getFailList();
//        int succSize = successList.size();
//        int failSize = failList.size();
//        // 将未通过校验的数据存入redis中
//        redisDao.setStringKey(Constant.failListKey, failList);
//        redisDao.setStringKey(Constant.failSizeKey, failSize);
//        // 将通过校验的数据存入redis中
//        redisDao.setStringKey(Constant.succSizeKey, succSize);
//        // succSizeTempKey 用于判断消息队列中未消费数据的大小
//        redisDao.setStringKey(Constant.succSizeTempKey, succSize);
////        redisDao.setStringKey(Constant.successListKey,successList);
//        // 发布消息
//        redisDao.publish(Constant.receiveList, successList);
    }







    /**
     * @Description: 根据key值，返回redis中对应的结果
     * @Param: [key]
     * @Retrun: long
     */
    @Override
    public long getTempSize(String key) {
        return redisDao.getStringValue(key, long.class);
    }




}