package com.hzjt.util;

import com.alibaba.fastjson.JSONObject;
import com.hzjt.domain.DeviceWriteParam;
import com.hzjt.domain.SbtdspsrParam;
import com.hzjt.domain.Traffdevicewriteresult;
import org.apache.commons.lang3.StringUtils;

/**
 * @author chenl
 * @version 1.0
 * @date 2020/3/15 22:13
 *
 *   deviceID;
 *   deviceType;
 *   deviceName;
 *   regionID;
 *   deviceStatus;
 *   deviceSupplier;
 *   dataType;
 *   locationType;
 *   locationX;
 *   locationY;
 *   locationEndX;
 *   locationEndY;
 */
public class TransHelper {
    public static DeviceWriteParam transDevice(SbtdspsrParam sbtdspsr, int dataType){
        DeviceWriteParam param  = new DeviceWriteParam();
        Long sbtdbh = sbtdspsr.getTdbh();
        //豸ID
        param.setDeviceID(sbtdspsr.getSbbh() + ( sbtdbh >= 10 ? sbtdbh : "0" + sbtdbh));
        //豸
        param.setDeviceName(sbtdspsr.getTdmc());
        //豸
        param.setRegionID(sbtdspsr.getXzbh());
        //豸״̬1
        param.setDeviceStatus(1);
        //豸zksyп
        param.setDeviceSupplier(sbtdspsr.getSbcsName());
        //豸ע1
        param.setDataType(dataType);
        //豸JSONַ
        JSONObject jsonObject = JSONObject.parseObject(sbtdspsr.getDeviceconfig());
        //·
        if(jsonObject.get("RoadType")!=null){
            param.setRoadType(Integer.parseInt(jsonObject.get("RoadType").toString()));
        }
        //豸
        if(jsonObject.get("DeviceType")!=null && StringUtils.isNotBlank(jsonObject.get("DeviceType").toString())){
            param.setDeviceType(jsonObject.get("DeviceType").toString());
        }
        //λ÷1-У2-С
        if(jsonObject.get("DeviceDirection")!=null){
            param.setDeviceDirection(Integer.parseInt(jsonObject.get("DeviceDirection").toString()));
        }
        //豸׮
        if(jsonObject.get("StartNumK")!=null){
            param.setStartNumK(Integer.parseInt(jsonObject.get("StartNumK").toString()));
        }
        //豸׮
        if(jsonObject.get("StartNumM")!=null){
            param.setStartNumM(Integer.parseInt(jsonObject.get("StartNumM").toString()));
        }
        //· 磺G1504ƳǸ
        if(jsonObject.get("RoadNum")!=null && StringUtils.isNotBlank(jsonObject.get("RoadNum").toString())){
            param.setRoadNum(jsonObject.get("RoadNum").toString());
        }
        //صơ豸ڵصG15򺣸١̨շվ̨ݷŦ
        if(jsonObject.get("LocationDesc")!=null && StringUtils.isNotBlank(jsonObject.get("LocationDesc").toString())){
            param.setLocationDesc(jsonObject.get("LocationDesc").toString());
        }
        //շվλ
        if(jsonObject.get("Toll")!=null){
            param.setToll(Integer.parseInt(jsonObject.get("Toll").toString()));
        }
        //ڵPOI룬磬XXշվӦ
        if(jsonObject.get("LocationID")!=null && StringUtils.isNotBlank(jsonObject.get("LocationID").toString())){
            param.setLocationID(jsonObject.get("LocationID").toString());
        }
        //ڷλ
        if(jsonObject.get("ServiceArea")!=null){
            param.setServiceArea(Integer.parseInt(jsonObject.get("ServiceArea").toString()));
        }
        //ѵշվλ
        if(jsonObject.get("RampToll")!=null){
            param.setRampToll(Integer.parseInt(jsonObject.get("RampToll").toString()));
        }
        //ѵλ
        if(jsonObject.get("RampServiceArea")!=null){
            param.setRampServiceArea(Integer.parseInt(jsonObject.get("RampServiceArea").toString()));
        }
        //ѵŦתĵ·ùͳһ磺G1504ƳǸ
        if(jsonObject.get("RampHubRoad")!=null && StringUtils.isNotBlank(jsonObject.get("RampHubRoad").toString())){
            param.setRampHubRoad(jsonObject.get("RampHubRoad").toString());
        }
        //ѵŦתĵ·1-У2-
        if(jsonObject.get("RampHubDirection")!=null){
            param.setRampHubDirection(Integer.parseInt(jsonObject.get("RampHubDirection").toString()));
        }

//        param.setLocationType();
//        param.setLocationX();
//        param.setLocationY();
//        param.setLocationEndX();
//        param.setLocationEndY();
        return param;
    }

    public static Traffdevicewriteresult transDeviceWriteResult(SbtdspsrParam sbtdspsr) {
        Traffdevicewriteresult param = new Traffdevicewriteresult();
        param.setSbbh(sbtdspsr.getSbbh());
        param.setTdbh(sbtdspsr.getTdbh());
        return param;
    }

    public static Traffdevicewriteresult transDeviceWriteResult(SbtdspsrParam sbtdspsr, Long pushstatus, String pushdesc) {
        Traffdevicewriteresult param = new Traffdevicewriteresult();
        param.setSbbh(sbtdspsr.getSbbh());
        param.setTdbh(sbtdspsr.getTdbh());
        param.setPushstatus(pushstatus);
        param.setPushcount(1L);
        param.setXzbh(sbtdspsr.getXzbh());
        param.setPushdesc(pushdesc);
        return param;
    }

    public static Traffdevicewriteresult transDeviceWriteResult(SbtdspsrParam sbtdspsr, Long pushstatus, String pushdesc, Long pushcount) {
        Traffdevicewriteresult param = new Traffdevicewriteresult();
        param.setSbbh(sbtdspsr.getSbbh());
        param.setTdbh(sbtdspsr.getTdbh());
        param.setPushstatus(pushstatus);
        param.setPushdesc(pushdesc);
        param.setPushdesc(pushdesc);
        param.setXzbh(sbtdspsr.getXzbh());
        param.setPushcount(pushcount);
        return param;
    }
}
