package com.hzjt.config;


import cn.hutool.json.JSONUtil;
import com.hzjt.domain.*;
import com.hzjt.util.JsonUtil;
import lombok.extern.slf4j.Slf4j;
import oracle.jms.AQjmsAdtMessage;
import oracle.jms.AQjmsDestination;
import oracle.jms.AQjmsFactory;
import oracle.jms.AQjmsSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import javax.jms.*;
import javax.jms.Message;
import javax.jms.Queue;
import java.util.*;
//
@Component
@Slf4j
public class JMS_Oracle implements CommandLineRunner {
    @Autowired
    JmsConfig config;

    @Autowired
    private RestTemplate restTemplate;
//  @Autowired
//  private RestTemplate  restTemplate;

    @Override
    public void run(String... strings) {
        try {
            QueueConnectionFactory queueConnectionFactory = AQjmsFactory.getQueueConnectionFactory(config.getJdbcUrl(),
                    new Properties());
                QueueConnection conn = queueConnectionFactory.createQueueConnection(config.getUsername(), config.getPassword());
                AQjmsSession session = (AQjmsSession) conn.createQueueSession(false, Session.AUTO_ACKNOWLEDGE);
                conn.start();

                Queue queue = (AQjmsDestination) session.getQueue(config.getUsername(), config.getQueueName());
                MessageConsumer consumer = session.createConsumer(queue, null, QUEUE_MESSAGE_TYPE.getFactory(), null, false);

                consumer.setMessageListener(new MessageListener() {
                    @Override
                    public void onMessage(Message message) {
                        AQjmsAdtMessage adtMessage = (AQjmsAdtMessage) message;
                        try {
                            QUEUE_MESSAGE_TYPE payload = (QUEUE_MESSAGE_TYPE) adtMessage.getAdtPayload();
                            //查询traffconfig 的相关信息推送给第三方数据

                            //20200604202047023009_1	rtsp://33.52.1.223:5544/1_20200604202047023009_0_0	rtmp://33.51.6.98:1935/live/room24	http://33.51.6.98/live/room?port=1935&app=live&stream=room24
                            //调用restful 接口直接将数据新增或者更新到python 表中
                            // {"name":"20200305112026668_1","rtsp_address":"rtsp://33.55.1.81:5544/1_20200305112026668_0_0","rtmp_address":"rtmp://33.51.6.98:1935/live/room954","http_flv_address":"http://33.51.6.98/live/room?port=1935&app=live&stream=room954"}

                            String msg = payload.getContent();
                            if (msg.indexOf(",") >= 0) {
                                String videoid = msg.split(",")[0];
                                String rtsp = msg.split(",")[1];
                                HttpHeaders headers = new HttpHeaders();
                                headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
                                //查询监控是否存在
                                PythonQueryResult result = restTemplate.getForObject("http://33.51.6.96:" + 5000 + "/rest/video/query/" + videoid, PythonQueryResult.class);
                                String[][] list = result.getData();

                                Rtsprtmp rtmp = new Rtsprtmp();
                                String id = UUID.randomUUID().toString();
                                rtmp.setHttp_flv_address("http://33.51.6.98/live/room?port=1935&app=live&stream=room" + id);
                                rtmp.setName(videoid);
                                rtmp.setRtsp_address(rtsp);
                                rtmp.setRtmp_address("rtmp://33.51.6.98:1935/live/room" + id);
                                //重新拼接rtsp,rtmp
                                List<Rtsprtmp> rtmplist = new ArrayList<>();
                                rtmplist.add(rtmp);
                                HttpEntity<String> requestEntity = new HttpEntity<>(JSONUtil.toJsonStr(rtmplist), headers);
                                if (null != list && list.length > 0 && list[0].length > 0) {
                                    for (String[] items : list) {
                                        //删除已有的
                                        PythonResult ltObj = restTemplate.getForObject("http://33.51.6.96:" + 5000 + "/rest/video/delete/" + items[0], PythonResult.class);
                                        if (ltObj.getData() != 1 && ltObj.getError() != null) {

                                            log.info(items[0] + "删除失败" + videoid + "rtsp=" + rtsp + "error");
                                        }
                                    }
                                    PythonResult result1 = restTemplate.postForObject("http://33.51.6.96:" + 5000 + "/rest/video/add", requestEntity, PythonResult.class);
                                    if (null != result1.getError()) {
                                        log.info(videoid + "rtsp=" + rtsp + "error");
                                    }
                                } else {
                                    PythonResult result2 = restTemplate.postForObject("http://33.51.6.96:" + 5000 + "/rest/video/add", requestEntity, PythonResult.class);
                                    if (null != result2.getError()) {
                                        log.info(videoid + "rtsp=" + rtsp + "error");
                                    }
                                }
                            }

                        } catch (Exception e) {
                            log.info("rtsp=error" + e.toString());
                        }
                    }
                });
        } catch (Exception e) {
            log.info("rtsp=error" + e.toString());
        }
    }
}

