package com.hzjt.controller;

import cn.hutool.core.codec.Base64Encoder;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.util.concurrent.RateLimiter;
import com.hzjt.config.MQTTSubsribe;
import com.hzjt.domain.*;
import com.hzjt.handler.FileTransferManager;
import com.hzjt.handler.WebSocket;
import com.hzjt.mapper.SbtdspsrMapper;
import com.hzjt.mapper.TraffAlarmRecordMapper;
import com.hzjt.redis.RedisDao;
import com.hzjt.service.*;
import com.hzjt.util.*;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.tomcat.util.http.fileupload.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.bind.annotation.*;
import sun.net.www.protocol.ftp.FtpURLConnection;

import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.websocket.server.PathParam;
import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;


@RestController
@Slf4j
public class TraffController {
    @Autowired
    ImportService importService;

    @Autowired
    WebSocket webSocket;

    private Map<String, RateLimiter> rateLimiterMap;
    private String port;
    private String dept;
    private Integer rate = 10;
    private SbtdspsrMapper sbtdspsrMapper;

    @Autowired
    TraffFlowService traffFlowService;

    @Value("${flv.resisvalue}")
    private String resisvalue;

    @Value("${json.resisurl}")
    private String resisjsonvalue;

    @Value("${ftppath}")
    private String ftppath;
    @Value("${ftpServiceUrl}")
    private String ftpServiceUrl;


    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    @Autowired
    RedisDao redisDao;

    @Autowired
    private TraffAlarmRecordMapper traffAlarmRecordMapper;

    @Autowired
    FtpService ftpService;

    @Autowired
    EventWriteService eventWriteService;
    @Value("ftpIp")
    String ftpIp;
    @Value("ftpPort")
    private String ftpPort;
    @Value("ftpUsername")
    private String ftpUsername;
    @Value("ftpPassword")
    private String ftpPassword;
    @Value("${alarmrecord.check.enable}")
    private String checkEnable;
    Long ldir = new Long(180);
    @Autowired
    FLVCacheService flvCacheService;

//    @Autowired
//    private SimpMessagingTemplate template;


    @Autowired
    MQTTSubsribe mQTTSubsribe;

    String  manualStatus="0";
    private static final String TYPE = "TRAFFIC_INCIDENT_ALARM";

    ScheduledExecutorService schedulepool = Executors.newScheduledThreadPool(5); //创

    @Autowired
    public TraffController(
            @Value("${port}") String port,
            @Value("${message.dept}") String dept,
            @Value("${message.rate}") Integer rate, SbtdspsrMapper sbtdspsrMapper) {

        this.port = port;
        this.rate = rate;
        this.dept = dept.substring(0, 5);
        this.sbtdspsrMapper = sbtdspsrMapper;
        rateLimiterMap = new ConcurrentHashMap<>(16);
    }

    /**
     * 被@PostConstruct修饰的方法会在服务器加载Servlet的时候运行，并且只会被服务器执行一次。
     * PostConstruct在构造函数之后执行，init（）方法之前执行。PreDestroy（）方法在destroy（）方法知性之后执行
     * 这里初始化订阅一个主题
     */
    @PostConstruct
    public void init() {
        System.out.println(DateUtils.formatDate(new Date(Long.valueOf("1624331555000"))));
        //查询素有videowbbh
        List<String> sbbhlist=  sbtdspsrMapper.selectAllWbbh();
        mQTTSubsribe.subscribe(sbbhlist);

    }

    @PostMapping("/alarmevent")
    public ResultObj rece(@RequestBody Alarm trffClientMessage) {
//    log.info("alarmevent--------------"+trffClientMessage.toString());
        if (!TYPE.equals(trffClientMessage.getType())) {
            return ResultObj.error(ResponseEnum.E_1002.getCode(), "type类型不正确");
        }

        if (trffClientMessage.getImg_urls().isEmpty()) {
            return ResultObj.error(ResponseEnum.E_1004.getCode(), "img_urls值不能为空");
        }
        if (StringUtils.isBlank(trffClientMessage.getIncident_type())) {
            log.info("incident_type值不能为空" + trffClientMessage.toString());
            return ResultObj.error(ResponseEnum.E_1004.getCode(), "incident_type值不能为空");
        }
        String videoId = trffClientMessage.getVideo_id();

        if (StringUtils.isBlank(videoId)) {
            log.info("video_id值异常 值为:" + videoId);
            return ResultObj.error(ResponseEnum.E_1002.getCode(), "video_id值异常 值为:" + videoId);
        }

        String sbbh="";
        int tdbh=0;
//        if( videoId.contains("_") && videoId.split("_").length == 2) {
//            String[] sbAndTd = videoId.split("_");
//            sbbh = sbAndTd[0];
//            tdbh = Integer.valueOf(sbAndTd[1]) + 1;
//        }
//        else {
            sbbh=videoId;
            tdbh=0;
//        }
        List<Sbtdspsr> sbtdspsrs = sbtdspsrMapper.selectBySbbh(sbbh, tdbh);
        if (sbtdspsrs.isEmpty()) {
            log.info("设备为:" + sbbh + ",通道为:" + tdbh + "未录入(备案)");
            return ResultObj.error(ResponseEnum.E_1002.getCode(), "设备为:" + sbbh + ",通道为:" + tdbh + "未录入(备案)");
        }
        String xzbh = sbtdspsrs.get(0).getXzbh();
        if (xzbh.length() != 12) {
            log.info("设备为:" + sbbh + ",通道为:" + tdbh + "配置的行政区划" + xzbh + "不合规");
            return ResultObj.error(ResponseEnum.E_1002.getCode(), "设备为:" + sbbh + ",通道为:" + tdbh + "配置的行政区划不合规");
        }

        trffClientMessage.setDept(xzbh);
        //判断是否需要手动筛选
        manualStatus=traffAlarmRecordMapper.seletManualStatus();
        log.info("是否手动推送 manualStatus"+manualStatus);
        if(manualStatus.equalsIgnoreCase("0")) {
            log.info("send to gaoxin");
            //手动 推送给高信
            webSocket.GroupSending(JsonUtil.beanToString(trffClientMessage));
        }



        try { // 清空redis中的部分旧数据
//            importService.cleanCache();
            // 将参数result中的部分数据存入redis中，并把格式校验成功的数据发布至对应频道中
//            importService.cacheAndPublish(JsonUtil.beanToString(trffClientMessage));
            sendevent(trffClientMessage,sbtdspsrs.get(0).getWbbh());
        } catch (Exception e) {
            log.error("MessageController receive putData error：" + e.toString());
        }
        return ResultObj.ok(trffClientMessage);
    }

    public void sendevent(Alarm trffClientMessage,String wbbh) {

        Traffalarmrecord traffAlarmRecord = new Traffalarmrecord();
        traffAlarmRecord.setAreaid(Long.valueOf(trffClientMessage.getDept()));
        traffAlarmRecord.setRecordtype(trffClientMessage.getIncident_type().toLowerCase());
        traffAlarmRecord.setRecordtime(new Date(Long.valueOf(trffClientMessage.getTs())));
        Integer channelid=Integer.valueOf(0);
//        if(trffClientMessage.getVideo_id().contains("_")&& trffClientMessage.getVideo_id().split("_").length == 2) {
//            String[] videoIdArr = trffClientMessage.getVideo_id().split("_");
//            traffAlarmRecord.setFdid(videoIdArr[0]);
//            channelid = Integer.valueOf(videoIdArr[1]) + 1;
//        }
//        else{
            traffAlarmRecord.setFdid(trffClientMessage.getVideo_id());
            channelid=0;
//        }
        traffAlarmRecord.setChannelid(channelid);

        //判断是否在正检时间内
        //int exists = traffAlarmRecordMapper.selectInChecktimeTraffAlarm(traffAlarmRecord);

//        log.info("selectInChecktimeTraffAlarm" + exists);
        //if (exists > 0) {
         //   return;
       // }

        traffAlarmRecord.setVideourlfrom(trffClientMessage.getVideo_record_url());
        traffAlarmRecord.setCreatetime(new Date());
        traffAlarmRecord.setObjlable(trffClientMessage.getObjLabel());
        traffAlarmRecord.setPushstatus(9);//设置为未推送

////        log.info("selectInworkRectifytimeTraffAlarm" + exists);
//        if ((traffAlarmRecord.getRecordtype().equalsIgnoreCase("roadworks_out_of_line") || traffAlarmRecord.getRecordtype().equalsIgnoreCase("roadworks"))) {
//
//            //支持对某一个点位报施工事件后 倒推RECTIFYTIME 查看是否是施工事件 一段时间（时间可以配置）之前的停车事件和行人闯入事件矫正为施工事件
//            exists = traffAlarmRecordMapper.updateInworkRectifytimeTraffAlarm(traffAlarmRecord);
//            //这个事件如果为停车事件或者行人闯入事件时，设置纠偏状态为1
//            if (exists > 0) {
//                log.info("setRectificationtype=1");
//            }
//
//        }

        List<String> imgBase64List = trffClientMessage.getImg_base64();
        String imgEnumHead = "IMG";
        Ftp ftp = ftpService.reloadFtp();
        for (int i = 0; i < imgBase64List.size(); i++) {
            /* 图片上传 */
            String path = trffClientMessage.getVideo_id() + "/" + DateUtils.formatCurrDayNoSign();
            String fileName = UUIDUtils.createuuid() + ".jpg";
            if (FTPUtil.uploadFile(ftp, path, fileName, imgBase64List.get(i))) {
                TraffAlarmRecordImgEnum.valueOf(imgEnumHead + i).setImg(traffAlarmRecord, FTPUtil.getFtpUrl(ftp) + path + "/" + fileName);
            }
        }
        List<String> imgUrls = trffClientMessage.getImg_urls();
        for (int i = 0; i < imgUrls.size(); i++) {
            TraffAlarmRecordFromImgEnum.valueOf(imgEnumHead + i).setImg(traffAlarmRecord, imgUrls.get(i));
        }

        if (StringEnum.ONE.getValue().equals(checkEnable)) {
            /* 9:免审 */
            traffAlarmRecord.setCheckstatus(9);
        }

        int recordid = traffAlarmRecordMapper.selectmax();
        traffAlarmRecord.setRecordid((long) (recordid));
        //发送给前端
        Map map = new HashMap();

            if(manualStatus.equalsIgnoreCase("1")) {
                map.put("type", "recordalarm");
                traffAlarmRecord.setManualstatus(0);

            }else {
            map.put("type", "alarm");
            traffAlarmRecord.setManualstatus(1);
        }

        map.put("data", trffClientMessage);
        map.put("recordid", recordid);
        webSocket.GroupSending(JsonUtil.beanToString(map));

        traffAlarmRecord.setProcessstatus("0");
        traffAlarmRecordMapper.inserTraffAlarmRecord(traffAlarmRecord);

        try {
            String basepath = "gstraff/" + traffAlarmRecord.getFdid() + (traffAlarmRecord.getChannelid() < 10 ? "0" + traffAlarmRecord.getChannelid() : traffAlarmRecord.getChannelid()) + "/" + DateUtils.formatCurrDayNoSign();
            Map<String, Object> transferRecordMap = new HashMap<>();
            FileTransferManager.fetchUrlsFromRecord(traffAlarmRecord, transferRecordMap);
            List<TransferResult> results = FileTransferManager.transferFile(transferRecordMap, ftp, basepath);
//            log.info("缓存数据上传结果：" + results.toString());
            Traffalarmrecord recordBak = FileTransferManager.traffAlarmRecordUrlUpdate(results);
            traffAlarmRecord.setImg2path(recordBak.getImg2path());
            traffAlarmRecord.setImg3path(recordBak.getImg3path());
            traffAlarmRecord.setImg4path(recordBak.getImg4path());
            traffAlarmRecord.setImg5path(recordBak.getImg5path());
            traffAlarmRecord.setVideopath(recordBak.getVideopath());

            if (traffAlarmRecord != null && traffAlarmRecord.getRecordid() != null) {
                traffAlarmRecordMapper.updateTraffAlarmRecordUrl(traffAlarmRecord);
            }

            //如果监控视频为空，延时加载重新获取
            if (null == recordBak.getVideopath() || "".equalsIgnoreCase(recordBak.getVideopath())) {

                schedulepool.schedule(() -> {
                    for (String key : transferRecordMap.keySet()) {
                        if (key.equals("videopath")) {
                            final String url = transferRecordMap.get(key).toString();
                            try {
                                HttpURLConnection connection = (HttpURLConnection) new URL(url).openConnection();
                                //延迟连接
                                connection.setReadTimeout(2000);
                                connection.setConnectTimeout(3000);
                                connection.setRequestMethod("GET");
                                String pname = DateUtils.formatCurrDayNoSign() + "_" + recordid + "_0000_" + key.replace("path", "");
                                String fileName = pname + ".mp4";
                                String ftputl = FTPUtil.getFtpUrl(ftp) + basepath + "/" + fileName;
                                if (connection.getResponseCode() == HttpURLConnection.HTTP_OK) {
                                    InputStream inputStream = connection.getInputStream();
                                    log.info("url:", url, " --- " + "key:", key);
                                    boolean r = FTPUtil.uploadFile(ftp, basepath, fileName, inputStream);
                                    if (r) traffAlarmRecord.setVideopath(ftputl);
                                    //只更新监控
                                    if (traffAlarmRecord != null && traffAlarmRecord.getRecordid() != null) {
                                        traffAlarmRecordMapper.updateTraffAlarmRecordUrl(traffAlarmRecord);
                                        log.info("send to mqtt  video is not  empty");
                                        sendtomqtt(trffClientMessage, wbbh, traffAlarmRecord);
//                                        //推送给第三方
//                                        if(!manualStatus.equalsIgnoreCase("1")) {
//                                            ResultObj obj = eventWriteService.updateAndAutoSendEvent(traffAlarmRecord);
//                                        log.info("send to guangda:HTTP_OK" + obj.toString());
//                                        }
                                    }
                                }
                                else {
//                                    ResultObj obj = eventWriteService.updateAndAutoSendEvent(traffAlarmRecord);
                                    log.info("send to mqtt  video is  empty");
                                    sendtomqtt(trffClientMessage, wbbh, traffAlarmRecord);

                                }
                            } catch (IOException e) {
                                System.out.println(e.toString());
                                log.error(e.toString());
                                return 0;
                            }
                        }

                    }
                    return 1;
                }, 50, TimeUnit.SECONDS); //等待50秒钟执行


            } else {
                //需要先过滤，过滤结束后推送给第三方
//                if(!manualStatus.equalsIgnoreCase("1")) {
//                    ResultObj obj = eventWriteService.updateAndAutoSendEvent(traffAlarmRecord);
//                   log.info("send to guangda novideopath --->response message" + obj.toString());
//                }

            }



            traffAlarmRecord.setPushdesc("推送结束");
            traffAlarmRecord.setPushstatus(0);
            traffAlarmRecordMapper.updatePushEvent(traffAlarmRecord);
        } catch (Exception e) {
            log.error("alarm fail :" + e.toString());
        }
    }

    private void sendtomqtt(Alarm trffClientMessage, String wbbh, Traffalarmrecord traffAlarmRecord) {
        if(null==wbbh || "".equals(wbbh))
        {
            log.info("设备为:" + traffAlarmRecord.getFdid() + ",wbbh" + " is empty");
        }
        else {//mqtt 推送给第三方
            MqttAlarm mqttalarm = new MqttAlarm();
            //查询事件类型mqtt 对应的编号
            String mqttbh = traffAlarmRecordMapper.seletmqttbh(trffClientMessage.getIncident_type());
            mqttalarm.setAlarmTime(DateUtils.formatDate(new Date(Long.valueOf(trffClientMessage.getTs()))));
            mqttalarm.setCompanyId("66211");
            //设置图片
            mqttalarm.setImagePath(traffAlarmRecord.getImg1path()==null?"":ftpServiceUrl+"?location="+traffAlarmRecord.getImg1path().replace("ftp://"+ftppath+"/",""));
            mqttalarm.setVideoPath(traffAlarmRecord.getVideopath()==null?"":ftpServiceUrl+"?location="+traffAlarmRecord.getVideopath().replace("ftp://"+ftppath+"/",""));
            mqttalarm.setDeviceId(wbbh);
            if (null != trffClientMessage.getObj_location()) {
                mqttalarm.setX(trffClientMessage.getObj_location().get("x") == null ? null : trffClientMessage.getObj_location().get("x").toString());
                mqttalarm.setY(trffClientMessage.getObj_location().get("y") == null ? null : trffClientMessage.getObj_location().get("y").toString());
                mqttalarm.setWidth(trffClientMessage.getObj_location().get("width") == null ? null : trffClientMessage.getObj_location().get("width").toString());
                mqttalarm.setHeight(trffClientMessage.getObj_location().get("height") == null ? null : trffClientMessage.getObj_location().get("height").toString());
            }
            mqttalarm.setEventTypeId(mqttbh);
            log.info("mqtt data========"+ JSONUtil.toJsonStr(mqttalarm));
            mQTTSubsribe.publishMessage("event/" + wbbh + "/videoEvent", JsonUtil.beanToString(mqttalarm));

        }
    }

    private RateLimiter getRateLimiter(String videoId) {
        RateLimiter rateLimiter;
        if (rateLimiterMap.containsKey(videoId)) {
            rateLimiter = rateLimiterMap.get(videoId);
        } else {
            RateLimiter value = RateLimiter.create(rate);
                rateLimiter = rateLimiterMap.putIfAbsent(videoId, value);
            if (rateLimiter == null) {
                rateLimiter = value;
            }
        }
        return rateLimiter;
    }


    //车流量推送
    @PostMapping("/traffflow")
    public ResultObj traffflow(@RequestBody Vehicles vehicles) {

        if ("TRAFFIC_STATISTICS_VEHICLES".equalsIgnoreCase(vehicles.getType())) {
            String sbbh="";
            int tdbh=0;
            if(vehicles.getVideo_id().contains("_") && vehicles.getVideo_id().split("_").length == 2) {
                String[] sbAndTd = vehicles.getVideo_id().split("_");
                 sbbh = sbAndTd[0];
                 tdbh = Integer.valueOf(sbAndTd[1]) + 1;
            }
            else {
                sbbh=vehicles.getVideo_id();
            }
            //重置videoid
            vehicles.setVideo_id(sbbh + "_" + tdbh);
            //直接放入表中
            List<Vehiclesdetail> vels = vehicles.getObjs();
            for (Vehiclesdetail detail : vels) {
                Vehicle v = new Vehicle();
                v.setId(UUID.randomUUID().toString());
                v.setCreate_time(new Date(Long.valueOf(vehicles.getTs())));
                v.setType(detail.getType());
                v.setDirection(detail.getDirection());
                v.setRuleTag(detail.getRuleTag());
                v.setClassification_confidence(detail.getClassification_confidence());
                v.setVideo_id(vehicles.getVideo_id());
                traffFlowService.saveTraffFlowDetail(v);


            }
            //查询近五分钟的车流量，当天车流量websocket  直接推送过去
//            log.info("fivevehivle");
            //根据连接的name ，群发根据videoid  查询的结果
            webSocket.GroupSendingByVideoid(vehicles.getVideo_id());
        }
        return ResultObj.ok();
    }


    //获取自动规则
    @PostMapping("/autoRule")
    public ResultObj autoRule(@RequestBody AutoRule rules) {
        Map map = new HashMap();
        map.put("type", "rule");
        map.put("data", rules);
        webSocket.AppointSending(rules.getVideo_id(), JsonUtil.beanToString(map));
        return ResultObj.ok();
    }



    //获取flv地址
    @GetMapping("/getflv/{videoid}")
    public String getflv(@PathVariable("videoid") String videoid) {
        //根据id查询对应的rtsp
        String rtsp = traffFlowService.selectSbtddspsrRtspByVideoid(videoid);
        //huode  resid 中值、

        if (null != rtsp) {
            if (null == stringRedisTemplate.opsForValue().get(videoid)) {
//                log.info("flv-----");
                flvCacheService.getvalue(videoid, rtsp);
            }
//            log.info(stringRedisTemplate.opsForValue().get(videoid));
            JSONObject jsonObject = JSONObject.parseObject(stringRedisTemplate.opsForValue().get(videoid));

            if (null != jsonObject.getJSONArray("play_list") && jsonObject.getJSONArray("play_list").size() > 0) {
                return String.valueOf(jsonObject.getJSONArray("play_list").get(0));
            }

        }
        return "";


    }

    //自动车流量推送
    @PostMapping("/autotraffflow")
    public ResultObj autotraffflow(@RequestBody AutoVehicles vehicles) {

//        log.info("autotraffflow"+vehicles.toString());
        if ("TRAFFIC_STATISTICS_VEHICLES".equalsIgnoreCase(vehicles.getType())) {
            String[] sbAndTd = vehicles.getVideo_id().split("_");
            String sbbh = sbAndTd[0];
            int tdbh = Integer.valueOf(sbAndTd[1]) + 1;
            //重置videoid
            vehicles.setVideo_id(sbbh + "_" + tdbh);
            //直接放入表中
            List<AutoVehiclesdetail> vels = vehicles.getObjs();
            int result = 0;

            for (AutoVehiclesdetail detail : vels) {
                Vehicle v = new Vehicle();
                v.setId(UUID.randomUUID().toString());
                v.setCreate_time(new Date(Long.valueOf(vehicles.getTs())));
                v.setType(detail.getType());
                v.setDirection(detail.getDirection());
                v.setRuleTag(detail.getDirection().longValue()<=ldir.longValue()?"1":"2");
                v.setClassification_confidence(detail.getClassification_confidence());
                v.setVideo_id(vehicles.getVideo_id());
                result = traffFlowService.saveTraffFlowDetail(v);
            }
            //查询近五分钟的车流量，当天车流量websocket  直接推送过去
            //根据连接的name ，群发根据videoid  查询的结果
            webSocket.GroupSendingByVideoid(vehicles.getVideo_id());
        }
        return ResultObj.ok();
    }

    //车流量推送
    @GetMapping("/sendtouser/{recordid}")
    @ResponseBody
    public Integer sendtouser(@PathVariable("recordid") String  recordid) {
        //查询该信息
        Traffalarmrecord traffalarmrecord = traffAlarmRecordMapper.selectByPrimaryKey(recordid);
        if(traffalarmrecord==null) return 0;
        Alarm alarm=new Alarm();
        Base64Encoder base64Encoder=new Base64Encoder();
        alarm.setTs(Long.toString(traffalarmrecord.getRecordtime()==null?new Date().getTime():traffalarmrecord.getRecordtime().getTime()));
        alarm.setDept(traffalarmrecord.getAreaid()==null?null:Long.toString(traffalarmrecord.getAreaid()));
        alarm.setVideo_id(traffalarmrecord.getFdid()+"_"+traffalarmrecord.getChannelid());
        alarm.setIncident_type(traffalarmrecord.getRecordtype());
        List<String> strImgs=new ArrayList<>();
        if(traffalarmrecord.getImg1path() != null ){
            byte[]  Img=FTPUtil.getFtpPicBytes(traffalarmrecord.getImg1path());
            strImgs.add(Img!=null?base64Encoder.encode(Img) : null);
        }

        if(traffalarmrecord.getImg2path() != null ){
            byte[]  Img=FTPUtil.getFtpPicBytes(traffalarmrecord.getImg2path());
            strImgs.add(Img!= null ? base64Encoder.encode(Img) : null);
        }
        if(traffalarmrecord.getImg3path() != null ) {
            byte[] Img = FTPUtil.getFtpPicBytes(traffalarmrecord.getImg3path());
            strImgs.add(Img != null ? base64Encoder.encode(Img) : null);

        }
        if(traffalarmrecord.getImg4path() != null ) {
            byte[] Img = FTPUtil.getFtpPicBytes(traffalarmrecord.getImg4path());
            strImgs.add(Img != null ? base64Encoder.encode(Img) : null);
        }
        if(traffalarmrecord.getImg5path() != null ) {
            byte[] Img = FTPUtil.getFtpPicBytes(traffalarmrecord.getImg5path());
            strImgs.add(Img != null ? base64Encoder.encode(Img) : null);
        }

        alarm.setImg_base64(strImgs);
        Map  map=new HashMap();
        //websocket  推送给客户
        map.put("type", "alarm");
        map.put("data", alarm);
        map.put("recordid", recordid);
        webSocket.GroupSending(JsonUtil.beanToString(map));

        try {
            //推送给第三方
            ResultObj obj = eventWriteService.updateAndAutoSendEvent(traffalarmrecord);
            log.info("send to guangda novideopath --->response message" + obj.toString());

            if (obj.getStatus() == 200) {
                return 1;
            } else {
                return 0;

            }

        }catch (Exception  ex){
            log.info("send to guangda novideopath --->response error" + ex.toString());

            return 1;

        }



    }



    //车流量推送
    @GetMapping("/test")
    @ResponseBody
    public void test() {
        String  manualStatus=traffAlarmRecordMapper.seletManualStatus();
        Alarm alarm=new Alarm();
        alarm.setVideo_id("33_65_230_156_554_fbXdTkVe98u_ecvs_0");
        alarm.setIncident_type("NO_MOTOR_BAN");
        String   str="iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAB1UlEQVRIS5WVjTEEQRBG30WACBABGSACLgJEgAicCBABIkAEiIAMkAERUG9remtua2Z3rquuam935nvTPf0zY9y2gENgH/B5Ny3/AL6AV+A5PReVZhV9xS6Bk/RdEUVzE7qXXtwDVyVQCaDoNeC3m/T7qRxkHThPvz9gnrzqlw8Bi3RyTyyoJjzkCTJcO8ApoEed5QAF74CHLDRDofwOShA9PgYOwpMAGPN34A04Grl3T6kZ/5KFJ5vAthEIgC4pLGgsLFMAoWp8pktfCFh6MZG2LQAlPLDpvS3ALDBrNhoutRUQh54LcJNhGYt9ONYKcH1XiAJ80CVTdMpWATwB6wIsEKswALpnupZsLE1dfwsorKl3WAP0hTKgCDcFTeeSWQc5YF+APcaXLSGKSq/1sBzah6h7GCmefNMqgP6SV0nTVsBSmq5SaK2A6AxdFi1V3kSxtQDMNPtal5l5s/Oy7SF2wlo/EmBIvbOS+f4ldQVBfbNzsR3Sj7p3UYG4yZBGKuaQELeLqtVNwGG6xUzwo9PJTGgxwY/p5HpYHDghJN0TrqVxaXXWQAqfpQH1nfrZ0uyuFUw+awUJcGNsVjjC9Ts2u6cqMgowhpH/IwGE2fxK99GH9R91mncY+HKoHAAAAABJRU5ErkJggg==";
        List arrlist=new ArrayList();
        arrlist.add(str);
        arrlist.add(str);
        arrlist.add(str);
        arrlist.add(str);
        arrlist.add(str);
        alarm.setImg_base64(arrlist);
        alarm.setTs("1345677777");
        alarm.setType("TRAFFIC_INCIDENT_ALARM");
        Map  map=new HashMap();
        map.put("type", "alarm");
        map.put("data", alarm);
        map.put("recordid", "33448");
        webSocket.GroupSending(JsonUtil.beanToString(map));
        Traffalarmrecord traffAlarmRecord=new  Traffalarmrecord();
        traffAlarmRecord.setRecordid(Long.parseLong("33448"));
        traffAlarmRecord.setChannelid(new Integer(1));
        traffAlarmRecord.setFdid("20200305112042989");
        traffAlarmRecord.setRecordtype("NO_MOTOR_BAN");

//        traffAlarmRecordMapper.inserTraffAlarmRecord(traffAlarmRecord);

        map.put("recordid", "33449");
        webSocket.GroupSending(JsonUtil.beanToString(map));
        Traffalarmrecord traffAlarmRecord2=new  Traffalarmrecord();
        traffAlarmRecord2.setRecordid(Long.parseLong("33449"));
        traffAlarmRecord2.setChannelid(new Integer(1));
        traffAlarmRecord2.setFdid("20200305112042989");
        traffAlarmRecord2.setRecordtype("WRONG_DIRECTION");

//        traffAlarmRecordMapper.inserTraffAlarmRecord(traffAlarmRecord2);
    }

    //事件推送
    @GetMapping("/testevent")
    @ResponseBody
    public void testevent() {
        String json="{"+
                "            \"type\": \"TRAFFIC_INCIDENT_ALARM\"," +
                "                \"id\": \"d9a2b0f0-f0cf-49b9-9b64-3da86a122afa\"," +
                "                \"video_id\": \"201809180950119121_0\"," +
                "                \"ts\": \"1544602970458\"," +
                "                \"incident_type\": \"WRONG_DIRECTION\"," +
                "                \"img_urls\": [" +
                "            \"http://192.168.1.3:8001/api/alg/files/1535740000-test\",\n" +
                "                    \"http://192.168.1.3:8001/api/alg/files/1535740000-test2\"," +
                "                    \"http://192.168.1.3:8001/api/alg/files/1535740000-test3\"," +
                "                    \"http://192.168.1.3:8001/api/alg/files/1535740000-test4\"," +
                "                    \"http://192.168.1.3:8001/api/alg/files/1535740000-test5\"" +
                "    ]," +
                "            \"video_record_url\": \"http://192.168.1.3:8001/api/alg/files/1576459828-test\"," +
                "                \"obj_location\": {" +
                "            \"x\": 0.1,\n" +
                "                    \"y\": 0.2," +
                "                    \"width\": 0.4," +
                "                    \"height\": 0.7" +
                "        }," +
                "            \"img_base64\": [\"d0xEMHcFAESwdwaUjWDqB6/1Qw4LapAiSICVTOFWsGT0sgt\"]\n" +
                "        }";

        MqttAlarm  alarm=new MqttAlarm();

        alarm.setHeight("0.7");
        alarm.setWidth("0.7");
        mQTTSubsribe.publishMessage("event/1111/videoEvent", JSONUtil.toJsonStr(alarm));
    }

    @GetMapping("/api/alg/files")
    protected void fielagent(@RequestParam("location") String location, HttpServletRequest request, HttpServletResponse response) {
        long startTime = System.currentTimeMillis();
        //ftp://reader:reader@33.50.1.22:21/
        //ftp.host=33.65.250.179:21:hzjt:1qaz2wsx
        String ftpPath="ftp://"+ftppath+"/"+location;
        FileInputStream hFile = null;
        OutputStream toClient = null;
        InputStream inputStream = null;
        BufferedInputStream bis = null;
        try {
            response.reset();
            response.setHeader("Expires", "Sat, 10 May 2059 12:00:00 GMT");
            response.setHeader("Cache-Control", "max-age=315360000");

            if (StringUtils.isNotBlank(ftpPath)) {
                if (ftpPath.endsWith(".jpg") || ftpPath.endsWith(".JPG") || ftpPath.endsWith(".png") || ftpPath.endsWith(".PNG") || ftpPath.endsWith(".gif") || ftpPath.endsWith(".GIF")) {
                    response.setContentType("image/" + ftpPath.substring(ftpPath.lastIndexOf(".") + 1) + "; charset=utf-8");
                } else if (ftpPath.endsWith(".mp4") || ftpPath.endsWith(".MP4")) {
                    response.setContentType("video/mpeg4; charset=utf-8");
                    String mp4file = ftpPath.substring(ftpPath.lastIndexOf("/") + 1);
                    response.setHeader("Content-Disposition", "attachment;fileName=" + mp4file);
                }

                String destUrl = ftpPath;
                destUrl = new String(destUrl.getBytes("ISO8859-1"), "GBK");
                String[] arr = destUrl.split(";");
                FtpURLConnection ftpUrl = null;
                HttpURLConnection httpUrl = null;
                for (int i = 0; i < arr.length; i++) {
                    try {
                        URL url = new URL(arr[i]);
                        if (arr[i].toUpperCase().indexOf("FTP") != -1) { // ftp
                            ftpUrl = (FtpURLConnection) url.openConnection();
                            ftpUrl.setConnectTimeout(30000);
                            ftpUrl.setReadTimeout(30000);
                            bis = new BufferedInputStream(ftpUrl.getInputStream());
                            response.setContentLength(ftpUrl.getContentLength());
                        } else { // http
                            httpUrl = (HttpURLConnection) url.openConnection();
                            httpUrl.setConnectTimeout(30000);
                            httpUrl.setReadTimeout(30000);
                            bis = new BufferedInputStream(httpUrl.getInputStream());
                            response.setContentLength(httpUrl.getContentLength());
                        }
                        toClient = response.getOutputStream();
                        IOUtils.copy(bis, toClient);
                    } catch (Exception e) {
                        response.setContentType("text/html;charset=GBK");
                        response.setCharacterEncoding("GBK");
                        PrintWriter out = response.getWriter();
                        out.write("无法打开图片!");
                        out.flush();
                        log.info("ftpagent error "+ftpUrl+e.toString());
                    } finally {
                        if (bis != null) {
                            bis.close();
                        }
                        if (bis != null) {
                            bis.close();
                        }
                        if (httpUrl != null) {
                            httpUrl.disconnect();
                        }
                        if (ftpUrl != null) {
                            ftpUrl.close();
                        }
                        if (toClient != null) {
                            toClient.close();
                        }
                    }
                }
                return;
            }

        } catch (Exception e) {
        } finally {
            IOUtils.closeQuietly(bis);
            IOUtils.closeQuietly(toClient);
            IOUtils.closeQuietly(hFile);
            IOUtils.closeQuietly(inputStream);
        }

    }
}
