/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringBufferInputStream;
import java.io.Writer;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;

public class OracleSerialClob
implements Clob,
NClob,
Serializable,
Cloneable {
    private char[] buffer;
    private long length;
    private boolean isFreed = false;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Tue_Feb_23_16:42:12_PST_2010";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    public OracleSerialClob(char[] cArray) throws SQLException {
        this.length = cArray.length;
        this.buffer = new char[(int)this.length];
        int n2 = 0;
        while ((long)n2 < this.length) {
            this.buffer[n2] = cArray[n2];
            ++n2;
        }
    }

    public OracleSerialClob(Clob clob) throws SQLException {
        this.length = clob.length();
        this.buffer = new char[(int)this.length];
        BufferedReader bufferedReader = new BufferedReader(clob.getCharacterStream());
        try {
            int n2 = 0;
            int n3 = 0;
            do {
                n2 = bufferedReader.read(this.buffer, n3, (int)(this.length - (long)n3));
                n3 += n2;
            } while (n2 > 0);
        }
        catch (IOException iOException) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 347, iOException.getMessage());
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 347, iOException.getMessage());
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        if (this.isFreed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return new StringBufferInputStream(new String(this.buffer));
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        if (this.isFreed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return new CharArrayReader(this.buffer);
    }

    @Override
    public String getSubString(long l2, int n2) throws SQLException {
        if (this.isFreed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (l2 < 1L || n2 < 0 || (long)n2 > this.length || l2 + (long)n2 - 1L > this.length) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (n2 == 0) {
            return new String();
        }
        return new String(this.buffer, (int)l2 - 1, n2);
    }

    @Override
    public long length() throws SQLException {
        if (this.isFreed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.length;
    }

    @Override
    public long position(String string, long l2) throws SQLException {
        if (this.isFreed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (l2 < 1L) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (l2 > this.length || l2 + (long)string.length() > this.length) {
            return -1L;
        }
        char[] cArray = string.toCharArray();
        int n2 = (int)(l2 - 1L);
        boolean bl = false;
        long l3 = cArray.length;
        while ((long)n2 < this.length) {
            int n3 = 0;
            long l4 = n2 + 1;
            int n4 = n2;
            while ((long)n3 < l3 && (long)n4 < this.length && cArray[n3] == this.buffer[n4]) {
                ++n4;
                if ((long)(++n3) != l3) continue;
                return l4;
            }
            ++n2;
        }
        return -1L;
    }

    @Override
    public long position(Clob clob, long l2) throws SQLException {
        if (this.isFreed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.position(clob.getSubString(0L, (int)clob.length()), l2);
    }

    @Override
    public int setString(long l2, String string) throws SQLException {
        if (this.isFreed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        SQLException sQLException = DatabaseError.createUnsupportedFeatureSqlException();
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    @Override
    public int setString(long l2, String string, int n2, int n3) throws SQLException {
        if (this.isFreed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        SQLException sQLException = DatabaseError.createUnsupportedFeatureSqlException();
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    @Override
    public OutputStream setAsciiStream(long l2) throws SQLException {
        if (this.isFreed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        SQLException sQLException = DatabaseError.createUnsupportedFeatureSqlException();
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    @Override
    public Writer setCharacterStream(long l2) throws SQLException {
        if (this.isFreed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        SQLException sQLException = DatabaseError.createUnsupportedFeatureSqlException();
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    @Override
    public void truncate(long l2) throws SQLException {
        if (this.isFreed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        SQLException sQLException = DatabaseError.createUnsupportedFeatureSqlException();
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    @Override
    public void free() throws SQLException {
        if (this.isFreed) {
            return;
        }
        this.isFreed = true;
        this.buffer = null;
        this.length = 0L;
    }

    @Override
    public Reader getCharacterStream(long l2, long l3) throws SQLException {
        if (this.isFreed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (--l2 < 0L || l2 + 1L > this.length || l3 < 0L || l3 > this.length || l2 + l3 > this.length) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return new CharArrayReader(this.buffer, (int)l2, (int)l3);
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

