/*
 * Decompiled with CFR 0.152.
 */
package oracle.AQ;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import oracle.AQ.AQAgent;
import oracle.AQ.AQException;
import oracle.AQ.AQOracleAgent;
import oracle.AQ.AQOracleDebug;
import oracle.AQ.AQOracleQueue;
import oracle.AQ.AQOracleQueueTable;
import oracle.AQ.AQOracleSQLException;
import oracle.AQ.AQQueue;
import oracle.AQ.AQQueueProperty;
import oracle.AQ.AQQueueTable;
import oracle.AQ.AQQueueTableProperty;
import oracle.AQ.AQSession;
import oracle.AQ.AQUtil;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;

public class AQOracleSession
implements AQSession {
    Connection db_conn;
    private CallableStatement crqu_stmt;
    private CallableStatement allq_stmt;
    private CallableStatement allqo_stmt;
    private OracleCallableStatement lstn_stmt;
    private short dbversion;

    public AQOracleSession(Connection conn) throws AQException {
        Hashtable map = null;
        this.db_conn = conn;
        this.crqu_stmt = null;
        this.allq_stmt = null;
        this.allqo_stmt = null;
        this.lstn_stmt = null;
        if (conn == null) {
            AQUtil.throwAQEx(111);
        }
        try {
            map = (Hashtable)((oracle.jdbc.OracleConnection)this.db_conn).getTypeMap();
            this.dbversion = ((OracleConnection)conn).getVersionNumber();
            if (map == null) {
                ((oracle.jdbc.OracleConnection)conn).setTypeMap(new Hashtable(20));
            }
        }
        catch (Exception ex) {
            AQUtil.throwAQEx(112);
        }
    }

    public AQQueueTable createQueueTable(String owner, String name, AQQueueTableProperty property) throws AQException {
        return this.createQueueTable(owner, name, property, false);
    }

    public AQQueueTable createQueueTable(String owner, String name, AQQueueTableProperty property, boolean autonomous) throws AQException {
        Statement qt_stmt = null;
        String table_name = "";
        AQOracleQueueTable q_table = null;
        String ac_flag = "true";
        String mcons_flag = "false";
        String sec_flag = "false";
        String qt_compat = null;
        if (name == null || name.equals("")) {
            AQUtil.throwAQEx(134);
        }
        if (name.indexOf(".") != -1) {
            AQUtil.throwAQEx(179, name);
        }
        if (property == null) {
            AQUtil.throwAQEx(186);
        }
        table_name = owner == null || owner.equals("") ? name : owner + "." + name;
        qt_compat = property.getCompatible();
        if (qt_compat == null || qt_compat.equals("")) {
            qt_compat = "8.1";
        }
        try {
            if (property.isMulticonsumerEnabled()) {
                mcons_flag = "true";
            }
            if (!property.isAutoCommitEnabled()) {
                ac_flag = "false";
            }
            if (property.isSecure()) {
                sec_flag = "true";
            }
            String stmtStr = "";
            if (autonomous) {
                stmtStr = stmtStr + "declare PRAGMA AUTONOMOUS_TRANSACTION; ";
            }
            stmtStr = this.is92compatible() ? stmtStr + "begin dbms_aqadm.create_queue_table(queue_table => ?, queue_payload_type => ?, storage_clause => ?, sort_list => ?, multiple_consumers => " + mcons_flag + ", message_grouping => ?, comment => ?, auto_commit => " + ac_flag + ", primary_instance => ?, secondary_instance => ?, compatible => ?, non_repudiation => ?, secure => " + sec_flag + "); end;" : (this.is82compatible() ? stmtStr + "begin dbms_aqadm.create_queue_table(queue_table => ?, queue_payload_type => ?, storage_clause => ?, sort_list => ?, multiple_consumers => " + mcons_flag + ", message_grouping => ?, comment => ?, auto_commit => " + ac_flag + ", primary_instance => ?, secondary_instance => ?, compatible => ?, non_repudiation => ?); end;" : stmtStr + "begin dbms_aqadm.create_queue_table(queue_table => ?, queue_payload_type => ?, storage_clause => ?, sort_list => ?, multiple_consumers => " + mcons_flag + ", message_grouping => ?, comment => ?, auto_commit => " + ac_flag + ", primary_instance => ?, secondary_instance => ?, compatible => ?); end;");
            qt_stmt = this.db_conn.prepareCall(stmtStr);
            qt_stmt.setString(1, table_name);
            qt_stmt.setString(2, property.getPayloadType());
            qt_stmt.setString(3, property.getStorageClause());
            qt_stmt.setString(4, property.getSortOrder());
            qt_stmt.setInt(5, property.getMessageGrouping());
            qt_stmt.setString(6, property.getComment());
            qt_stmt.setInt(7, property.getPrimaryInstance());
            qt_stmt.setInt(8, property.getSecondaryInstance());
            qt_stmt.setString(9, qt_compat);
            if (this.is82compatible()) {
                qt_stmt.setInt(10, property.getNonRepudiation());
            }
            qt_stmt.execute();
            try {
                qt_stmt.close();
            }
            catch (Exception ex) {}
        }
        catch (SQLException sqlex) {
            AQOracleDebug.traceEx(3, "AQOracleSession.createQueueTable", sqlex);
            try {
                qt_stmt.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw new AQOracleSQLException(sqlex);
        }
        q_table = new AQOracleQueueTable(this, owner, name, property);
        return q_table;
    }

    public AQQueueTable getQueueTable(String owner, String name) throws AQException {
        AQOracleQueueTable q_table = null;
        AQQueueTableProperty property = null;
        Object sqt_stmt = null;
        ResultSet rset = null;
        Object rset2 = null;
        String pload_type = null;
        String adt_type = "";
        String qt_owner = null;
        Statement allqt_stmt = null;
        Statement allqto_stmt = null;
        String sec_flag = null;
        if (name == null || name.equals("")) {
            AQUtil.throwAQEx(134);
        }
        if (name.indexOf(".") != -1) {
            AQUtil.throwAQEx(179, name);
        }
        try {
            if (owner != null && !owner.equals("")) {
                qt_owner = owner;
            }
            if (qt_owner != null) {
                try {
                    allqto_stmt = this.is92compatible() ? this.db_conn.prepareCall("select queue_table, type, object_type, sort_order, recipients, message_grouping, user_comment, compatible, primary_instance, secondary_instance, owner, secure from all_queue_tables where owner = ? and queue_table = ?") : this.db_conn.prepareCall("select queue_table, type, object_type, sort_order, recipients, message_grouping, user_comment, compatible, primary_instance, secondary_instance, owner from all_queue_tables where owner = ? and queue_table = ?");
                    allqto_stmt.setString(1, qt_owner.toUpperCase());
                    allqto_stmt.setString(2, name.toUpperCase());
                    rset = allqto_stmt.executeQuery();
                }
                catch (SQLException sqlex) {
                    AQOracleDebug.traceEx(3, "AQOracleSession.getQueueTable-1", sqlex);
                    throw sqlex;
                }
            }
            try {
                allqt_stmt = this.is92compatible() ? this.db_conn.prepareCall("select queue_table, type, object_type, sort_order, recipients, message_grouping, user_comment, compatible, primary_instance, secondary_instance, owner, secure from all_queue_tables where queue_table = ?") : this.db_conn.prepareCall("select queue_table, type, object_type, sort_order, recipients, message_grouping, user_comment, compatible, primary_instance, secondary_instance, owner from all_queue_tables where queue_table = ?");
                allqt_stmt.setString(1, name.toUpperCase());
                rset = allqt_stmt.executeQuery();
            }
            catch (SQLException sqlex) {
                AQOracleDebug.traceEx(3, "AQOracleSession.getQueueTable-2", sqlex);
                throw sqlex;
            }
            if (rset != null && rset.next()) {
                pload_type = rset.getString(2);
                AQOracleDebug.trace(5, "AQOracleSession.getQueueTable", "Payload type: " + pload_type);
                if (pload_type.equals("RAW")) {
                    property = new AQQueueTableProperty("RAW");
                } else {
                    adt_type = rset.getString(3);
                    property = new AQQueueTableProperty(adt_type);
                }
                property.setSortOrder(rset.getString(4));
                if (rset.getString(5).equals("SINGLE")) {
                    property.setMultiConsumer(false);
                } else {
                    property.setMultiConsumer(true);
                }
                if (rset.getString(6).equals("TRANSACTIONAL")) {
                    property.setMessageGrouping(1);
                }
                if (rset.getString(7) != null) {
                    property.setComment(rset.getString(7));
                }
                property.setCompatible(rset.getString(8));
                property.setPrimaryInstance(rset.getInt(9));
                property.setSecondaryInstance(rset.getInt(10));
                if (this.is92compatible()) {
                    sec_flag = rset.getString(12);
                    AQOracleDebug.trace(5, "AQOracleSession.getQueueTable", "Secure queue table: " + sec_flag);
                    if (sec_flag.equalsIgnoreCase("YES")) {
                        property.setSecure(true);
                    }
                }
            } else if (qt_owner != null) {
                AQUtil.throwAQEx(173, qt_owner + "." + name);
            } else {
                AQUtil.throwAQEx(173, name);
            }
            if (rset.next()) {
                if (qt_owner != null) {
                    AQUtil.throwAQEx(172, "");
                } else {
                    AQUtil.throwAQEx(172, "(must specify owner)");
                }
            }
            if (qt_owner != null) {
                try {
                    allqto_stmt.close();
                }
                catch (Exception ex) {}
            } else {
                try {
                    allqt_stmt.close();
                }
                catch (Exception ex) {}
            }
        }
        catch (Exception aqex) {
            if (qt_owner != null) {
                try {
                    allqto_stmt.close();
                }
                catch (Exception ex) {}
            } else {
                try {
                    allqt_stmt.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            AQOracleDebug.traceEx(3, "AQOracleSession.getQeueueTable-4", aqex);
            if (aqex.getClass().getName().equals("oracle.AQ.AQException")) {
                throw (AQException)aqex;
            }
            throw new AQOracleSQLException((SQLException)aqex);
        }
        q_table = new AQOracleQueueTable(this, qt_owner, name, property);
        return q_table;
    }

    public AQQueue createQueue(AQQueueTable q_table, String q_name, AQQueueProperty q_property) throws AQException {
        return this.createQueue(q_table, q_name, q_property, false);
    }

    public AQQueue createQueue(AQQueueTable q_table, String q_name, AQQueueProperty q_property, boolean autonomous) throws AQException {
        CallableStatement cq_stmt = null;
        AQOracleQueue new_queue = null;
        String owner = null;
        String table_name = "";
        String ac_flag = "true";
        String pload_type = null;
        if (q_name == null || q_name.equals("")) {
            AQUtil.throwAQEx(134);
        }
        if (q_property == null) {
            AQUtil.throwAQEx(185);
        }
        if (q_table == null) {
            AQUtil.throwAQEx(187);
        }
        if (q_name.indexOf(".") != -1) {
            AQUtil.throwAQEx(178, q_name);
        }
        table_name = (owner = q_table.getOwner()) == null || owner.equals("") ? q_table.getName() : owner + "." + q_table.getName();
        try {
            if (autonomous) {
                String stmtStr = "declare PRAGMA AUTONOMOUS_TRANSACTION; begin dbms_aqadm.create_queue(queue_name => ?, queue_table => ?, queue_type => ?, max_retries => ?, retry_delay => ?, retention_time => ?, comment => ?, ";
                if (!q_property.isAutoCommitEnabled()) {
                    ac_flag = "false";
                    stmtStr = stmtStr + "auto_commit => false); end;";
                } else {
                    stmtStr = stmtStr + "auto_commit => true); end;";
                }
                cq_stmt = this.db_conn.prepareCall(stmtStr);
            } else if (!q_property.isAutoCommitEnabled()) {
                ac_flag = "false";
                cq_stmt = this.db_conn.prepareCall("begin dbms_aqadm.create_queue(queue_name => ?, queue_table => ?, queue_type => ?, max_retries => ?, retry_delay => ?, retention_time => ?, comment => ?, auto_commit => false); end;");
            } else {
                if (this.crqu_stmt != null) {
                    this.crqu_stmt.clearParameters();
                } else {
                    this.crqu_stmt = this.db_conn.prepareCall("begin dbms_aqadm.create_queue(queue_name => ?, queue_table => ?, queue_type => ?, max_retries => ?, retry_delay => ?, retention_time => ?, comment => ?, auto_commit => true); end;");
                }
                cq_stmt = this.crqu_stmt;
            }
            cq_stmt.setString(1, q_name);
            cq_stmt.setString(2, table_name);
            cq_stmt.setInt(3, q_property.getQueueType());
            if (q_property.max_retries != null) {
                ((OracleCallableStatement)cq_stmt).setObject(4, (Object)q_property.max_retries, 4);
            } else {
                ((OracleCallableStatement)cq_stmt).setNull(4, 4);
            }
            cq_stmt.setDouble(5, q_property.getRetryInterval());
            cq_stmt.setDouble(6, q_property.getRetentionTime());
            cq_stmt.setString(7, q_property.getComment());
            cq_stmt.execute();
        }
        catch (SQLException sqlex) {
            if (ac_flag.equals("true")) {
                try {
                    this.crqu_stmt.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                this.crqu_stmt = null;
            }
            AQOracleDebug.traceEx(3, "AQOracleSession.createQueue", sqlex);
            throw new AQOracleSQLException(sqlex);
        }
        pload_type = ((AQOracleQueueTable)q_table).property.getPayloadType();
        new_queue = pload_type.equalsIgnoreCase("RAW") ? new AQOracleQueue(this, owner, q_name, q_table.getName(), q_property, 2, null, q_table.isSecure()) : new AQOracleQueue(this, owner, q_name, q_table.getName(), q_property, 1, pload_type, q_table.isSecure());
        return new_queue;
    }

    public AQQueue getQueue(String owner, String name) throws AQException {
        AQOracleQueue que_hdl = null;
        AQQueueProperty q_property = null;
        ResultSet rset = null;
        int pload_type = 0;
        String obj_type = "";
        String ret_time = "";
        String sec_flag = null;
        boolean sec_q = false;
        if (name == null || name.equals("")) {
            AQUtil.throwAQEx(134);
        }
        if (name.indexOf(".") != -1) {
            AQUtil.throwAQEx(178, name);
        }
        try {
            try {
                if (owner == null || owner.equals("")) {
                    if (this.allq_stmt == null) {
                        this.allq_stmt = this.is92compatible() ? this.db_conn.prepareCall("select t1.owner, t1.name, t1.queue_table, t1.queue_type, t1.max_retries, t1.retry_delay, t1.retention, t1.user_comment, t2.type, t2.object_type, t2.secure from all_queues t1, all_queue_tables t2 where t1.name=? and t1.queue_table=t2.queue_table and t1.owner=t2.owner") : this.db_conn.prepareCall("select t1.owner, t1.name, t1.queue_table, t1.queue_type, t1.max_retries, t1.retry_delay, t1.retention, t1.user_comment, t2.type, t2.object_type from all_queues t1, all_queue_tables t2 where t1.name=? and t1.queue_table=t2.queue_table and t1.owner=t2.owner");
                    } else {
                        this.allq_stmt.clearParameters();
                    }
                    this.allq_stmt.setString(1, name.toUpperCase());
                    rset = this.allq_stmt.executeQuery();
                } else {
                    if (this.allqo_stmt == null) {
                        this.allqo_stmt = this.is92compatible() ? this.db_conn.prepareCall("select /*+ FIRST_ROWS */ t1.owner, t1.name, t1.queue_table, t1.queue_type, t1.max_retries, t1.retry_delay, t1.retention, t1.user_comment, t2.type, t2.object_type, t2.secure from all_queues t1, all_queue_tables t2 where t1.owner=? and t1.name=? and t2.owner=? and t1.queue_table=t2.queue_table") : this.db_conn.prepareCall("select /*+ FIRST_ROWS */ t1.owner, t1.name, t1.queue_table, t1.queue_type, t1.max_retries, t1.retry_delay, t1.retention, t1.user_comment, t2.type, t2.object_type from all_queues t1, all_queue_tables t2 where t1.owner=? and t1.name=? and t2.owner=? and t1.queue_table=t2.queue_table");
                    } else {
                        this.allqo_stmt.clearParameters();
                    }
                    this.allqo_stmt.setString(1, owner.toUpperCase());
                    this.allqo_stmt.setString(2, name.toUpperCase());
                    this.allqo_stmt.setString(3, owner.toUpperCase());
                    rset = this.allqo_stmt.executeQuery();
                }
            }
            catch (SQLException sqlex) {
                AQOracleDebug.traceEx(3, "AQOracleSession.getQeueue-1", sqlex);
                if (owner == null || owner.equals("")) {
                    try {
                        this.allq_stmt.close();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    this.allq_stmt = null;
                } else {
                    try {
                        this.allqo_stmt.close();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    this.allqo_stmt = null;
                }
                throw sqlex;
            }
            if (rset.next()) {
                q_property = new AQQueueProperty();
                if (rset.getString(4).equals("EXCEPTION_QUEUE")) {
                    q_property.setQueueType(1);
                }
                q_property.setMaxRetries(rset.getInt(5));
                q_property.setRetryInterval(rset.getInt(6));
                ret_time = rset.getString(7).trim();
                if (ret_time.equals("FOREVER")) {
                    q_property.setRetentionTime(-1.0);
                } else {
                    q_property.setRetentionTime(rset.getDouble(7));
                }
                q_property.setComment(rset.getString(8));
                if (rset.getString(9).equals("RAW")) {
                    pload_type = 2;
                } else {
                    pload_type = 1;
                    obj_type = rset.getString(10);
                }
                if (this.is92compatible()) {
                    sec_flag = rset.getString(11);
                    AQOracleDebug.trace(5, "AQOracleSession.getQueue", "Secure queue table: " + sec_flag);
                    if (sec_flag.equalsIgnoreCase("YES")) {
                        sec_q = true;
                    }
                }
            } else if (owner == null || owner.equals("")) {
                AQUtil.throwAQEx(190, name);
            } else {
                AQUtil.throwAQEx(190, owner + "." + name);
            }
            que_hdl = pload_type == 2 ? new AQOracleQueue(this, rset.getString(1), name, rset.getString(3), q_property, pload_type, null, sec_q) : new AQOracleQueue(this, rset.getString(1), name, rset.getString(3), q_property, pload_type, obj_type, sec_q);
            if (rset.next()) {
                AQUtil.throwAQEx(182);
            }
        }
        catch (AQException aqex) {
            AQOracleDebug.traceEx(3, "AQOracleSession.getQueue-2", aqex);
            throw aqex;
        }
        catch (SQLException sqlex) {
            AQOracleDebug.traceEx(3, "AQOracleSession.getQueue-3", sqlex);
            throw new AQOracleSQLException(sqlex);
        }
        return que_hdl;
    }

    public AQAgent listen(AQAgent[] agent_list, int wait_time) throws AQException {
        Integer wt_time = null;
        ARRAY recp_array = null;
        Hashtable map = null;
        AQAgent ret_agt = null;
        AQOracleAgent ret_ora_agt = null;
        ResultSet rset = null;
        AQOracleDebug.trace(4, "AQOracleSession.listen", "entry");
        if (agent_list == null || agent_list[0] == null) {
            AQUtil.throwAQEx(145);
        }
        try {
            if (this.db_conn == null) {
                AQUtil.throwAQEx(112);
            }
            map = (Hashtable)((oracle.jdbc.OracleConnection)this.db_conn).getTypeMap();
            map.put("SYS.AQ$_AGENT", Class.forName("oracle.AQ.AQOracleAgent"));
        }
        catch (Exception ex2) {
            AQUtil.throwAQEx(146, ex2);
        }
        try {
            if (this.lstn_stmt == null) {
                AQOracleDebug.trace(4, "AQOracleSession.listen", "lstn_stmt = null");
                this.lstn_stmt = (OracleCallableStatement)this.db_conn.prepareCall("begin dbms_aqin.aq$_listen(?, ?, ?); end; ");
            } else {
                this.lstn_stmt.clearParameters();
            }
            recp_array = this.createRecpArrayfromAgentList(agent_list);
            if (recp_array != null) {
                AQOracleDebug.trace(4, "AQOracleSession.listen", "generated recp array ");
            } else {
                AQOracleDebug.trace(4, "AQOracleSession.listen", "recp array = nul");
            }
            this.lstn_stmt.setObject(1, (Object)recp_array, 2003);
            wt_time = new Integer(wait_time);
            AQOracleDebug.trace(4, "AQOracleSession.listen", "wait " + wt_time);
            this.lstn_stmt.setObject(2, (Object)wt_time, 4);
            this.lstn_stmt.registerOutParameter(3, 2002, "SYS.AQ$_AGENT");
            AQOracleDebug.trace(4, "AQOracleSession.listen", "before execute");
            rset = this.lstn_stmt.executeQuery();
            AQOracleDebug.trace(4, "AQOracleSession.listen", "after execute");
            ret_ora_agt = (AQOracleAgent)this.lstn_stmt.getObject(3);
            try {
                if (rset != null) {
                    rset.close();
                }
            }
            catch (Exception rex) {}
        }
        catch (SQLException sqlex) {
            AQOracleDebug.traceEx(3, "AQOracleSession.listen-3", sqlex);
            try {
                this.lstn_stmt.close();
            }
            catch (Exception ex) {
                AQOracleDebug.traceEx(3, "AQOracleSession.listen-close_ex", ex);
            }
            this.lstn_stmt = null;
            throw new AQOracleSQLException(sqlex);
        }
        if (ret_ora_agt != null) {
            ret_agt = new AQAgent(ret_ora_agt.name, ret_ora_agt.address, ret_ora_agt.protocol);
        }
        return ret_agt;
    }

    public Connection getDBConnection() throws AQException {
        return this.db_conn;
    }

    public void createAQAgent(String agent_name) throws AQException {
        AQOracleDebug.trace(4, "AQOracleSession.createAQAgent-1", "entry");
        this.createAQAgent(agent_name, false, false, null);
        AQOracleDebug.trace(4, "AQOracleSession.createAQAgent-1", "exit");
    }

    public void createAQAgent(String agent_name, boolean enable_http, boolean enable_smtp, String cert_loc) throws AQException {
        Statement ag_stmt = null;
        String http_flag = "false";
        String smtp_flag = "false";
        AQOracleDebug.trace(4, "AQOracleSession.createAQAgent-2", "entry");
        if (agent_name == null) {
            AQUtil.throwAQEx(229, "agent_name");
        }
        if (enable_http) {
            http_flag = "true";
        }
        if (enable_smtp) {
            smtp_flag = "true";
        }
        try {
            ag_stmt = this.db_conn.prepareCall("begin dbms_aqadm.create_aq_agent(agent_name=> ?, certificate_location => ?, enable_http => " + http_flag + ", enable_smtp => " + smtp_flag + "); end;");
            ag_stmt.setString(1, agent_name);
            ag_stmt.setString(2, cert_loc);
            ag_stmt.execute();
            try {
                ag_stmt.close();
            }
            catch (Exception ex) {}
        }
        catch (SQLException sqlex) {
            try {
                ag_stmt.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw new AQOracleSQLException(sqlex);
        }
        AQOracleDebug.trace(4, "AQOracleSession.createAQAgent-2", "exit");
    }

    public void alterAQAgent(String agent_name, boolean enable_http, boolean enable_smtp, String cert_loc) throws AQException {
        Statement ag_stmt = null;
        String http_flag = "false";
        String smtp_flag = "false";
        AQOracleDebug.trace(4, "AQOracleSession.alterAQAgent", "entry");
        if (agent_name == null) {
            AQUtil.throwAQEx(229, "agent_name");
        }
        if (enable_http) {
            http_flag = "true";
        }
        if (enable_smtp) {
            smtp_flag = "true";
        }
        try {
            ag_stmt = this.db_conn.prepareCall("begin dbms_aqadm.alter_aq_agent(agent_name=> ?, certificate_location => ?, enable_http => " + http_flag + ", enable_smtp => " + smtp_flag + "); end;");
            ag_stmt.setString(1, agent_name);
            ag_stmt.setString(2, cert_loc);
            ag_stmt.execute();
            try {
                ag_stmt.close();
            }
            catch (Exception ex) {}
        }
        catch (SQLException sqlex) {
            try {
                ag_stmt.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw new AQOracleSQLException(sqlex);
        }
        AQOracleDebug.trace(4, "AQOracleSession.alterAQAgent", "exit");
    }

    public void dropAQAgent(String agent_name) throws AQException {
        CallableStatement ag_stmt = null;
        AQOracleDebug.trace(4, "AQOracleSession.dropAQAgent", "entry");
        if (agent_name == null) {
            AQUtil.throwAQEx(229, "agent_name");
        }
        try {
            ag_stmt = this.db_conn.prepareCall("begin dbms_aqadm.drop_aq_agent(agent_name=> ? ); end;");
            ag_stmt.setString(1, agent_name);
            ag_stmt.execute();
            try {
                ag_stmt.close();
            }
            catch (Exception ex) {}
        }
        catch (SQLException sqlex) {
            try {
                ag_stmt.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw new AQOracleSQLException(sqlex);
        }
        AQOracleDebug.trace(4, "AQOracleSession.dropAQAgent", "exit");
    }

    public void enableDBAccess(String agent_name, String db_username) throws AQException {
        CallableStatement ed_stmt = null;
        AQOracleDebug.trace(4, "AQOracleSession.enableDBAccess", "entry");
        if (agent_name == null) {
            AQUtil.throwAQEx(229, "agent_name");
        }
        if (db_username == null) {
            AQUtil.throwAQEx(229, "db_username");
        }
        try {
            ed_stmt = this.db_conn.prepareCall("begin dbms_aqadm.enable_db_access(agent_name=> ?, db_username => ? ); end;");
            ed_stmt.setString(1, agent_name);
            ed_stmt.setString(2, db_username);
            ed_stmt.execute();
            try {
                ed_stmt.close();
            }
            catch (Exception ex) {}
        }
        catch (SQLException sqlex) {
            try {
                ed_stmt.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw new AQOracleSQLException(sqlex);
        }
        AQOracleDebug.trace(4, "AQOracleSession.enableDBAccess", "exit");
    }

    public void disableDBAccess(String agent_name, String db_username) throws AQException {
        CallableStatement ed_stmt = null;
        AQOracleDebug.trace(4, "AQOracleSession.disableDBAccess", "entry");
        if (agent_name == null) {
            AQUtil.throwAQEx(229, "agent_name");
        }
        if (db_username == null) {
            AQUtil.throwAQEx(229, "db_username");
        }
        try {
            ed_stmt = this.db_conn.prepareCall("begin dbms_aqadm.disable_db_access(agent_name=> ?, db_username => ? ); end;");
            ed_stmt.setString(1, agent_name);
            ed_stmt.setString(2, db_username);
            ed_stmt.execute();
            try {
                ed_stmt.close();
            }
            catch (Exception ex) {}
        }
        catch (SQLException sqlex) {
            try {
                ed_stmt.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw new AQOracleSQLException(sqlex);
        }
        AQOracleDebug.trace(4, "AQOracleSession.disableDBAccess", "exit");
    }

    private ARRAY createRecpArrayfromAgentList(AQAgent[] agent_list) throws AQException {
        ArrayDescriptor desc = null;
        Object[] obj_array = null;
        ARRAY recp_array = null;
        int num_agts = 0;
        AQOracleAgent ora_agt = null;
        AQAgent agt = null;
        int i = 0;
        num_agts = agent_list.length;
        obj_array = new Object[num_agts];
        AQOracleDebug.trace(4, "AQOracleSession.createRecpArrayfromAgentList", "num_agts = " + num_agts);
        for (i = 0; i < num_agts; ++i) {
            agt = agent_list[i];
            if (agt == null) {
                AQUtil.throwAQEx(145);
            }
            ora_agt = new AQOracleAgent(agt.getName(), agt.getAddress(), agt.getProtocol());
            AQOracleDebug.trace(4, "AQOracleSession.createRecpArrayfromAgentList", "agt-" + i + ":: " + ora_agt.name + "::" + ora_agt.address + "::" + ora_agt.protocol);
            obj_array[i] = ora_agt;
        }
        try {
            desc = ArrayDescriptor.createDescriptor((String)"SYS.AQ$_RECIPIENTS", (Connection)this.db_conn);
            recp_array = new ARRAY(desc, this.db_conn, (Object)obj_array);
        }
        catch (SQLException sqlex) {
            throw new AQOracleSQLException(sqlex);
        }
        return recp_array;
    }

    boolean is82compatible() {
        boolean v82compatible = false;
        if (this.dbversion >= 8200) {
            v82compatible = true;
        }
        return v82compatible;
    }

    boolean is92compatible() {
        boolean v92compatible = false;
        if (this.dbversion >= 9200) {
            v92compatible = true;
        }
        return v92compatible;
    }

    boolean is100compatible() {
        boolean v100compatible = false;
        if (this.dbversion >= 10000) {
            v100compatible = true;
        }
        return v100compatible;
    }

    boolean is102compatible() {
        boolean v102compatible = false;
        if (this.dbversion >= 10200) {
            v102compatible = true;
        }
        return v102compatible;
    }

    public void close() {
        try {
            if (this.crqu_stmt != null) {
                this.crqu_stmt.close();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            if (this.allqo_stmt != null) {
                this.allqo_stmt.close();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            if (this.allq_stmt != null) {
                this.allq_stmt.close();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            if (this.lstn_stmt != null) {
                this.lstn_stmt.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.db_conn = null;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[AQOracleSession]");
        if (this.db_conn != null) {
            buf.append("\n  db_conn          : " + this.db_conn);
        } else {
            buf.append("\n  db_conn          : NULL");
        }
        return buf.toString();
    }
}

