package com.hzjt.domain;


import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

/**
 * @author chenl
 * @version 1.0
 * @date 2020/4/9 10:00
 */
public class TraffAlarmRecordDelay implements Delayed {
    /* 触发时间*/
    private long time;
    Traffalarmrecord traffalarmrecord;

    public TraffAlarmRecordDelay(Traffalarmrecord traffalarmrecord, long time, TimeUnit unit) {
        this.traffalarmrecord = traffalarmrecord;
        this.time = System.currentTimeMillis() + (time > 0? unit.toMillis(time): 0);
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return time - System.currentTimeMillis();
    }

    @Override
    public int compareTo(Delayed o) {
        TraffAlarmRecordDelay item = (TraffAlarmRecordDelay) o;
        long diff = this.time - item.time;
        if (diff <= 0) {
            return -1;
        }else {
            return 1;
        }
    }

    public Traffalarmrecord getTraffalarmrecord(){
        return this.traffalarmrecord;
    }
    @Override
    public String toString() {
        return "TraffAlarmRecordDelay{" +
                "time=" + time +
                ", traffalarmrecord='" + traffalarmrecord.toString() + '\'' +
                '}';
    }
}