/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Properties;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnectionFactory;
import javax.jms.XAConnectionFactory;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XATopicConnectionFactory;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import oracle.jms.AQjmsConnectionFactory;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsQueueConnectionFactory;
import oracle.jms.AQjmsTopicConnectionFactory;
import oracle.jms.AQjmsXAConnectionFactory;
import oracle.jms.AQjmsXAQueueConnectionFactory;
import oracle.jms.AQjmsXAResourceFactory;
import oracle.jms.AQjmsXATopicConnectionFactory;

public class AQjmsFactory {
    public static QueueConnectionFactory getQueueConnectionFactory(DataSource dsobj) throws JMSException {
        AQjmsQueueConnectionFactory conn_fac = null;
        conn_fac = new AQjmsQueueConnectionFactory(dsobj);
        return conn_fac;
    }

    public static QueueConnectionFactory getQueueConnectionFactory(DataSource dsobj, boolean compliant) throws JMSException {
        AQjmsQueueConnectionFactory conn_fac = null;
        conn_fac = new AQjmsQueueConnectionFactory(dsobj);
        conn_fac.setCompliant(compliant);
        return conn_fac;
    }

    public static QueueConnectionFactory getQueueConnectionFactory(String hostname, String oracle_sid, int portno, String driver) throws JMSException {
        AQjmsQueueConnectionFactory conn_fac = null;
        conn_fac = new AQjmsQueueConnectionFactory(hostname, oracle_sid, portno, driver);
        return conn_fac;
    }

    public static QueueConnectionFactory getQueueConnectionFactory(String hostname, String oracle_sid, int portno, String driver, boolean compliant) throws JMSException {
        AQjmsQueueConnectionFactory conn_fac = null;
        conn_fac = new AQjmsQueueConnectionFactory(hostname, oracle_sid, portno, driver);
        conn_fac.setCompliant(compliant);
        return conn_fac;
    }

    public static QueueConnectionFactory getQueueConnectionFactory(String jdbc_url, Properties info) throws JMSException {
        AQjmsQueueConnectionFactory conn_fac = null;
        conn_fac = new AQjmsQueueConnectionFactory(jdbc_url, info);
        return conn_fac;
    }

    public static QueueConnectionFactory getQueueConnectionFactory(String jdbc_url, Properties info, boolean compliant) throws JMSException {
        AQjmsQueueConnectionFactory conn_fac = null;
        conn_fac = new AQjmsQueueConnectionFactory(jdbc_url, info);
        conn_fac.setCompliant(compliant);
        return conn_fac;
    }

    public static TopicConnectionFactory getTopicConnectionFactory(DataSource dsobj) throws JMSException {
        AQjmsTopicConnectionFactory conn_fac = null;
        conn_fac = new AQjmsTopicConnectionFactory(dsobj);
        return conn_fac;
    }

    public static TopicConnectionFactory getTopicConnectionFactory(DataSource dsobj, boolean compliant) throws JMSException {
        AQjmsTopicConnectionFactory conn_fac = null;
        conn_fac = new AQjmsTopicConnectionFactory(dsobj);
        conn_fac.setCompliant(compliant);
        return conn_fac;
    }

    public static TopicConnectionFactory getTopicConnectionFactory(String hostname, String oracle_sid, int portno, String driver) throws JMSException {
        AQjmsTopicConnectionFactory conn_fac = null;
        conn_fac = new AQjmsTopicConnectionFactory(hostname, oracle_sid, portno, driver);
        return conn_fac;
    }

    public static TopicConnectionFactory getTopicConnectionFactory(String hostname, String oracle_sid, int portno, String driver, boolean compliant) throws JMSException {
        AQjmsTopicConnectionFactory conn_fac = null;
        conn_fac = new AQjmsTopicConnectionFactory(hostname, oracle_sid, portno, driver);
        conn_fac.setCompliant(compliant);
        return conn_fac;
    }

    public static TopicConnectionFactory getTopicConnectionFactory(String jdbc_url, Properties info) throws JMSException {
        AQjmsTopicConnectionFactory conn_fac = null;
        conn_fac = new AQjmsTopicConnectionFactory(jdbc_url, info);
        return conn_fac;
    }

    public static TopicConnectionFactory getTopicConnectionFactory(String jdbc_url, Properties info, boolean compliant) throws JMSException {
        AQjmsTopicConnectionFactory conn_fac = null;
        conn_fac = new AQjmsTopicConnectionFactory(jdbc_url, info);
        conn_fac.setCompliant(compliant);
        return conn_fac;
    }

    public static int registerConnectionFactory(Connection connection, String conn_name, String hostname, String oracle_sid, int portno, String driver, String type) throws JMSException {
        Statement addc_stmt = null;
        try {
            addc_stmt = type.toLowerCase().equals("queue") ? connection.prepareCall("begin dbms_aqadm.add_connection_to_ldap(connection=>?, host=>?, port=>?, sid=>?, driver=>?, type=>1); end;") : connection.prepareCall("begin dbms_aqadm.add_connection_to_ldap(connection=>?, host=>?, port=>?, sid=>?, driver=>?, type=>2); end;");
            addc_stmt.setString(1, conn_name);
            addc_stmt.setString(2, hostname);
            addc_stmt.setInt(3, portno);
            addc_stmt.setString(4, oracle_sid);
            addc_stmt.setString(5, driver);
            addc_stmt.execute();
            addc_stmt.close();
        }
        catch (SQLException sqlex) {
            try {
                addc_stmt.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            AQjmsOracleDebug.traceEx(3, "AQjmsFactory.registerConnectionFactory", sqlex);
            throw new AQjmsException(sqlex);
        }
        return 0;
    }

    public static int registerConnectionFactory(Connection connection, String conn_name, String jdbc_url, Properties info, String type) throws JMSException {
        Statement addc_stmt = null;
        try {
            addc_stmt = type.toLowerCase().equals("queue") ? connection.prepareCall("begin dbms_aqadm.add_connection_to_ldap(connection=>?, jdbc_string=>?, type=>1, username=>?, password=>?); end;") : connection.prepareCall("begin dbms_aqadm.add_connection_to_ldap(connection=>?, jdbc_string=>?, type=>2, username=>?, password=>?); end;");
            addc_stmt.setString(1, conn_name);
            addc_stmt.setString(2, jdbc_url);
            addc_stmt.setString(3, info == null ? null : info.getProperty("user", null));
            addc_stmt.setString(4, info == null ? null : info.getProperty("password", null));
            addc_stmt.execute();
            addc_stmt.close();
        }
        catch (SQLException sqlex) {
            try {
                addc_stmt.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            AQjmsOracleDebug.traceEx(3, "AQjmsFactory.registerConnectionFactory", sqlex);
            throw new AQjmsException(sqlex);
        }
        return 0;
    }

    public static int unregisterConnectionFactory(Connection connection, String conn_name) throws JMSException {
        CallableStatement drpc_stmt = null;
        try {
            drpc_stmt = connection.prepareCall("begin dbms_aqadm.del_connection_from_ldap(connection=>?); end;");
            drpc_stmt.setString(1, conn_name);
            drpc_stmt.execute();
            drpc_stmt.close();
        }
        catch (SQLException sqlex) {
            try {
                drpc_stmt.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            AQjmsOracleDebug.traceEx(3, "AQjmsFactory.unregisterConnectionFactory", sqlex);
            throw new AQjmsException(sqlex);
        }
        return 0;
    }

    public static int registerConnectionFactory(Hashtable env, String conn_name, String hostname, String oracle_sid, int portno, String driver, String type) throws JMSException {
        try {
            InitialDirContext inictx = new InitialDirContext(env);
            String searchbase = "cn=oracledbconnections," + (String)env.get("server_dn");
            DirContext ctx = (DirContext)inictx.lookup(searchbase);
            BasicAttributes attrs = new BasicAttributes(false);
            BasicAttribute objClasses = new BasicAttribute("objectclass");
            objClasses.add("top");
            objClasses.add("javaContainer");
            objClasses.add("javaObject");
            objClasses.add("javaNamingReference");
            objClasses.add("orclDBAQConnection");
            BasicAttribute gen_attr = new BasicAttribute("orclDBAQGeneric");
            gen_attr.add("Host=" + hostname);
            gen_attr.add("Port=" + String.valueOf(portno));
            gen_attr.add("Sid=" + oracle_sid);
            if (driver != null) {
                gen_attr.add("Driver=" + driver);
            }
            attrs.put("cn", conn_name);
            attrs.put(gen_attr);
            if (type.toLowerCase().equals("queue")) {
                attrs.put("javaclassname", "oracle.jms.AQjmsQueueConnectionFactory");
            } else {
                attrs.put("javaclassname", "oracle.jms.AQjmsTopicConnectionFactory");
            }
            attrs.put("javafactory", "oracle.jms.AQjmsConnectionFactory");
            attrs.put(objClasses);
            ctx.createSubcontext("cn=" + conn_name, (Attributes)attrs);
        }
        catch (NamingException e) {
            AQjmsOracleDebug.traceEx(3, "AQjmsFactory.registerConnectionFactory", e);
            AQjmsError.throwEx(205, (Throwable)e);
        }
        return 0;
    }

    public static int registerConnectionFactory(Hashtable env, String conn_name, String jdbc_url, Properties info, String type) throws JMSException {
        try {
            InitialDirContext inictx = new InitialDirContext(env);
            String searchbase = "cn=oracledbconnections," + (String)env.get("server_dn");
            DirContext ctx = (DirContext)inictx.lookup(searchbase);
            BasicAttributes attrs = new BasicAttributes(false);
            BasicAttribute objClasses = new BasicAttribute("objectclass");
            objClasses.add("top");
            objClasses.add("javaContainer");
            objClasses.add("javaObject");
            objClasses.add("javaNamingReference");
            objClasses.add("orclDBAQConnection");
            BasicAttribute gen_attr = new BasicAttribute("orclDBAQGeneric");
            gen_attr.add("JDBC_connect_string=" + jdbc_url);
            if (info != null && info.getProperty("user", null) != null && info.getProperty("password", null) != null) {
                gen_attr.add("Username=" + info.getProperty("user"));
                gen_attr.add("Password=" + info.getProperty("password"));
            }
            attrs.put("cn", conn_name);
            attrs.put(gen_attr);
            if (type.toLowerCase().equals("queue")) {
                attrs.put("javaclassname", "oracle.jms.AQjmsQueueConnectionFactory");
            } else {
                attrs.put("javaclassname", "oracle.jms.AQjmsTopicConnectionFactory");
            }
            attrs.put("javafactory", "oracle.jms.AQjmsConnectionFactory");
            attrs.put(objClasses);
            ctx.createSubcontext("cn=" + conn_name, (Attributes)attrs);
        }
        catch (NamingException e) {
            AQjmsOracleDebug.traceEx(3, "AQjmsFactory.registerConnectionFactory", e);
            AQjmsError.throwEx(205, (Throwable)e);
        }
        return 0;
    }

    public static int unregisterConnectionFactory(Hashtable env, String conn_name) throws JMSException {
        try {
            InitialDirContext inictx = new InitialDirContext(env);
            String searchbase = "cn=oracledbconnections," + (String)env.get("server_dn");
            DirContext ctx = (DirContext)inictx.lookup(searchbase);
            ctx.destroySubcontext("cn=" + conn_name);
        }
        catch (NamingException e) {
            AQjmsOracleDebug.traceEx(3, "AQjmsFactory.unregisterConnectionFactory", e);
            AQjmsError.throwEx(205, (Throwable)e);
        }
        return 0;
    }

    public static ConnectionFactory getConnectionFactory(DataSource dsobj) throws JMSException {
        AQjmsConnectionFactory conn_fac = null;
        conn_fac = new AQjmsConnectionFactory(dsobj);
        return conn_fac;
    }

    public static ConnectionFactory getConnectionFactory(DataSource dsobj, boolean compliant) throws JMSException {
        AQjmsConnectionFactory conn_fac = null;
        conn_fac = new AQjmsConnectionFactory(dsobj);
        conn_fac.setCompliant(compliant);
        return conn_fac;
    }

    public static ConnectionFactory getConnectionFactory(String hostname, String oracle_sid, int portno, String driver) throws JMSException {
        AQjmsConnectionFactory conn_fac = null;
        conn_fac = new AQjmsConnectionFactory(hostname, oracle_sid, portno, driver);
        return conn_fac;
    }

    public static ConnectionFactory getConnectionFactory(String hostname, String oracle_sid, int portno, String driver, boolean compliant) throws JMSException {
        AQjmsConnectionFactory conn_fac = null;
        conn_fac = new AQjmsConnectionFactory(hostname, oracle_sid, portno, driver);
        conn_fac.setCompliant(compliant);
        return conn_fac;
    }

    public static ConnectionFactory getConnectionFactory(String jdbc_url, Properties info) throws JMSException {
        AQjmsConnectionFactory conn_fac = null;
        conn_fac = new AQjmsConnectionFactory(jdbc_url, info);
        return conn_fac;
    }

    public static ConnectionFactory getConnectionFactory(String jdbc_url, Properties info, boolean compliant) throws JMSException {
        AQjmsConnectionFactory conn_fac = null;
        conn_fac = new AQjmsConnectionFactory(jdbc_url, info);
        conn_fac.setCompliant(compliant);
        return conn_fac;
    }

    public static XAConnectionFactory getXAConnectionFactory(XADataSource xaDS) throws JMSException {
        return new AQjmsXAConnectionFactory(xaDS);
    }

    public static XAConnectionFactory getXAConnectionFactory(XADataSource xaDS, boolean compliant) throws JMSException {
        AQjmsXAConnectionFactory xaConnFact = new AQjmsXAConnectionFactory(xaDS);
        xaConnFact.setCompliant(compliant);
        return xaConnFact;
    }

    public static XAConnectionFactory getXAConnectionFactory(DataSource dsobj, AQjmsXAResourceFactory xaresFactory) throws JMSException {
        return new AQjmsXAConnectionFactory(dsobj, xaresFactory);
    }

    public static XAConnectionFactory getXAConnectionFactory(DataSource dsobj, AQjmsXAResourceFactory xaresFactory, boolean compliant) throws JMSException {
        AQjmsXAConnectionFactory xaConnFact = new AQjmsXAConnectionFactory(dsobj, xaresFactory);
        xaConnFact.setCompliant(compliant);
        return xaConnFact;
    }

    public static XAConnectionFactory getXAConnectionFactory(String hostname, String oracle_sid, int portno, String driver) throws JMSException {
        AQjmsXAConnectionFactory xaConnFact = null;
        xaConnFact = new AQjmsXAConnectionFactory(hostname, oracle_sid, portno, driver);
        return xaConnFact;
    }

    public static XAConnectionFactory getXAConnectionFactory(String hostname, String oracle_sid, int portno, String driver, boolean compliant) throws JMSException {
        AQjmsXAConnectionFactory xaConnFact = null;
        xaConnFact = new AQjmsXAConnectionFactory(hostname, oracle_sid, portno, driver);
        xaConnFact.setCompliant(compliant);
        return xaConnFact;
    }

    public static XAConnectionFactory getXAConnectionFactory(String jdbc_url, Properties info) throws JMSException {
        AQjmsXAConnectionFactory xaConnFact = null;
        xaConnFact = new AQjmsXAConnectionFactory(jdbc_url, info);
        return xaConnFact;
    }

    public static XAConnectionFactory getXAConnectionFactory(String jdbc_url, Properties info, boolean compliant) throws JMSException {
        AQjmsXAConnectionFactory xaConnFact = null;
        xaConnFact = new AQjmsXAConnectionFactory(jdbc_url, info);
        xaConnFact.setCompliant(compliant);
        return xaConnFact;
    }

    public static XAQueueConnectionFactory getXAQueueConnectionFactory(XADataSource xaDS) throws JMSException {
        return new AQjmsXAQueueConnectionFactory(xaDS);
    }

    public static XAQueueConnectionFactory getXAQueueConnectionFactory(XADataSource xaDS, boolean compliant) throws JMSException {
        AQjmsXAQueueConnectionFactory xaQConnFact = null;
        xaQConnFact = new AQjmsXAQueueConnectionFactory(xaDS);
        xaQConnFact.setCompliant(compliant);
        return xaQConnFact;
    }

    public static XAQueueConnectionFactory getXAQueueConnectionFactory(DataSource dsobj, AQjmsXAResourceFactory xaresFactory) throws JMSException {
        return new AQjmsXAQueueConnectionFactory(dsobj, xaresFactory);
    }

    public static XAQueueConnectionFactory getXAQueueConnectionFactory(DataSource dsobj, AQjmsXAResourceFactory xaresFactory, boolean compliant) throws JMSException {
        AQjmsXAQueueConnectionFactory xaQConnFact = null;
        xaQConnFact = new AQjmsXAQueueConnectionFactory(dsobj, xaresFactory);
        xaQConnFact.setCompliant(compliant);
        return xaQConnFact;
    }

    public static XAQueueConnectionFactory getXAQueueConnectionFactory(String hostname, String oracle_sid, int portno, String driver) throws JMSException {
        return new AQjmsXAQueueConnectionFactory(hostname, oracle_sid, portno, driver);
    }

    public static XAQueueConnectionFactory getXAQueueConnectionFactory(String hostname, String oracle_sid, int portno, String driver, boolean compliant) throws JMSException {
        AQjmsXAQueueConnectionFactory xaQConnFact = null;
        xaQConnFact = new AQjmsXAQueueConnectionFactory(hostname, oracle_sid, portno, driver);
        xaQConnFact.setCompliant(compliant);
        return xaQConnFact;
    }

    public static XAQueueConnectionFactory getXAQueueConnectionFactory(String jdbc_url, Properties info) throws JMSException {
        return new AQjmsXAQueueConnectionFactory(jdbc_url, info);
    }

    public static XAQueueConnectionFactory getXAQueueConnectionFactory(String jdbc_url, Properties info, boolean compliant) throws JMSException {
        AQjmsXAQueueConnectionFactory xaQConnFact = null;
        xaQConnFact = new AQjmsXAQueueConnectionFactory(jdbc_url, info);
        xaQConnFact.setCompliant(compliant);
        return xaQConnFact;
    }

    public static XATopicConnectionFactory getXATopicConnectionFactory(XADataSource xaDS) throws JMSException {
        return new AQjmsXATopicConnectionFactory(xaDS);
    }

    public static XATopicConnectionFactory getXATopicConnectionFactory(XADataSource xaDS, boolean compliant) throws JMSException {
        AQjmsXATopicConnectionFactory xaTConnFact = null;
        xaTConnFact = new AQjmsXATopicConnectionFactory(xaDS);
        xaTConnFact.setCompliant(compliant);
        return xaTConnFact;
    }

    public static XATopicConnectionFactory getXATopicConnectionFactory(DataSource dsobj, AQjmsXAResourceFactory xaresFactory) throws JMSException {
        return new AQjmsXATopicConnectionFactory(dsobj, xaresFactory);
    }

    public static XATopicConnectionFactory getXATopicConnectionFactory(DataSource dsobj, AQjmsXAResourceFactory xaresFactory, boolean compliant) throws JMSException {
        AQjmsXATopicConnectionFactory xaTConnFact = null;
        xaTConnFact = new AQjmsXATopicConnectionFactory(dsobj, xaresFactory);
        xaTConnFact.setCompliant(compliant);
        return xaTConnFact;
    }

    public static XATopicConnectionFactory getXATopicConnectionFactory(String hostname, String oracle_sid, int portno, String driver) throws JMSException {
        return new AQjmsXATopicConnectionFactory(hostname, oracle_sid, portno, driver);
    }

    public static XATopicConnectionFactory getXATopicConnectionFactory(String hostname, String oracle_sid, int portno, String driver, boolean compliant) throws JMSException {
        AQjmsXATopicConnectionFactory xaTConnFact = null;
        xaTConnFact = new AQjmsXATopicConnectionFactory(hostname, oracle_sid, portno, driver);
        xaTConnFact.setCompliant(compliant);
        return xaTConnFact;
    }

    public static XATopicConnectionFactory getXATopicConnectionFactory(String jdbc_url, Properties info) throws JMSException {
        return new AQjmsXATopicConnectionFactory(jdbc_url, info);
    }

    public static XATopicConnectionFactory getXATopicConnectionFactory(String jdbc_url, Properties info, boolean compliant) throws JMSException {
        AQjmsXATopicConnectionFactory xaTConnFact = null;
        xaTConnFact = new AQjmsXATopicConnectionFactory(jdbc_url, info);
        xaTConnFact.setCompliant(compliant);
        return xaTConnFact;
    }

    static QueueConnectionFactory getQueueConnectionFactory(DataSource ds, String jdbc_url, Properties info) throws JMSException {
        AQjmsQueueConnectionFactory conn_fac = null;
        conn_fac = new AQjmsQueueConnectionFactory(ds, jdbc_url, info);
        return conn_fac;
    }

    static TopicConnectionFactory getTopicConnectionFactory(DataSource ds, String jdbc_url, Properties info) throws JMSException {
        AQjmsTopicConnectionFactory conn_fac = null;
        conn_fac = new AQjmsTopicConnectionFactory(ds, jdbc_url, info);
        return conn_fac;
    }

    static ConnectionFactory getConnectionFactory(DataSource ds, String jdbc_url, Properties info) throws JMSException {
        AQjmsConnectionFactory conn_fac = null;
        conn_fac = new AQjmsConnectionFactory(ds, jdbc_url, info);
        return conn_fac;
    }

    static XAQueueConnectionFactory getXAQueueConnectionFactory(DataSource ds, String jdbc_url, Properties info) throws JMSException {
        AQjmsXAQueueConnectionFactory conn_fac = null;
        conn_fac = new AQjmsXAQueueConnectionFactory(ds, jdbc_url, info);
        return conn_fac;
    }

    static XATopicConnectionFactory getXATopicConnectionFactory(DataSource ds, String jdbc_url, Properties info) throws JMSException {
        AQjmsXATopicConnectionFactory conn_fac = null;
        conn_fac = new AQjmsXATopicConnectionFactory(ds, jdbc_url, info);
        return conn_fac;
    }

    static XAConnectionFactory getXAConnectionFactory(DataSource ds, String jdbc_url, Properties info) throws JMSException {
        AQjmsXAConnectionFactory conn_fac = null;
        conn_fac = new AQjmsXAConnectionFactory(ds, jdbc_url, info);
        return conn_fac;
    }
}

