package cn.yw.operationcount.alarmcount.action;


import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.excel.ExcelCol;
import cn.base.excel.ExportEngine;
import cn.base.pdf.ExportPDF;
import cn.base.util.DateUtil;
import cn.base.util.LogConstants;
import cn.base.util.RHUtil;
import cn.base.util.StringUtil;
import cn.base.util.Struts2Utils;
import cn.yw.operationcount.alarmcount.service.YwalarmcountService;
import cn.yw.operationcount.alarmcount.service.YworderinfocountService;

@SuppressWarnings({"all"})
@Component("yworderinfocountAction")
public class YworderinfocountAction extends BaseAction{
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(YworderinfocountAction.class);
	
	@Autowired
	private YworderinfocountService service;
	
	/**
	 * ҳ  豸澯ͳ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listYworderinfocountByPage")
	public void listYworderinfocountByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			List<Map> list = service.query_Yworderinfocount(map);
			Integer totalCount = service.count_Yworderinfocount(map);
			map.clear();
			map.put("total", totalCount);
			map.put("rows", list);
			Struts2Utils.renderJson(map);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YworderinfocountAction-listYworderinfocountByPage-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ҳ   Чͳ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listYworderinfocountByPage")
	public void listorderefficientByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			List<Map> list = service.query_orderefficient(map);
			Integer totalCount = service.count_orderefficient(map);
			map.clear();
			map.put("total", totalCount);
			map.put("rows", list);
			Struts2Utils.renderJson(map);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YworderinfocountAction-count_orderefficient-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	// ״ͼ
	@OperateType(value = LogConstants.LOG_QUERY ,info ="count_showBar")
	public void count_showBar(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			List<Map> list = service.query_YworderinfocountList(map);			
			Struts2Utils.renderJson(list);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YworderinfocountAction-count_showBar-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	@OperateType(value = LogConstants.LOG_QUERY ,info ="count_showBar")
	public void orderefficient_showBar(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			List<Map> list = service.query_orderefficientList(map);			
			Struts2Utils.renderJson(list);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YworderinfocountAction-query_orderefficient-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	@OperateType(value = LogConstants.LOG_QUERY ,info ="count_Yworderinfocount")
	public void count_Yworderinfocount(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int total = service.count_Yworderinfocount(map);			
			Struts2Utils.renderJson(total);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YworderinfocountAction-count_Yworderinfocount-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	@OperateType(value = LogConstants.LOG_QUERY ,info ="count_Yworderinfocount")
	public void count_orderefficentcount(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int total = service.count_orderefficient(map);			
			Struts2Utils.renderJson(total);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YworderinfocountAction-count_orderefficient-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	/**
	 * Excel
	 */
	@OperateType(value = LogConstants.LOG_EXPORT ,info ="exp_Yworderinfocount")
	public void exp_Yworderinfocount(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			map.put("start",0 );
			map.put("limit",5000);
			List<Map> sList = service.query_YworderinfocountList(map);	
			Map footMap = new HashMap();
			if(RHUtil.isNotEmpty(sList)) {
				Integer zs = 0;
				Integer bhzs = 0;
				Integer gqzs = 0;
				Integer wwczs = 0;
				Integer ywczs = 0;
				Integer jswczs = 0;
				 
				for(Map smap : sList) {
					String gdzs = (String) smap.get("gdzs");
					String bhgd = (String) smap.get("bhgd");
					String gqgd = (String) smap.get("gqgd");
					String wwcgd = (String) smap.get("wwcgd");
					
					String ywcgd = (String) smap.get("ywcgd");
					String jswcgd = (String) smap.get("jswcgd");
					String wcl = "0";
					String jswcl = "0";
					if("0".equals(ywcgd)) {
						smap.put("wcl", wcl);
					}else {
						wcl = division(Integer.parseInt(ywcgd),Integer.parseInt(gdzs));
						smap.put("wcl", wcl);
					}
					if("0".equals(jswcgd)) {
						smap.put("jswcl", jswcl);
					}else {
						jswcl = division(Integer.parseInt(jswcgd),Integer.parseInt(gdzs));
						smap.put("jswcl", jswcl);
					}
						
					zs = zs + Integer.parseInt(gdzs);
					bhzs = bhzs + Integer.parseInt(bhgd);
					gqzs = gqzs + Integer.parseInt(gqgd);
					wwczs = wwczs + Integer.parseInt(wwcgd);
					ywczs = ywczs + Integer.parseInt(ywcgd);
					jswczs = jswczs + Integer.parseInt(jswcgd);
				}
				
				String zwcl = "0";
				String zjswcl = "0";
				if(zs != 0) {
					zwcl = division(ywczs,zs);
					zjswcl = division(jswczs,zs);
				}
				Map zmap = new HashMap();
				zmap.put("bmmc", "ܼ");
				zmap.put("gdzs", zs);
				zmap.put("bhgd", bhzs);
				zmap.put("gqgd", gqzs);
				zmap.put("wwcgd", wwczs);
				zmap.put("ywcgd", ywczs);
				zmap.put("wcl", zwcl);
				zmap.put("jswcgd", jswczs);
				zmap.put("jswcl", zjswcl);
				sList.add(zmap);
			}
			String[] zdbm = {"bmmc", "gdzs","bhgd","gqgd","wwcgd","ywcgd","wcl","jswcgd","jswcl"};                          
			String[] zdmc = {"", "","ع","𹤵","δɹ","ɹ","","ʱ","ʱ"};
			int excelNum = zdbm.length;
			ExcelCol[] cells = new ExcelCol[excelNum];
			for(int i=0;i<excelNum;i++){
				cells[i] = new ExcelCol();
				cells[i].setColKey(zdbm[i]);
				cells[i].setColName(zdmc[i]);
			}		
			SimpleDateFormat formart = new SimpleDateFormat("yyyy-MM-dd");   
        	String dateTime=formart.format(new Date()); 
			Map params = new HashMap();
			params.put("fileName", "򹤵ͳ-"+dateTime);
			params.put("sheetName", "򹤵ͳϢ");
			params.put("header", "򹤵ͳ(Ʊʱ䣺"+dateTime+")");
			new ExportEngine().exportCommData(params, cells, (ArrayList)sList, Struts2Utils.getResponse());
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YworderinfocountAction-exp_Yworderinfocount-error:" +e);
			
		}
	}
	/**
	 * pdf
	 */
	@OperateType(value = LogConstants.LOG_EXPORT ,info ="expPDF_Yworderinfocount")
	public void expPDF_Yworderinfocount(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			map.put("start",0 );
			map.put("limit",5000);
			List<Map> sList = service.query_YworderinfocountList(map);	
			//ͷ
			String[] header = {"", "","ع","𹤵","δɹ","ɹ","","ʱ","ʱ"};
			// ά
			String[][] expArr = null;
			if(RHUtil.isNotEmpty(sList)) {
				expArr = new String[sList.size()+1][header.length];
				Integer zs = 0,bhzs = 0,gqzs = 0,wwczs = 0,ywczs = 0,jswczs = 0;
				int index = 0;
				for(Map smap : sList) {
					String gdzs = (String) smap.get("gdzs");
					String bhgd = (String) smap.get("bhgd");
					String gqgd = (String) smap.get("gqgd");
					String wwcgd = (String) smap.get("wwcgd");
					String ywcgd = (String) smap.get("ywcgd");
					String jswcgd = (String) smap.get("jswcgd");
					String wcl = "0";
					String jswcl = "0";
					if("0".equals(ywcgd)) {
						smap.put("wcl", wcl);
					}else {
						wcl = division(Integer.parseInt(ywcgd),Integer.parseInt(gdzs));
						smap.put("wcl", wcl);
					}
					if("0".equals(jswcgd)) {
						smap.put("jswcl", jswcl);
					}else {
						jswcl = division(Integer.parseInt(jswcgd),Integer.parseInt(gdzs));
						smap.put("jswcl", jswcl);
					}
					expArr[index][0] = StringUtil.transEmpty(smap.get("bmmc")+"");
					expArr[index][1] = gdzs;
					expArr[index][2] = bhgd;
					expArr[index][3] = gqgd;
					expArr[index][4] = wwcgd;
					expArr[index][5] = ywcgd;
					expArr[index][6] = wcl;
					expArr[index][7] = jswcgd;
					expArr[index][8] = jswcl;
					index++;
					zs = zs + Integer.parseInt(gdzs);
					bhzs = bhzs + Integer.parseInt(bhgd);
					gqzs = gqzs + Integer.parseInt(gqgd);
					wwczs = wwczs + Integer.parseInt(wwcgd);
					ywczs = ywczs + Integer.parseInt(ywcgd);
					jswczs = jswczs + Integer.parseInt(jswcgd);
				}
				
				String zwcl = "0";
				String zjswcl = "0";
				if(zs != 0) {
					zwcl = division(ywczs,zs);
					zjswcl = division(jswczs,zs);
				}
				expArr[index][0] = "ܼ";
				expArr[index][1] = zs+"";
				expArr[index][2] = bhzs+"";
				expArr[index][3] = gqzs+"";
				expArr[index][4] = wwczs+"";
				expArr[index][5] = ywczs+"";
				expArr[index][6] = zwcl;
				expArr[index][7] = jswczs+"";
				expArr[index][8] = zjswcl;
			}
			SimpleDateFormat formart = new SimpleDateFormat("yyyy-MM-dd");   
			String dateTime=formart.format(new Date()); 
			Map params = new HashMap();
			params.put("fileName", "򹤵ͳ-"+dateTime);
			params.put("sheetName", "򹤵ͳϢ");
			params.put("header", "򹤵ͳ(Ʊʱ䣺"+DateUtil.currentDateTime()+")");
			new ExportPDF().exportCommPDF(params,header,new ArrayList(),0, expArr, Struts2Utils.getResponse());
//			new ExportEngine().exportCommData(params, cells, (ArrayList)sList, Struts2Utils.getResponse());
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YworderinfocountAction-expPDF_Yworderinfocount-error:" +e);
			
		}
	}
	
	/**
	 * Чʵexcel
	 */
	@OperateType(value = LogConstants.LOG_EXPORT ,info ="exp_orderefficentcount")
	public void exp_orderefficentcount(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			map.put("start",0 );
			map.put("limit",5000);
			List<Map> sList = service.query_orderefficientList(map);	
			Map footMap = new HashMap();
			if(RHUtil.isNotEmpty(sList)) {
				Integer zs = 0;
				Integer ytynzs = 0;
				Integer ytyszs = 0;
				Integer styszs = 0;
			
				for(Map smap : sList) {
					String gdzs = (String) smap.get("zs");
					String ytyn = (String) smap.get("ytyn");
					String ytys = (String) smap.get("ytys");
					String stys = (String) smap.get("stys");
					
					zs = zs + Integer.parseInt(gdzs);
					ytynzs = ytynzs + Integer.parseInt(ytyn);
					ytyszs = ytyszs + Integer.parseInt(ytys);
					styszs = styszs + Integer.parseInt(stys);
				}
				
				Map zmap = new HashMap();
				zmap.put("bmmc", "ܼ");
				zmap.put("zs", zs);
				zmap.put("ytyn", ytynzs);
				zmap.put("ytys", ytyszs);
				zmap.put("stys", styszs);
				
				sList.add(zmap);
			}
			String[] zdbm = {"bmmc", "zs","ytyn","ytys","stys"};                          
			String[] zdmc = {"", "","24Сʱڹ","1Ϲ","3Ϲ"};
			int excelNum = zdbm.length;
			ExcelCol[] cells = new ExcelCol[excelNum];
			for(int i=0;i<excelNum;i++){
				cells[i] = new ExcelCol();
				cells[i].setColKey(zdbm[i]);
				cells[i].setColName(zdmc[i]);
			}		
			SimpleDateFormat formart = new SimpleDateFormat("yyyy-MM-dd");   
        	String dateTime=formart.format(new Date()); 
			Map params = new HashMap();
			params.put("fileName", "Чͳ-"+dateTime);
			params.put("sheetName", "ЧͳϢ");
			params.put("header", "Чͳ(Ʊʱ䣺"+dateTime+")");
			new ExportEngine().exportCommData(params, cells, (ArrayList)sList, Struts2Utils.getResponse());
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YworderinfocountAction-exp_Yworderinfocount-error:" +e);
			
		}
	}
	/**
	 * Чʵpdf
	 */
	@OperateType(value = LogConstants.LOG_EXPORT ,info ="expPDF_orderefficentcount")
	public void expPDF_orderefficentcount(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			map.put("start",0 );
			map.put("limit",5000);
			List<Map> sList = service.query_orderefficientList(map);	
			
			//ͷ
			String[] header = {"", "","24Сʱڹ","1Ϲ","3Ϲ"};
			//
			String[][] expArr = null;
			if(RHUtil.isNotEmpty(sList)) {
				Integer zs = 0,ytynzs = 0,ytyszs = 0,styszs = 0;
				int index = 0;
				expArr = new String[sList.size()+1][header.length];
				for(Map smap : sList) {
					String gdzs = (String) smap.get("zs");
					String ytyn = (String) smap.get("ytyn");
					String ytys = (String) smap.get("ytys");
					String stys = (String) smap.get("stys");
					
					expArr[index][0] = StringUtil.transEmpty(smap.get("bmmc")+"");
					expArr[index][1] = gdzs;
					expArr[index][2] = ytyn;
					expArr[index][3] = ytys;
					expArr[index][4] = stys;
					index++;
					zs = zs + Integer.parseInt(gdzs);
					ytynzs = ytynzs + Integer.parseInt(ytyn);
					ytyszs = ytyszs + Integer.parseInt(ytys);
					styszs = styszs + Integer.parseInt(stys);
				}
				expArr[index][0] = "ܼ";
				expArr[index][1] = zs+"";
				expArr[index][2] = ytynzs+"";
				expArr[index][3] = ytyszs+"";
				expArr[index][4] = styszs+"";
				
			}
			
			SimpleDateFormat formart = new SimpleDateFormat("yyyy-MM-dd");   
			String dateTime=formart.format(new Date()); 
			Map params = new HashMap();
			params.put("fileName", "Чͳ-"+dateTime);
			params.put("sheetName", "ЧͳϢ");
			params.put("header", "Чͳ(Ʊʱ䣺"+DateUtil.currentDateTime()+")");
			new ExportPDF().exportCommPDF(params,header,new ArrayList(),0, expArr, Struts2Utils.getResponse());
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YworderinfocountAction-expPDF_Yworderinfocount-error:" +e);
			
		}
	}
	/**
     * תɰٷ
     * ǰ
     * @param  num1 ,num2  num1/num2
     * @return  rate  2λС
     */
    public static String  division(int num1,int num2){
        String rate="0.00%";
        //ʽʼλ
        String format="0.00";
        if(num2 != 0 && num1 != 0){
            DecimalFormat dec = new DecimalFormat(format);
            rate =  dec.format((double) num1 / num2*100)+"%";
            while(true){
                if(rate.equals(format+"%")){
                    format=format+"0";
                    DecimalFormat dec1 = new DecimalFormat(format);
                    rate =  dec1.format((double) num1 / num2*100)+"%";
                }else {
                    break;
                }
            }
        }else if(num1 != 0 && num2 == 0){
            rate = "100%";
        }
        return rate;
    }

}
