package cn.im.ptlxstore.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.excel.ExcelCol;
import cn.base.excel.ExportEngine;
import cn.base.util.CommUtils;
import cn.base.util.Constants;
import cn.base.util.LogConstants;
import cn.base.util.StringUtil;
import cn.base.util.Struts2Utils;
import cn.im.ptlxstore.service.PtlxccqzglService;

@SuppressWarnings({"all"})
@Component("ptlxccqzglAction")
public class PtlxccqzglAction extends BaseAction{
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(PtlxccqzglAction.class);
	
	@Autowired
	private PtlxccqzglService service;
	
	/**
	 * ҳ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listPtlxccqzglByPage")
	public void listPtlxccqzglByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			Struts2Utils.renderJson(this.service.listPtlxccqzglByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtlxccqzglAction - listPtlxccqzglByPage() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="count_Ptlxccqzgl")
	public void count_Ptlxccqzgl(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.count_Ptlxccqzgl(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtlxccqzglAction - count_Ptlxccqzgl() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ Ptlxccqzgl
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="query_Ptlxccqzgl")
	public void query_Ptlxccqzgl(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.query_Ptlxccqzgl(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtlxccqzglAction - query_Ptlxccqzgl() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ Ptlxccqzgl
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="query_Ptlxccqzgl")
	public void query_ptlxccqzgl_no(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.query_ptlxccqzgl_no(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtlxccqzglAction - query_ptlxccqzgl_no() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ѯ һPtlxccqzgl
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="get_Ptlxccqzgl")
	public void get_Ptlxccqzgl(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.get_Ptlxccqzgl(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtlxccqzglAction - query_Ptlxccqzgl() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ɾ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="deletePtlxccqzgl")
	public void delete_Ptlxccqzgl(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!CommUtils.isEmpty(map)){
				int result = service.delete_Ptlxccqzgl(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}else{
				 throw new Exception("ȷѡɾ¼!!!");
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtlxccqzglAction - delete_Ptlxccqzgl() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	

	/**
	 * 
	 */
	@OperateType(value = LogConstants.LOG_ADD ,info ="insert_Ptlxccqzgl")
	public void insert_Ptlxccqzgl(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			map.put("xh", StringUtil.getUUID());
			service.insert_Ptlxccqzgl(map);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtlxccqzglAction - listPtlxccqzglByPage() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ޸
	 */
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="update_Ptlxccqzgl")
	public void update_Ptlxccqzgl(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int result = service.update_Ptlxccqzgl(map);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtlxccqzglAction - update_Ptlxccqzgl() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ɾ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="batch_delete_Ptlxccqzgl")
	public void batch_delete_Ptlxccqzgl(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Map m = new HashMap();
			m.put("keyword", map.get("keyword").toString());
			int result = service.batch_delete_Ptlxccqzgl(m);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtlxccqzglAction - batch_delete_Ptlxccqzgl() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * Excel
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="exoprtExcel")
	public void exoprtExcel(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			map.put("start",0 );
			map.put("limit",5000);
			map = service.exportPtlxccqzgl(map);
			ExcelCol[] cells = new ExcelCol[2];
			cells[0] = new ExcelCol();
			cells[0].setColKey("ֶ");
			cells[0].setColName("ֶ");
			cells[1] = new ExcelCol();
			cells[1].setColKey("ֶ");
			cells[1].setColName("ֶ");
			Map params = new HashMap();
			params.put("fileName", "");
			params.put("sheetName", "");
			params.put("header", "");	
			new ExportEngine().exportCommData(params, cells, (ArrayList)map.get("rows"), Struts2Utils.getResponse());
		} catch (Exception e) {
			iLog.error("PtlxccqzglAction - exoprtExcel() : error === " +e);
			e.printStackTrace();
		}
	}
}
