package cn.yw.video.videoalarm.action;

 import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.excel.ExcelCol;
import cn.base.excel.ExportEngine;
import cn.base.excel.ExportExcel;
import cn.base.util.CommUtils;
import cn.base.util.Constants;
import cn.base.util.DateUtil;
import cn.base.util.LogConstants;
import cn.base.util.StringUtil;
import cn.base.util.Struts2Utils;
import cn.bsystem.ptuserrole.model.PtyhBean;
import cn.yw.video.videoalarm.service.YwvideotaskrunresultService;
import net.sf.json.JSONObject;

@SuppressWarnings({"all"})
@Component("ywvideotaskrunresultAction")
public class YwvideotaskrunresultAction extends BaseAction{
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(YwvideotaskrunresultAction.class);
	
	@Autowired
	private YwvideotaskrunresultService service;
	
	/**
	 * ҳ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listYwvideotaskrunresultByPage")
	public void listYwvideotaskrunresultByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			String deviceChoose = map.get("deviceChoose")+"";
			if(!("null".equals(deviceChoose) || StringUtils.isNotEmpty(deviceChoose))){
				String[] devices = map.get("deviceChoose").toString().split(",");
				map.put("devices",devices);
			}
			Struts2Utils.renderJson(this.service.listYwvideotaskrunresultByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwvideotaskrunresultAction-listYwvideotaskrunresultByPage-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ
	 */
	//@OperateType(value = LogConstants.LOG_QUERY ,info ="count_Ywvideotaskrunresult")
	public void count_Ywvideotaskrunresult(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.count_Ywvideotaskrunresult(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwvideotaskrunresultAction-count_Ywvideotaskrunresult-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ Ywvideotaskrunresult
	 */
	@OperateType(value = LogConstants.LOG_GET ,info ="query_Ywvideotaskrunresult")
	public void query_Ywvideotaskrunresult(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.query_Ywvideotaskrunresult(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwvideotaskrunresultAction-query_Ywvideotaskrunresult-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	/**
	 * ͳ
	 */
	@OperateType(value = LogConstants.LOG_GET ,info ="videoStatistics")
	public void videoStatistics(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.videoStatistics(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwvideotaskrunresultAction-videoStatistics-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	/**
	 * 豸ͳ
	 */
	@OperateType(value = LogConstants.LOG_GET ,info ="videoStatisticsLine")
	public void videoStatisticsLine(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.videoStatisticsLine(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwvideotaskrunresultAction-videoStatisticsLine-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ һYwvideotaskrunresult
	 */
	@OperateType(value = LogConstants.LOG_GET ,info ="get_Ywvideotaskrunresult")
	public void get_Ywvideotaskrunresult(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.get_Ywvideotaskrunresult(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwvideotaskrunresultActionquery_Ywvideotaskrunresult-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ɾ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="deleteYwvideotaskrunresult")
	public void delete_Ywvideotaskrunresult(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!CommUtils.isEmpty(map)){
				int result = service.delete_Ywvideotaskrunresult(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}else{
				 throw new Exception("ȷѡɾ¼!!!");
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwvideotaskrunresultAction-delete_Ywvideotaskrunresult-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}

	/**
	 * 
	 */
	@OperateType(value = LogConstants.LOG_ADD ,info ="insert_Ywvideotaskrunresult")
	public void insert_Ywvideotaskrunresult(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(StringUtil.checkEmpty(map.get("id"))){
				map.put("id",StringUtil.getUUID());
			}
			if(!StringUtil.checkEmpty(map.get("checkparam"))){
				Map sMap = new HashMap();
				sMap.put("tableparam", map.get("checkparam"));
				List ls = service.query_Ywvideotaskrunresult(sMap);
				if(!StringUtil.checkEmpty(ls)||ls.size()>0){
					Struts2Utils.renderJson(Constants.SAME);
				}else{
					service.insert_Ywvideotaskrunresult(map);
					Struts2Utils.renderJson(Constants.SUCCESS);
				}
			}else{
				service.insert_Ywvideotaskrunresult(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}			
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwvideotaskrunresultAction-insert_Ywvideotaskrunresult()-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ޸
	 */
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="update_Ywvideotaskrunresult")
	public void update_Ywvideotaskrunresult(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!StringUtil.checkEmpty(map.get("checkparam"))){
				Map sMap = new HashMap();
				sMap.put("tableparam", map.get("checkparam"));
				List ls = service.query_Ywvideotaskrunresult(sMap);
				if(!StringUtil.checkEmpty(ls)||ls.size()>0){
					Struts2Utils.renderJson(Constants.SAME);
				}else{
					int result = service.update_Ywvideotaskrunresult(map);
					Struts2Utils.renderJson(Constants.SUCCESS);
				}
			}else{
				int result = service.update_Ywvideotaskrunresult(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwvideotaskrunresultAction-update_Ywvideotaskrunresult-error: " +e);
			Struts2Utils.renderJson(null);
		}
	}
	/**
	 * ±ע״̬
	 */
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="updateVideolabelStatus")
	public void updateVideolabelStatus(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			String id = (String) map.get("XGTJid");
			if(StringUtils.isEmpty(id)){
				Struts2Utils.renderJson(null);
				return;
			}
			String username = ((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo")).getYhzh();
			String time = DateUtil.currentDateTime();
			map.put("videolabeltime", time);
			map.put("videolabelaccount", username);
			map.put("modifyaccount", username);
			map.put("modifytime", time);
			int result = service.update_Ywvideotaskrunresult(map);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwvideotaskrunresultAction-updateVideolabelStatus-error: " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ɾ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="batch_delete_Ywvideotaskrunresult")
	public void batch_delete_Ywvideotaskrunresult(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Map m = new HashMap();
			m.put("keyword", map.get("keyword").toString());
			int result = service.batch_delete_Ywvideotaskrunresult(m);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwvideotaskrunresultAction-batch_delete_Ywvideotaskrunresult-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * Excel
	 */
	@OperateType(value = LogConstants.LOG_EXPORT ,info ="exp_Ywvideotaskrunresult")
	public void exp_Ywvideotaskrunresult(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			Map queryMap = JSONObject.fromObject(map.get("downParam"));
			queryMap.put("start",0 );
			queryMap.put("limit",5000);
			List<String> headerList = new ArrayList<String>();
			headerList.add("id");
			headerList.add("id");
			headerList.add("");
			headerList.add("");
			headerList.add("ͨid");
			List<Map> sList = service.query_Ywvideotaskrunresult(queryMap);		
			List<Map> expList = new ArrayList<Map>();
			String username = ((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo")).getYhzh();
			for(Map m : sList){
				Map exportMap = new HashMap();
				exportMap.put("id", m.get("runsetid"));
				exportMap.put("id", m.get("taskid"));
				exportMap.put("", m.get("tasktypename"));
				exportMap.put("ͨid", m.get("channelsetid"));
//				exportMap.put("yhzh", m.get("yhzh"));
//				exportMap.put("yhzh", username);
				expList.add(exportMap);
			}
			SimpleDateFormat formart = new SimpleDateFormat("yyyy-MM-dd");   
			String dateTime=formart.format(new Date()); 
			Map params = new HashMap();
			params.put("fileName", "ά-"+dateTime);
			params.put("sheetName", "ά");
			params.put("header", "ά");	
//			new ExportEngine().exportCommData(params, cells, (ArrayList)map.get("rows"), Struts2Utils.getResponse());
			new ExportExcel().exportCommExcel(params,headerList,new ArrayList(), expList, Struts2Utils.getResponse());
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwvideotaskrunresultAction-exoprtExcel-error:" +e);
			
		}
	}
	/*@OperateType(value = LogConstants.LOG_EXPORT ,info ="exp_Ywvideotaskrunresult")
	public void exp_Ywvideotaskrunresult(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			map.put("start",0 );
			map.put("limit",5000);
			List<Map> sList = service.query_Ywvideotaskrunresult(map);		
			List<HashMap> expList = new ArrayList<HashMap>();
			String username = ((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo")).getYhzh();
			for(Map m : sList){
				Map exportMap = new HashMap();
//				exportMap.put("yhzh", m.get("yhzh"));
				exportMap.put("yhzh", username);
				expList.add((HashMap) exportMap);
			}
			int excelNum = 2;
			ExcelCol[] cells = new ExcelCol[excelNum];
			String[] zdbm = {"yhzh", "yhmc",};
			String[] zdmc = {"û˺", "û"};
			for(int i=0;i<excelNum;i++){
				cells[i] = new ExcelCol();
				cells[i].setColKey(zdbm[i]);
				cells[i].setColName(zdmc[i]);
			}		
			SimpleDateFormat formart = new SimpleDateFormat("yyyy-MM-dd");   
        	String dateTime=formart.format(new Date()); 
			Map params = new HashMap();
			params.put("fileName", "ά-"+dateTime);
			params.put("sheetName", "ά");
			params.put("header", "ά");	
//			new ExportEngine().exportCommData(params, cells, (ArrayList)map.get("rows"), Struts2Utils.getResponse());
			new ExportEngine().exportCommData(params, cells, expList, Struts2Utils.getResponse());
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwvideotaskrunresultAction-exoprtExcel-error:" +e);
			
		}
	}*/
	
	/**
	 * Excel
	 */
	/*
	//@OperateType(value = LogConstants.LOG_IMPORT ,info ="imp_Ywvideotaskrunresult")
	public String imp_Ywvideotaskrunresult(String excelFile,Object user) {
		String rs = "ʽ!";
		int rowNum = 0;
		int dataCount = 0;
		int successNum = 0;
		int repeatNum = 0;
		int failNum = 0;
		try {
		
			ExcelReader readExcel = new ExcelReader();
			readExcel.openFile(excelFile);
			readExcel.setSheetNum(0);
			int count = readExcel.getRowCount();
			iLog.info("count--->" + count);
			rs = " ݳɹܹ"+ dataCount +",ظ"+repeatNum+"ݣʧ"+failNum+"!";
			File file = new File(excelFile);
			if(file.exists()){
				file.delete();
			}
		} catch (Exception e) {
			if (rowNum > 3) {
				rs = "Դֵ()ʧܣExcel" + rowNum + "δ()ɹ";
			} else {
				rs = "Դ()ʧܣ";
			}
			iLog.error("YwvideotaskrunresultAction-imp_Ywvideotaskrunresult-error:" +e);
			e.printStackTrace();
		}		
		return rs;
	}
	*/
}
