/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.http;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.NoBodyResponse;

public abstract class HttpServlet
extends GenericServlet
implements Serializable {
    private static final String METHOD_DELETE = "DELETE";
    private static final String METHOD_HEAD = "HEAD";
    private static final String METHOD_GET = "GET";
    private static final String METHOD_OPTIONS = "OPTIONS";
    private static final String METHOD_POST = "POST";
    private static final String METHOD_PUT = "PUT";
    private static final String METHOD_TRACE = "TRACE";
    private static final String HEADER_IFMODSINCE = "If-Modified-Since";
    private static final String HEADER_LASTMOD = "Last-Modified";
    private static final String LSTRING_FILE = "javax.servlet.http.LocalStrings";
    private static ResourceBundle lStrings = ResourceBundle.getBundle("javax.servlet.http.LocalStrings");

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getProtocol();
        String string2 = lStrings.getString("http.method_get_not_supported");
        if (string.endsWith("1.1")) {
            httpServletResponse.sendError(405, string2);
        } else {
            httpServletResponse.sendError(400, string2);
        }
    }

    protected long getLastModified(HttpServletRequest httpServletRequest) {
        return -1L;
    }

    protected void doHead(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        NoBodyResponse noBodyResponse = new NoBodyResponse(httpServletResponse);
        this.doGet(httpServletRequest, noBodyResponse);
        noBodyResponse.setContentLength();
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getProtocol();
        String string2 = lStrings.getString("http.method_post_not_supported");
        if (string.endsWith("1.1")) {
            httpServletResponse.sendError(405, string2);
        } else {
            httpServletResponse.sendError(400, string2);
        }
    }

    protected void doPut(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getProtocol();
        String string2 = lStrings.getString("http.method_put_not_supported");
        if (string.endsWith("1.1")) {
            httpServletResponse.sendError(405, string2);
        } else {
            httpServletResponse.sendError(400, string2);
        }
    }

    protected void doDelete(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getProtocol();
        String string2 = lStrings.getString("http.method_delete_not_supported");
        if (string.endsWith("1.1")) {
            httpServletResponse.sendError(405, string2);
        } else {
            httpServletResponse.sendError(400, string2);
        }
    }

    private Method[] getAllDeclaredMethods(Class clazz) {
        if (clazz.getName().equals("javax.servlet.http.HttpServlet")) {
            return null;
        }
        int n = 0;
        Method[] methodArray = this.getAllDeclaredMethods(clazz.getSuperclass());
        Method[] methodArray2 = clazz.getDeclaredMethods();
        if (methodArray != null) {
            Method[] methodArray3 = new Method[methodArray.length + methodArray2.length];
            int n2 = 0;
            while (n2 < methodArray.length) {
                methodArray3[n2] = methodArray[n2];
                n = n2++;
            }
            for (n2 = ++n; n2 < methodArray2.length + n; ++n2) {
                methodArray3[n2] = methodArray2[n2 - n];
            }
            return methodArray3;
        }
        return methodArray2;
    }

    protected void doOptions(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Method[] methodArray = this.getAllDeclaredMethods(this.getClass());
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = true;
        boolean bl7 = true;
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            if (method.getName().equals("doGet")) {
                bl = true;
                bl2 = true;
            }
            if (method.getName().equals("doPost")) {
                bl3 = true;
            }
            if (method.getName().equals("doPut")) {
                bl4 = true;
            }
            if (!method.getName().equals("doDelete")) continue;
            bl5 = true;
        }
        String string = null;
        if (bl && string == null) {
            string = METHOD_GET;
        }
        if (bl2) {
            string = string == null ? METHOD_HEAD : string + ", HEAD";
        }
        if (bl3) {
            string = string == null ? METHOD_POST : string + ", POST";
        }
        if (bl4) {
            string = string == null ? METHOD_PUT : string + ", PUT";
        }
        if (bl5) {
            string = string == null ? METHOD_DELETE : string + ", DELETE";
        }
        if (bl6) {
            string = string == null ? METHOD_TRACE : string + ", TRACE";
        }
        if (bl7) {
            string = string == null ? METHOD_OPTIONS : string + ", OPTIONS";
        }
        httpServletResponse.setHeader("Allow", string);
    }

    protected void doTrace(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        String string = "\r\n";
        String string2 = "TRACE " + httpServletRequest.getRequestURI() + " " + httpServletRequest.getProtocol();
        Enumeration enumeration = httpServletRequest.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            string2 = string2 + string + (String)object + ": " + httpServletRequest.getHeader((String)object);
        }
        string2 = string2 + string;
        int n = string2.length();
        httpServletResponse.setContentType("message/http");
        httpServletResponse.setContentLength(n);
        object = httpServletResponse.getOutputStream();
        ((ServletOutputStream)object).print(string2);
        ((OutputStream)object).close();
    }

    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getMethod();
        if (string.equals(METHOD_GET)) {
            long l = this.getLastModified(httpServletRequest);
            if (l == -1L) {
                this.doGet(httpServletRequest, httpServletResponse);
            } else {
                long l2 = httpServletRequest.getDateHeader(HEADER_IFMODSINCE);
                if (l2 < l / 1000L * 1000L) {
                    this.maybeSetLastModified(httpServletResponse, l);
                    this.doGet(httpServletRequest, httpServletResponse);
                } else {
                    httpServletResponse.setStatus(304);
                }
            }
        } else if (string.equals(METHOD_HEAD)) {
            long l = this.getLastModified(httpServletRequest);
            this.maybeSetLastModified(httpServletResponse, l);
            this.doHead(httpServletRequest, httpServletResponse);
        } else if (string.equals(METHOD_POST)) {
            this.doPost(httpServletRequest, httpServletResponse);
        } else if (string.equals(METHOD_PUT)) {
            this.doPut(httpServletRequest, httpServletResponse);
        } else if (string.equals(METHOD_DELETE)) {
            this.doDelete(httpServletRequest, httpServletResponse);
        } else if (string.equals(METHOD_OPTIONS)) {
            this.doOptions(httpServletRequest, httpServletResponse);
        } else if (string.equals(METHOD_TRACE)) {
            this.doTrace(httpServletRequest, httpServletResponse);
        } else {
            String string2 = lStrings.getString("http.method_not_implemented");
            Object[] objectArray = new Object[]{string};
            string2 = MessageFormat.format(string2, objectArray);
            httpServletResponse.sendError(501, string2);
        }
    }

    private void maybeSetLastModified(HttpServletResponse httpServletResponse, long l) {
        if (httpServletResponse.containsHeader(HEADER_LASTMOD)) {
            return;
        }
        if (l >= 0L) {
            httpServletResponse.setDateHeader(HEADER_LASTMOD, l);
        }
    }

    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        HttpServletResponse httpServletResponse;
        HttpServletRequest httpServletRequest;
        try {
            httpServletRequest = (HttpServletRequest)servletRequest;
            httpServletResponse = (HttpServletResponse)servletResponse;
        }
        catch (ClassCastException classCastException) {
            throw new ServletException("non-HTTP request or response");
        }
        this.service(httpServletRequest, httpServletResponse);
    }
}

