package cn.bsystem.ptuserrole.action;

import java.util.HashMap;
import java.util.Map;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.util.CommUtils;
import cn.base.util.Constants;
import cn.base.util.LogConstants;
import cn.base.util.StringUtil;
import cn.base.util.Struts2Utils;
import cn.bsystem.ptmenu.util.MenuXml;
import cn.bsystem.ptuserrole.service.PtcdjsService;

@SuppressWarnings({ "all" })
@Component("ptcdjsAction")
public class PtcdjsAction extends BaseAction {
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(PtcdjsAction.class);

	@Autowired
	private PtcdjsService service;

	/**
	 * ҳ
	 */
	@OperateType(value = LogConstants.LOG_QUERY, info = "listPtcdjsByPage")
	public void listPtcdjsByPage() {
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ((page == 0 ? 1 : page) - 1) * rows;
			int limit = start + rows;
			map.put("start", start);
			map.put("limit", limit);
			Struts2Utils.renderJson(this.service.listPtcdjsByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtcdjsAction - listPtcdjsByPage() : error === " + e);
			Struts2Utils.renderJson(null);
		}
	}

	/**
	 * ѯ
	 */
	@OperateType(value = LogConstants.LOG_QUERY, info = "count_Ptcdjs")
	public void count_Ptcdjs() {
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.count_Ptcdjs(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtcdjsAction - count_Ptcdjs() : error === " + e);
			Struts2Utils.renderJson(null);
		}
	}

	/**
	 * ѯ Ptcdjs
	 */
	@OperateType(value = LogConstants.LOG_QUERY, info = "query_Ptcdjs")
	public void query_Ptcdjs() {
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.query_Ptcdjs(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtcdjsAction - query_Ptcdjs() : error === " + e);
			Struts2Utils.renderJson(null);
		}
	}

	/**
	 * ѯ һPtcdjs
	 */
	@OperateType(value = LogConstants.LOG_QUERY, info = "get_Ptcdjs")
	public void get_Ptcdjs() {
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.get_Ptcdjs(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtcdjsAction - query_Ptcdjs() : error === " + e);
			Struts2Utils.renderJson(null);
		}
	}

	/**
	 * ɾ
	 */
	@OperateType(value = LogConstants.LOG_DELETE, info = "deletePtcdjs")
	public void delete_Ptcdjs() {
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if (!CommUtils.isEmpty(map)) {
				int result = service.delete_Ptcdjs(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			} else {
				throw new Exception("ȷѡɾ¼!!!");
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtcdjsAction - delete_Ptcdjs() : error === " + e);
			Struts2Utils.renderJson(null);
		}
	}

	/**
	 * 
	 */
	@OperateType(value = LogConstants.LOG_ADD, info = "insert_Ptcdjs")
	public void insert_Ptcdjs() {
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			map.put("jsbh", StringUtil.getUUID());
			map.put("ssxm", MenuXml.getInstance().getMenuType());
			service.insert_Ptcdjs(map);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtcdjsAction - insert_Ptcdjs() : error === " + e);
			Struts2Utils.renderJson(null);
		}
	}

	/**
	 * ޸
	 */
	@OperateType(value = LogConstants.LOG_UPDATE, info = "update_Ptcdjs")
	public void update_Ptcdjs() {
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int result = service.update_Ptcdjs(map);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtcdjsAction - update_Ptcdjs() : error === " + e);
			Struts2Utils.renderJson(null);
		}
	}

	public void getPtcdjsMemuListByJSBH() {
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			System.out.println(map.toString());
			Struts2Utils.renderJson(this.service.getPtcdjsMemuListByJSBH(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtcdjsAction - getPtcdjsMemuListByJSBH() : error === " + e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ޸
	 */
	@OperateType(value = LogConstants.LOG_UPDATE, info = "update_PtcdjsMenuIdByJSBH")
	public void update_PtcdjsMenuIdByJSBH() {
		Integer action = 1;
		try {
			String menuType =MenuXml.getInstance().getMenuType();
			String jsbh = Struts2Utils.getParameter("jsbh");
			String menuIds = Struts2Utils.getParameter("menuIds");
			String rightIds = Struts2Utils.getParameter("rightIds");
			Map menuGroup = new HashMap();
			menuGroup.put("jsbh", jsbh);
			
			Integer deletecount = service.deletePtcdjsMenuIdByJSBH(menuGroup);
			 
			if(deletecount>=0){
				HashMap m = null;
				String[] arr = menuIds.split(",");
				String[] arrRights = rightIds.split(",");
				for (int i = 0; i < arr.length; i++) {
					m = new HashMap();
					m.put("xh", StringUtil.getUUID());
					m.put("cdbh", arr[i].trim());
					m.put("ssxm", menuType);
					m.put("jsbh", jsbh);
					
					//˵Ȩʱ
//					if(null != arrRights[i] && !"_".equals(arrRights[i])){
//						m.put("rightName", arrRights[i]);
//					}else{
//						m.put("rightName","");
//					}
					service.insert_ptcdjsMenuIdByJSBH(m);
				}			
			}
		} catch (Exception e) {
			action = 0;
			iLog.error("update_PtcdjsMenuIdByJSBH", e);
			e.printStackTrace();
		}
		Struts2Utils.renderJson(String.valueOf(action));
	}
}
