package cn.base.excel;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

/**
 * ȡExcel
 * @author redhightree
 *
 */
public class ExcelImport {
    private Workbook wb = null;//book [includes sheet]
    private HSSFSheet sheet = null;
    private HSSFRow row = null;
    private HSSFCell cell = null; //cell,the content which contains
    
//    private XSSFWorkbook xwb = null;//book [includes sheet]
    private XSSFSheet xsheet = null;
    private XSSFRow xrow = null;
    private XSSFCell xcell = null; //cell,the content which contains
    
    private int sheetNum = 0;	//sheetnum
    private int rowNum = 0;
    private FileInputStream fis = null;
    private String fileName = "";

    public ExcelImport() {
    }

    public ExcelImport(String fileName) {
        openFile(fileName);
    }

    public void setRowNum(int rowNum) {
        this.rowNum = rowNum;
    }

    public void setSheetNum(int sheetNum) {
        this.sheetNum = sheetNum;
    }

    /**
     * ȡexcelļHSSFWorkbook
     * @param fileName
     */
    public void openFile(String fileName) {
        this.fileName = fileName;
        File f = new File(fileName);
        if (f.exists()) {
            try {
                fis = new FileInputStream(f);
                if(fileName.endsWith("xlsx")) {
                	wb = new XSSFWorkbook(fis);
                }else {
                	wb = new HSSFWorkbook(fis);
                }
                fis.close();
            } catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("========>>>>>>>excel File  not exist");
        }
    }

    /**
     * sheetĿ
     * @return int
     */
    public int getSheetCount() {
        int sheetCount = -1;
        sheetCount = wb.getNumberOfSheets();
        return sheetCount;
    }

    /**
     * sheetNumµļ¼
     * @return int
     */
    public int getRowCount() {
        if(null == wb) {
        	return 0;
        }
        int rowCount = -1;
        if(fileName.endsWith("xlsx")) {
        	XSSFSheet xsheet = (XSSFSheet) wb.getSheetAt(this.sheetNum);           
            rowCount = xsheet.getLastRowNum()+1;
        }else {
        	HSSFSheet sheet = (HSSFSheet) wb.getSheetAt(this.sheetNum);           
            rowCount = sheet.getLastRowNum()+1;
        }       
        return rowCount;
    }

    /**
     * ȡָsheetNumrowCount
     * @param sheetNum
     * @return int
     */
    public int getRowCount(int sheetNum) {
    	 int rowCount = -1;
    	 if(fileName.endsWith("xlsx")) {
    		XSSFSheet xsheet = (XSSFSheet) wb.getSheetAt(sheetNum);      
     	    rowCount = xsheet.getLastRowNum();
    	 }else {
    		HSSFSheet sheet = (HSSFSheet) wb.getSheetAt(sheetNum);      
    	    rowCount = sheet.getLastRowNum();
    	 }
       
        return rowCount;
    }

    /**
     * õָе
     * @param lineNum
     * @return String[]
     */
    public String[] readExcelLine(int lineNum,int colNum) {
        return readExcelLine(this.sheetNum, lineNum,colNum);
    }

    /**
     * ָ
     * @param sheetNum
     * @param lineNum
     * @param colNum    ƶк  added by wangxiaohui
     * @return String[]
     */
    public String [] readExcelLine(int sheetNum, int lineNum,int colNum) {
        if (sheetNum < 0 || lineNum < 0) return null;
        String[] strExcelLine = null;
        try {
        	if(fileName.endsWith("xlsx")) {
        		xsheet = (XSSFSheet) wb.getSheetAt(sheetNum);
                xrow = xsheet.getRow(lineNum);
                if(xrow==null)return strExcelLine;
                int cellCount = xsheet.getRow(xsheet.getFirstRowNum()).getLastCellNum();
                strExcelLine = new String[cellCount];
                	//ѭֱӶȡָУЧ   modified by wangxiaohui
                    int i=colNum;
                    strExcelLine[i] = "";
                    if (null != xrow.getCell((short) i)) {
                        switch (xrow.getCell((short) i).getCellType()) {
                            case XSSFCell.CELL_TYPE_FORMULA :
                                strExcelLine[i] = "FORMULA ";
                                break;
                            case XSSFCell.CELL_TYPE_NUMERIC :
                                strExcelLine[i] = String.valueOf(xrow.getCell((short) i).getNumericCellValue());
                                break;
                            case XSSFCell.CELL_TYPE_STRING :
                                strExcelLine[i] = xrow.getCell((short) i).getStringCellValue();
                                break;
                            case XSSFCell.CELL_TYPE_BLANK :
                                strExcelLine[i] = "";
                                break;
                            default :
                                strExcelLine[i] = "";
                                break;
                        }
                        //ȡǿѧĸʽתΪͨʽ
                        //added by wangtongjun at 20060626
                        if (null != strExcelLine[i] &&
                            strExcelLine[i].indexOf(".") != -1 &&
                            strExcelLine[i].indexOf("E") != -1) {
                            DecimalFormat df = new DecimalFormat();
                            strExcelLine[i] = df.parse(strExcelLine[i]).toString();
                        }
                        //ȡָʽ".0"βʽתΪͨʽ
                        if (null != strExcelLine &&
                                strExcelLine[i].endsWith(".0")) {
                            int size = strExcelLine[i].length();
                            strExcelLine[i] = strExcelLine[i].substring(0, size - 2);
                        }
                    }
        	}else {
        		sheet = (HSSFSheet) wb.getSheetAt(sheetNum);
                row = sheet.getRow(lineNum);
                if(row==null)return strExcelLine;
                int cellCount = sheet.getRow(sheet.getFirstRowNum()).getLastCellNum();
                strExcelLine = new String[cellCount];
                	//ѭֱӶȡָУЧ   modified by wangxiaohui
                    int i=colNum;
                    strExcelLine[i] = "";
                    if (null != row.getCell((short) i)) {
                        switch (row.getCell((short) i).getCellType()) {
                            case HSSFCell.CELL_TYPE_FORMULA :
                                strExcelLine[i] = "FORMULA ";
                                break;
                            case HSSFCell.CELL_TYPE_NUMERIC :
                                strExcelLine[i] = String.valueOf(row.getCell((short) i).getNumericCellValue());
                                break;
                            case HSSFCell.CELL_TYPE_STRING :
                                strExcelLine[i] = row.getCell((short) i).getStringCellValue();
                                break;
                            case HSSFCell.CELL_TYPE_BLANK :
                                strExcelLine[i] = "";
                                break;
                            default :
                                strExcelLine[i] = "";
                                break;
                        }
                        //ȡǿѧĸʽתΪͨʽ
                        //added by wangtongjun at 20060626
                        if (null != strExcelLine[i] &&
                            strExcelLine[i].indexOf(".") != -1 &&
                            strExcelLine[i].indexOf("E") != -1) {
                            DecimalFormat df = new DecimalFormat();
                            strExcelLine[i] = df.parse(strExcelLine[i]).toString();
                        }
                        //ȡָʽ".0"βʽתΪͨʽ
                        if (null != strExcelLine &&
                                strExcelLine[i].endsWith(".0")) {
                            int size = strExcelLine[i].length();
                            strExcelLine[i] = strExcelLine[i].substring(0, size - 2);
                        }
                    }
        	}
            
        } catch (Exception e) {
            e.printStackTrace();
        }
        return strExcelLine;
    }

    /**
     * ȡָе
     * @param cellNum
     * @return String 
     */
    public String readStringExcelCell(int cellNum) {
        return readStringExcelCell(this.rowNum, cellNum);
    }
    
    /**
     * ָкбŵ
     * @param rowNum
     * @param cellNum
     * @return String 
     */
    public String readStringExcelCell(int rowNum, int cellNum) {
        return readStringExcelCell(this.sheetNum, rowNum, cellNum);
    }

    /**
     * ָСµ
     * @param sheetNum
     * @param rowNum
     * @param cellNum
     * @return String
     */
    public String readStringExcelCell(int sheetNum, int rowNum, int cellNum) {
        String strExcelCell = "";
        if (sheetNum < 0 || rowNum < 0) return null;
        try {
            if(fileName.endsWith("xlsx")) {
            	xsheet = (XSSFSheet) wb.getSheetAt(sheetNum);
                xrow = xsheet.getRow(rowNum);
                if (null != xrow.getCell((short) cellNum)) { //add this condition judge
                    switch (xrow.getCell((short) cellNum).getCellType()) {
                        case XSSFCell.CELL_TYPE_FORMULA :
                            strExcelCell = "FORMULA ";
                            break;
                        case XSSFCell.CELL_TYPE_NUMERIC : {
                            strExcelCell = String.valueOf(xrow.getCell((short) cellNum).getNumericCellValue());
                        }
                        break;
                        case HSSFCell.CELL_TYPE_STRING :
                            strExcelCell = xrow.getCell((short) cellNum).getStringCellValue();
                            break;
                        default :
                    }
                    //ȡǿѧĸʽתΪͨʽ
                    if (null != strExcelCell &&
                            strExcelCell.indexOf(".") != -1 &&
                            strExcelCell.indexOf("E") != -1) {
                        DecimalFormat df = new DecimalFormat();
                        strExcelCell = df.parse(strExcelCell).toString();
                    }
                    //ȡָʽ".0"βʽתΪͨʽ
                    //added by wangtongjun at 20060713
                    if (null != strExcelCell &&
                            strExcelCell.endsWith(".0")) {
                        int size = strExcelCell.length();
                        strExcelCell = strExcelCell.substring(0, size - 2);
                    }
                }
            }else {
            	sheet = (HSSFSheet) wb.getSheetAt(sheetNum);
                row = sheet.getRow(rowNum);
                if (null != row.getCell((short) cellNum)) { //add this condition judge
                    switch (row.getCell((short) cellNum).getCellType()) {
                        case HSSFCell.CELL_TYPE_FORMULA :
                            strExcelCell = "FORMULA ";
                            break;
                        case HSSFCell.CELL_TYPE_NUMERIC : {
                            strExcelCell = String.valueOf(row.getCell((short) cellNum).getNumericCellValue());
                        }
                        break;
                        case HSSFCell.CELL_TYPE_STRING :
                            strExcelCell = row.getCell((short) cellNum).getStringCellValue();
                            break;
                        default :
                    }
                    //ȡǿѧĸʽתΪͨʽ
                    if (null != strExcelCell &&
                            strExcelCell.indexOf(".") != -1 &&
                            strExcelCell.indexOf("E") != -1) {
                        DecimalFormat df = new DecimalFormat();
                        strExcelCell = df.parse(strExcelCell).toString();
                    }
                    //ȡָʽ".0"βʽתΪͨʽ
                    //added by wangtongjun at 20060713
                    if (null != strExcelCell &&
                            strExcelCell.endsWith(".0")) {
                        int size = strExcelCell.length();
                        strExcelCell = strExcelCell.substring(0, size - 2);
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return strExcelCell;
    }

    public void writeExcelLine(String fileName, String[] strLine) {
        try {
            File f = new File(fileName + ".xls");
            if (f.isFile()) {
                FileOutputStream fileOut = new FileOutputStream(f);
                sheet = (HSSFSheet) wb.createSheet("Sheet1");
                row = sheet.createRow(0);
                int cellNum = strLine.length;
                for (int i = 0; i < cellNum; i++) {
                    row.createCell((short) i).setCellValue(strLine[i]);
                }
                wb.write(fileOut);
                fileOut.close();
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
        }
    }

    public void writeExcelLine(String fileName, String[] strLine, int iRownum) {
        try {
            File f = new File(fileName + ".xls");
            if (f.isFile()) {
                FileOutputStream fileOut = new FileOutputStream(f);
                sheet = (HSSFSheet) wb.getSheet("Sheet1");
                if (null == sheet) {
                    sheet = (HSSFSheet) wb.createSheet("Sheet1");
                }
                row = sheet.createRow(iRownum);
                int cellNum = strLine.length;
                for (int i = 0; i < cellNum; i++) {
                    HSSFCell cell = row.createCell((short)i);
                    //cell.setEncoding(HSSFCell.ENCODING_UTF_16);
                    cell.setCellValue(strLine[i]);
                }
                wb.write(fileOut);
                fileOut.close();
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
        }
    }

    public void writeExcelCell(int sheetNum, int rowNum, int cellNum, String strCell) {
        sheet = (HSSFSheet) wb.getSheetAt(sheetNum);
        row = sheet.getRow(rowNum);
        cell = row.getCell((short) cellNum);
        cell.setCellValue(strCell);
        try {
            File f = new File(fileName);
            if (f.isFile()) {
                FileOutputStream fileOut = new FileOutputStream(f);
                sheet = (HSSFSheet) wb.createSheet("Sheet1");
                row = sheet.createRow(1);
                //int cellNum=strLine.length;
                for (int i = 0; i < 10; i++) {
                    //row.createCell((short)i).setCellValue(strLine[i]);
                }
                wb.write(fileOut);
                fileOut.close();
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
        }
    }

    public static void main(String args[]) throws Exception {
        ExcelImport readExcel = new ExcelImport();
        readExcel.openFile("C:\\all.xls");
        readExcel.setSheetNum(0);	//öȡΪ0Ĺ
        //
        int count = readExcel.getRowCount();
        System.out.println(readExcel.readStringExcelCell(1, 5));
        for (int i = 0; i <= count; i++) {
            String[] rows = readExcel.readExcelLine(i,1);
            if(rows==null||rows.length<1)return;
            for (int j = 0; j < rows.length; j++) {
                System.out.print(j+" "+rows[j]+"  ");
            }
            System.out.print("\n");
        }
    }

}
