package cn.yw.video.videochannelset.service;


import java.sql.SQLException;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.base.bean.BaseService;
import cn.base.util.CommUtils;
import cn.base.util.DateUtil;
import cn.base.util.Struts2Utils;
import cn.bsystem.ptuserrole.model.PtyhBean;
import cn.yw.video.videochannelset.dao.SbtdspsrDao;

@Service("sbtdspsrService")
public class SbtdspsrService extends BaseService {
	
	private static Log log = LogFactory.getLog(SbtdspsrService.class);
	
	@Autowired
	private SbtdspsrDao sbtdspsrDao;
	
	/**
	 * ¼
	 */
	public void insert_Sbtdspsr(Map map) throws SQLException{
		CommUtils.addParams(map, false);
		sbtdspsrDao.insert_Sbtdspsr(map);
	}

	
	/**
	 * ޸ļ¼
	 */
	public Integer update_Sbtdspsr(Map map) throws SQLException{
		CommUtils.validateUpdateParams(map);
		CommUtils.addParams(map, true);
		return sbtdspsrDao.update_Sbtdspsr(map);
	}
	
	/**
	 * ɾ¼
	 */
	public Integer delete_Sbtdspsr(Map map) throws SQLException{
		CommUtils.validateDeleteParams(map);
		return sbtdspsrDao.delete_Sbtdspsr(map);
	}
	
	/**
	 * ɾ¼
	 */
	/*
	public Integer batch_delete_Sbtdspsr(Map map) throws SQLException{
		return sbtdspsrDao.batch_delete_Sbtdspsr(map);
	}
	*/
	
	/**
	 * ѯ
	 */
	public Integer count_Sbtdspsr(Map map) throws SQLException{
		return sbtdspsrDao.count_Sbtdspsr(map);
	}
	
	/**
	 * ѯб¼SELECT
	 */
	public List<Map> query_Sbtdspsr(Map map) throws SQLException{
		return sbtdspsrDao.query_Sbtdspsr(map);
	}
	
	/**
	 * ѯһ
	 */
	 
	/*
	public Map get_Sbtdspsr(Map map) throws SQLException{
		return sbtdspsrDao.get_Sbtdspsr(map);
	}
	*/
	
	/**
	 * EXCEL
	 */
	 
	/*
	public Map exportSbtdspsr(Map map) throws SQLException{
		return this.listSbtdspsrByPage(map);
	}
	*/
	
	/**
	 * Sbtdspsr ҳ
	 */
	public Map listSbtdspsrByPage(Map map) throws SQLException {
		List<Map> list = sbtdspsrDao.query_Sbtdspsr(map);
		Integer totalCount = sbtdspsrDao.count_Sbtdspsr(map);
		map.clear();
		map.put("total", totalCount);
		map.put("rows", list);
		return map;
	}

	public Map query_Sbtdspsr_tdxx_ext(Map map) throws SQLException {
		List<Map> list = sbtdspsrDao.query_Sbtdspsr_tdxx_ext(map);
		Integer totalCount = sbtdspsrDao.count_Sbtdspsr_tdxx_ext(map);
		map.clear();
		map.put("total", totalCount);
		map.put("rows", list);
		return map;
	}

	public Map listSbtdspsrToChannelSet(Map map) throws SQLException {
		List<Map> list = sbtdspsrDao.listSbtdspsrToChannelSet(map);
		Integer totalCount = sbtdspsrDao.countSbtdspsrToChannelSet(map);
		map.clear();
		map.put("total", totalCount);
		map.put("rows", list);
		return map;
	}
	
	
	// Ŀ¼
	public List<Map> query_Sbtdspsr_ext(Map map) throws SQLException{
		return sbtdspsrDao.query_Sbtdspsr_ext(map);
	}
	public Integer count_Sbtdspsr_ext(Map map) throws SQLException{
		return sbtdspsrDao.count_Sbtdspsr_ext(map);
	}
	
	/**
	 * ޸ļ¼
	 */
	public Integer batch_update_Sbtdspsr_xh(String xhs,String xzbh) throws SQLException{
		return sbtdspsrDao.batch_update_Sbtdspsr_xh(xhs,xzbh);
	}
	public Integer batch_delete_Sbtdspsr_xh(String xhs,String szbh) throws SQLException{
		return sbtdspsrDao.batch_delete_Sbtdspsr_xh(xhs,szbh);
	}
	
	// Ŀ¼ʹ 
	public Integer update_SbtdspsrByXzbh(Map map) throws SQLException{
		return sbtdspsrDao.update_SbtdspsrByXzbh(map);
	}

	public Map get_SbtdspsrDetail(Map map) throws SQLException{
		return sbtdspsrDao.get_SbtdspsrDetail(map);
	}

	public Integer updateJdWdByXh(Map map) throws SQLException{
		CommUtils.validateUpdateParams(map);
		CommUtils.addParams(map, true);
		String username = ((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo")).getYhmc();
		map.put("xgry", username);
		map.put("xgrq", DateUtil.currentDateTime());
		return sbtdspsrDao.updateJdWdByXh(map);
	}

	public Map getSbtdspsrList(Map map) throws SQLException {
		List<Map> list = sbtdspsrDao.getSbtdspsrList(map);
		Integer totalCount = sbtdspsrDao.getSbtdspsrCount(map);
		map.clear();
		map.put("total", totalCount);
		map.put("rows", list);
		return map;
	}
}
