package cn.datasource;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import java.lang.reflect.Method;

@Aspect
@Order(1)
public class DynamicDataSourceAspect {


    @After("@annotation(DS)")
    public void afterSwitchDS(JoinPoint point){

        System.out.println("ǰԴ"+DatabaseContextHolder.getDB());
        DatabaseContextHolder.clearDB();

    }

//*/

//ʹDSע⶯̬л

    @Before("@annotation(DS)")
    public void beforeSwitchDS(JoinPoint point){
        //õǰʵclass
        Class<?> className = point.getTarget().getClass();
        //÷ʵķ
        String methodName = point.getSignature().getName();
        //õĲ
        Class[] argClass = ((MethodSignature)point.getSignature()).getParameterTypes();
        String dataSource = DatabaseContextHolder.DEFAULT_DS;
        try {
            // õʵķ
            Method method = className.getMethod(methodName, argClass);
            // жǷ@DSע
            if (method.isAnnotationPresent(DS.class)) {
                DS annotation = method.getAnnotation(DS.class);
                // ȡעеԴ
                dataSource = annotation.value();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        // лԴ
        DatabaseContextHolder.setDB(dataSource);
    }
}
