package cn.bsystem.ptlogin.dao;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;

import javax.annotation.PostConstruct;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;
import org.springframework.stereotype.Repository;

import cn.bsystem.ptuserrole.model.PtyhBean;

import com.ibatis.sqlmap.client.SqlMapClient;

@SuppressWarnings({"all"})
@Repository("loginDao")
public class LoginDAO extends SqlMapClientDaoSupport {
	@Autowired 
    private SqlMapClient sqlMapClient;
      
	@PostConstruct          
    public  void initSqlMapClient(){  
     super.setSqlMapClient(sqlMapClient);      
    }
	
	public Object checkUserAccount(Map map){
		return this.getSqlMapClientTemplate().queryForObject("",map);
	}
	public void updateLastLoginTime(String adminname) throws SQLException {
		this.getSqlMapClient().update("cmsAdmin_updateLastLoginTime", adminname);
	}
//	
//	@Override
//	public void updateCmsAdminPassword(CmsAdmin cmsAdmin) throws SQLException {
//		this.getSqlMapClient().update("cmsAdmin_updatePasswd", cmsAdmin);
//	}
	/***
	 * ѯ¼  PCSTABLE
	 * @throws SQLException 
	 */
	public List selectUserRole(Map map) throws SQLException{
		return this.getSqlMapClient().queryForList("query_Pcstable", map);
	}
	/***
	 * ѯ¼û  
	 * @throws SQLException 
	 */
	public List selectUser(Map map) throws SQLException{
		return this.getSqlMapClient().queryForList("_query",map);
	}
	/***
	 * ѯ¼ûϢ  
	 * @throws SQLException 
	 */
	public PtyhBean selectUserInfo(Map map) throws SQLException{
		return (PtyhBean) this.getSqlMapClient().queryForObject("query_PtyhBean", map);
	}
	/***
	 * ޸ĵ¼  
	 * @throws SQLException 
	 */
	public int updatePasswd(Map map) throws SQLException{
		return this.getSqlMapClient().update("update_Password", map);
	}
}
