package cn.bsystem.ptlogin.action;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.util.CommUtils;
import cn.base.util.Constants;
import cn.base.util.LogConstants;
import cn.base.util.MD5Util;
import cn.base.util.StringUtil;
import cn.base.util.Struts2Utils;
import cn.bsystem.ptlogin.service.LoginService;
import cn.bsystem.ptuserrole.model.PtyhBean;

@SuppressWarnings("all")
@Component("loginAction")
public class LoginAction extends BaseAction{

	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(LoginAction.class);
	
	@Autowired 
	private LoginService service;
 
	/***
	 * ֤˻¼  
	 */
	@OperateType(value = LogConstants.LOG_LOGIN ,info ="userloginValidation")
	public String userloginValidation(){
		String result = Constants.ERROR;
		try {
			String username = Struts2Utils.getParameter("username");
			String password = Struts2Utils.getParameter("password");
			String encode = Struts2Utils.getParameter("encode");
			if(!CommUtils.isEmpty(username) &&  !CommUtils.isEmpty(password)){
				Map map = new HashMap();
				map.put("yhzh",username);
//				map.put("yhmm",password);
				PtyhBean user = service.userloginValidation(map);
				
				if(user == null){
					result = Constants.FAIL;
				}else{
					if(user.getYhzt()==1){
						result = Constants.LOCK;
					}else{
						if(StringUtils.isBlank(encode)){
							password = MD5Util.md5(password);
						}
						boolean b = password.equals(user.getYhmm());
						if(!b){
							result = Constants.ERROR;
						} else{
							result = Constants.SUCCESS;
							Struts2Utils.getSession().setAttribute("userInfo", user);
						}
					}
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("userloginValidation:"+e);
		}
		Struts2Utils.renderText(result);
		return null;
	}
	
	/***
	 *  õ¼ûϸϢ
	 */
	public String getUserInfo() {
		PtyhBean userInfo = null;
		try {
			userInfo =  (PtyhBean) Struts2Utils.getSession().getAttribute("userInfo");
//			if(userInfo!=null) userInfo.setYhmm("");
		} catch(Exception e){
			e.printStackTrace();
			iLog.error("getUserInfo:"+e);
		}
		Struts2Utils.renderJson(userInfo);
		return null;
	}
	
	/***
	 *  õ¼ûϸϢ
	 */
	public PtyhBean getUser() {
		PtyhBean userInfo = null;
		try {
			userInfo =  (PtyhBean) Struts2Utils.getSession().getAttribute("userInfo");
		} catch(Exception e){
			e.printStackTrace();
			iLog.error("getUser:"+e);
		}
		return userInfo;
	}
	
	/***
	 *  õǰûŵϸϢ
	 */
	public void getUserWithRole() {
		PtyhBean userInfo = null;
		List<Map<String, Object>> list = null;
		/*try {
			userInfo =  (PtyhBean) Struts2Utils.getSession().getAttribute("userInfo");
			Map map = new HashMap();
			map.put("userid", userInfo.getUserid());
			list = MapTreeServiceUtil.getInstance().getEmployeemaptreeList(map, Constants.TREETYPE_BUMEN);
		} catch(Exception e){
			e.printStackTrace();
			iLog.error("getUserWithRole:"+e);
		}*/
		Struts2Utils.renderJson(list);
	}
	
	/***
	 *  ûǳ
	 */
	public void logOut() {
		try{
			Struts2Utils.getSession().invalidate();
		} catch(Exception e){
			e.printStackTrace();
			iLog.error("logOut:"+e);
		}
		Struts2Utils.renderJson(Constants.SUCCESS);
	}
	/***
	 *  ޸û
	 */
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="updateUserPassword")
	public void updateUserPassword() {
		String result = null;
		try{
			String oldPasswd = Struts2Utils.getParameter("oldPasswd");
			String newPasswd = Struts2Utils.getParameter("newPasswd");
			if(StringUtils.isNotEmpty(newPasswd)){
				newPasswd = MD5Util.md5(newPasswd);
			}
			if(StringUtils.isNotEmpty(oldPasswd)){
				oldPasswd = MD5Util.md5(oldPasswd);
			}
			if(!StringUtil.isNotBlank(newPasswd)  || !StringUtil.isNotBlank(oldPasswd) ){
				result = "failed";
			}else{
//				CoptableBean userInfo = (CoptableBean)Struts2Utils.getSession().getAttribute("userInfo");
//				String userPasswd = userInfo.getDlmm();
//				Integer bianhao = userInfo.getBianhao();
//				Map updatePasswd = new HashMap();
//				updatePasswd.put("dlmm", newPasswd);
//				updatePasswd.put("bianhao", bianhao);
//				if(!userPasswd.equals(oldPasswd)){
//					result = "oldPwd";
//				}else if(this.getService().updatePasswd(updatePasswd)>0){
//					result = "true";
//				}else{
					result = "failed";
//				}
				PtyhBean userInfo = (PtyhBean)Struts2Utils.getSession().getAttribute("userInfo");
				if(userInfo==null){
					Struts2Utils.renderText("expiry");
				}
				boolean b = oldPasswd.equals(userInfo.getYhmm());
				if(!b){
					Struts2Utils.renderText("errorMm");//
				} else{
					if(StringUtils.isEmpty(userInfo.getYhbh())){
						Struts2Utils.renderText("expiry");//½
					}else{
						Map updatePasswdMap = new HashMap();
						updatePasswdMap.put("yhmm", newPasswd);
						updatePasswdMap.put("yhbh", userInfo.getYhbh());
						service.updatePasswd(updatePasswdMap);
						userInfo.setYhmm(newPasswd);
						Struts2Utils.getSession().setAttribute("userInfo", userInfo);
						System.out.println((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo"));
						Struts2Utils.renderText("success");
					}
				}	
			}
		} catch(Exception e){
			e.printStackTrace();
			iLog.error("LoginActionupdateUserPassword() erro:"+e);
		}
//		Struts2Utils.renderText(result);
	}
}
