package cn.bsystem.Test.action;

import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.util.*;
import cn.bsystem.Test.server.LoginFrameService;
import cn.bsystem.ptuserrole.model.PtyhBean;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

@SuppressWarnings("all")
@Component("loginFrameAction")
public class LoginFrameAction extends BaseAction {
    private static final long serialVersionUID = 1L;
    private static Logger iLog = Logger.getLogger(LoginFrameAction.class);


    @Autowired
    private LoginFrameService service  ;

    @OperateType(value = LogConstants.LOG_LOGIN ,info ="login")
    public String login(){
        String result = Constants.ERROR;
        try {
            String username = Struts2Utils.getParameter("username");
            String password = Struts2Utils.getParameter("password");
            String encode = Struts2Utils.getParameter("encode");
            if(!CommUtils.isEmpty(username) &&  !CommUtils.isEmpty(password)){
                Map map = new HashMap();
                map.put("yhzh",username);
                PtyhBean user = service.login(map);
                if(user == null){
                    result = Constants.FAIL;
                }else{
                    if(user.getYhzt()==1){
                        result = Constants.LOCK;
                    }else{
                        if(StringUtils.isBlank(encode)){
                            password = MD5Util.md5(password);
                        }
                        boolean b = password.equals(user.getYhmm());
                        if(!b){
                            result = Constants.ERROR;
                        } else{
                            result = Constants.SUCCESS;
                            Struts2Utils.getSession().setAttribute("userInfo", user);
                        }
                    }
                }
            }
        } catch (Exception e) {
            //e.printStackTrace();
            iLog.error("userloginValidation:"+e);
        }
        Struts2Utils.renderText(result);
        return null;
    }
}
