package cn.acx;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import org.apache.log4j.Logger;

import Ice.Communicator;
import Ice.InitializationData;
import Ice.ObjectPrx;
import Ice.Util;
import cn.base.conf.Dac;
import cn.base.conf.ModuleConfFactory;
import cn.base.conf.Node;
import cn.ice.autoDef.PtyhEntityHolder;
import cn.ice.dac.DacServicePrx;
import cn.ice.dac.DacServicePrxHelper;

import com.jtiny.msgthread.JtinyMsgThread;
import com.jtiny.utility.JtinyEvent;

public class IcxDacClient extends JtinyMsgThread {

	static Logger logger = Logger.getLogger(IcxDacClient.class);

	private DacServicePrx dacServicePrx = null;

	public int init(String dacIp, String dacPort) {
		Ice.Communicator ic = null;
		InitializationData initData = new InitializationData();
		Ice.Properties properties = Util.createProperties();
		for (int i = 0; i < ModuleConfFactory.getInstance().getIce().getList().size(); i++) {
			Node node = ModuleConfFactory.getInstance().getIce().getList().get(i);
			String name = node.getName();
			String value = node.getValue();
			properties.setProperty(name, value);
		}
		initData.properties = properties;
		try {
			ic = Util.initialize(initData);
			ObjectPrx dacServiceBase = ic.stringToProxy("DacService:default -h " + dacIp + " -p " + dacPort);
			logger.debug("************Execute dac client init,host=" + dacIp + " port=" + dacPort);
			this.dacServicePrx = DacServicePrxHelper.checkedCast(dacServiceBase);
//			 DacServicePrx vlPrx = DacServicePrxHelper.checkedCast(dacServiceBase);
			logger.debug("************Execut dac client init success... ...");
		} catch (Exception e) {
			if (ic != null)
				ic.destroy();
			logger.error(getStackTraceAsString(e));
			return 1;
		}
		return 0;
	}

	public static String getStackTraceAsString(Throwable e) {
		if (e == null)
			return null;
		StringWriter stringWriter = new StringWriter();
		PrintWriter printWriter = new PrintWriter(stringWriter);
		e.printStackTrace(printWriter);
		StringBuffer error = stringWriter.getBuffer();
		return error.toString();
	}

	public void handleEvent(JtinyEvent eventBlock) {
		switch (eventBlock.getMsgId()) {
			case AcxConst.CLIENT_CONNECT_MSG: {
				Dac dac = ModuleConfFactory.getInstance().getDac();
				logger.debug("******************Connecting dacIp Server host="+ dac.getDacIp() + " port=" + dac.getPort());
				this.init(dac.getDacIp(), dac.getPort());
				if (dacServicePrx == null) {
					JtinyEvent jtinyEvent = new JtinyEvent(AcxConst.CLIENT_CONNECT_MSG, 0, 0, null, null, null);
					this.registerTimer(jtinyEvent, 1000 * 5);
				}
				logger.debug("********************Connected dac Server success... ...[0k]");
				break;
			}
			default: {
				logger.warn("IcxVasClient: unknow message!");
				break;
			}
		}
	}

	public DacServicePrx getDacServicePrx() {
		return dacServicePrx;
	}

	public static void main(String[] args) {
		System.out.println("ddddddd1ddddddd");
		Communicator ic = null;
		 try {
				InitializationData initData = new InitializationData();
				Ice.Properties properties = Util.createProperties();
			 properties.setProperty("Ice.ThreadPool.Server.SizeMax","40");
				properties.setProperty("Ice.ThreadPool.Server.SizeWarn","40");
				properties.setProperty("Ice.MessageSizeMax","2048000");
				properties.setProperty("Ice.Override.Timeout","30000");
				initData.properties=properties;
				ic = Util.initialize(initData);
//		 ObjectPrx uasServiceBase = ic.stringToProxy("DacService:default -h 47.97.115.14 -p 11100");
		 //ObjectPrx uasServiceBase = ic.stringToProxy("DacService:default -p 11100");
		 ObjectPrx uasServiceBase = ic.stringToProxy("DacService:default -h 10.10.10.203 -p 9900");
//		 ObjectPrx uasServiceBase = ic.stringToProxy("DacService:default -h 192.168.8.59 -p 11100");
		 System.out.println("dddddd2dddddddd"+"===="+uasServiceBase);
		 DacServicePrx vlPrx = DacServicePrxHelper.checkedCast(uasServiceBase);
		 long time1 = new Date().getTime();
		 int loginret=0;
		 java.util.Map<String,String> keyMap=new HashMap<String,String>();
		//¼ԣ
		 System.out.println("ddddddd3ddddddd");
		 PtyhEntityHolder ptyhEntityHolder =new PtyhEntityHolder();
		 keyMap=new HashMap<String,String>();
		 keyMap.put("yhzh", "linhg");
		 keyMap.put("yhmm","1234");
		 loginret=vlPrx.userLogin(keyMap, ptyhEntityHolder);
		 System.out.println("=[PAC¼]=iceRet="+loginret+"=[0:ɹ]=");
		 
		 Map map = new HashMap();
		 map.put("yhzh", "dac"); 
		 cn.ice.autoDef.SbtdspsrEntityArrayHolder holder = new  cn.ice.autoDef.SbtdspsrEntityArrayHolder();
		 int xx = vlPrx.queryVideoInChannelArray(map, holder);
		 
		 System.out.println("=qqqqqqqqqqqqqqqqqqqqqq="+xx+"==");
		 cn.ice.autoDef.SbtdspsrEntity[] eee  = holder.value;
		 System.out.println(eee[0].tdmc);
		  
		 }catch (Exception e){
			 System.out.println("ddddddd4dddddd"+e.getMessage());
		 }
		 /*
		IcxDacClient icxDacClient = new IcxDacClient();
		icxDacClient.init("10.10.10.203", "9900");
		TextSms textSms = new TextSms();
		textSms.callee = "13588465623";
		textSms.smsContent = "hello44444 world ppp";
		Map m = new HashMap();
		SbtdspsrEntityArrayHolder sbtdspsrEntityArray = new SbtdspsrEntityArrayHolder();
		icxDacClient.getDacServicePrx().queryVideoInChannelArray(m,sbtdspsrEntityArray);
		System.out.println("dddddddddddddd");
		
		 
		IcxDacClient icxDacClient = new IcxDacClient();
		icxDacClient.init("10.10.10.203", "9900");
		TextSms textSms = new TextSms();
		textSms.callee = "13588465623";
		textSms.smsContent = "hello44444 world ppp";
		Map m = new HashMap();
		SbtdspsrEntityArrayHolder sbtdspsrEntityArray = new SbtdspsrEntityArrayHolder();
		icxDacClient.getDacServicePrx().queryVideoInChannelArray(m,sbtdspsrEntityArray);
		System.out.println("dddddddddddddd");
		*/
	}
}
